/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.AddDelegateMethodsOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ui.CodeGeneration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StubUtility2 {
    public static void addOverrideAnnotation(IJavaProject project, ASTRewrite rewrite, MethodDeclaration decl, IMethodBinding binding) {
        if (binding.getDeclaringClass().isInterface()) {
            String version = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
            if (JavaModelUtil.isVersionLessThan(version, "1.6")) {
                return;
            }
            if ("disabled".equals(project.getOption("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", true))) {
                return;
            }
        }
        MarkerAnnotation marker = rewrite.getAST().newMarkerAnnotation();
        marker.setTypeName((Name)rewrite.getAST().newSimpleName("Override"));
        rewrite.getListRewrite((ASTNode)decl, MethodDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)marker, null);
    }

    public static MethodDeclaration createConstructorStub(ICompilationUnit unit, ASTRewrite rewrite, ImportRewrite imports, ImportRewrite.ImportRewriteContext context, IMethodBinding binding, String type, int modifiers, boolean omitSuperForDefConst, boolean todo, CodeGenerationSettings settings) throws CoreException {
        String string;
        AST ast = rewrite.getAST();
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.modifiers().addAll(ASTNodeFactory.newModifiers(ast, modifiers & 0xFFFFFBFF & 0xFFFFFEFF));
        decl.setName(ast.newSimpleName(type));
        decl.setConstructor(true);
        StubUtility2.createTypeParameters(imports, context, ast, binding, decl);
        List<SingleVariableDeclaration> parameters = StubUtility2.createParameters(unit.getJavaProject(), imports, context, ast, binding, null, decl);
        StubUtility2.createThrownExceptions(decl, binding, imports, context, ast);
        Block body = ast.newBlock();
        decl.setBody(body);
        String delimiter = StubUtility.getLineDelimiterUsed((IJavaElement)unit);
        String bodyStatement = "";
        if (!omitSuperForDefConst || !parameters.isEmpty()) {
            SuperConstructorInvocation invocation = ast.newSuperConstructorInvocation();
            SingleVariableDeclaration varDecl2 = null;
            for (SingleVariableDeclaration varDecl2 : parameters) {
                invocation.arguments().add(ast.newSimpleName(varDecl2.getName().getIdentifier()));
            }
            bodyStatement = ASTNodes.asFormattedString((ASTNode)invocation, 0, delimiter, unit.getJavaProject().getOptions(true));
        }
        if (todo) {
            String placeHolder = CodeGeneration.getMethodBodyContent(unit, type, binding.getName(), true, bodyStatement, delimiter);
            if (placeHolder != null) {
                ReturnStatement todoNode = (ReturnStatement)rewrite.createStringPlaceholder(placeHolder, 41);
                body.statements().add(todoNode);
            }
        } else {
            ReturnStatement statementNode = (ReturnStatement)rewrite.createStringPlaceholder(bodyStatement, 41);
            body.statements().add(statementNode);
        }
        if (settings != null && settings.createComments && (string = CodeGeneration.getMethodComment(unit, type, decl, binding, delimiter)) != null) {
            Javadoc javadoc = (Javadoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        return decl;
    }

    public static MethodDeclaration createConstructorStub(ICompilationUnit unit, ASTRewrite rewrite, ImportRewrite imports, ImportRewrite.ImportRewriteContext context, ITypeBinding typeBinding, IMethodBinding superConstructor, IVariableBinding[] variableBindings, int modifiers, CodeGenerationSettings settings) throws CoreException {
        String string;
        AST ast = rewrite.getAST();
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.modifiers().addAll(ASTNodeFactory.newModifiers(ast, modifiers & 0xFFFFFBFF & 0xFFFFFEFF));
        decl.setName(ast.newSimpleName(typeBinding.getName()));
        decl.setConstructor(true);
        List parameters = decl.parameters();
        if (superConstructor != null) {
            StubUtility2.createTypeParameters(imports, context, ast, superConstructor, decl);
            StubUtility2.createParameters(unit.getJavaProject(), imports, context, ast, superConstructor, null, decl);
            StubUtility2.createThrownExceptions(decl, superConstructor, imports, context, ast);
        }
        Block body = ast.newBlock();
        decl.setBody(body);
        String delimiter = StubUtility.getLineDelimiterUsed((IJavaElement)unit);
        if (superConstructor != null) {
            SuperConstructorInvocation invocation = ast.newSuperConstructorInvocation();
            SingleVariableDeclaration varDecl2 = null;
            for (SingleVariableDeclaration varDecl2 : parameters) {
                invocation.arguments().add(ast.newSimpleName(varDecl2.getName().getIdentifier()));
            }
            body.statements().add(invocation);
        }
        ArrayList<String> prohibited = new ArrayList<String>();
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            prohibited.add(((SingleVariableDeclaration)iterator.next()).getName().getIdentifier());
        }
        String param = null;
        ArrayList<String> list = new ArrayList<String>(prohibited);
        String[] excluded = null;
        int i = 0;
        while (i < variableBindings.length) {
            SingleVariableDeclaration var = ast.newSingleVariableDeclaration();
            var.setType(imports.addImport(variableBindings[i].getType(), ast, context));
            excluded = new String[list.size()];
            list.toArray(excluded);
            param = StubUtility2.suggestParameterName(unit, variableBindings[i], excluded);
            list.add(param);
            var.setName(ast.newSimpleName(param));
            parameters.add(var);
            ++i;
        }
        list = new ArrayList(prohibited);
        i = 0;
        while (i < variableBindings.length) {
            excluded = new String[list.size()];
            list.toArray(excluded);
            String paramName = StubUtility2.suggestParameterName(unit, variableBindings[i], excluded);
            list.add(paramName);
            String fieldName = variableBindings[i].getName();
            SimpleName expression = null;
            if (paramName.equals(fieldName) || settings.useKeywordThis) {
                FieldAccess access = ast.newFieldAccess();
                access.setExpression((Expression)ast.newThisExpression());
                access.setName(ast.newSimpleName(fieldName));
                expression = access;
            } else {
                expression = ast.newSimpleName(fieldName);
            }
            Assignment assignment = ast.newAssignment();
            assignment.setLeftHandSide((Expression)expression);
            assignment.setRightHandSide((Expression)ast.newSimpleName(paramName));
            assignment.setOperator(Assignment.Operator.ASSIGN);
            body.statements().add(ast.newExpressionStatement((Expression)assignment));
            ++i;
        }
        if (settings != null && settings.createComments && (string = CodeGeneration.getMethodComment(unit, typeBinding.getName(), decl, superConstructor, delimiter)) != null) {
            Javadoc javadoc = (Javadoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        return decl;
    }

    public static MethodDeclaration createDelegationStub(ICompilationUnit unit, ASTRewrite rewrite, ImportRewrite imports, ImportRewrite.ImportRewriteContext context, IMethodBinding delegate, IVariableBinding delegatingField, CodeGenerationSettings settings) throws CoreException {
        Assert.isNotNull((Object)delegate);
        Assert.isNotNull((Object)delegatingField);
        Assert.isNotNull((Object)settings);
        AST ast = rewrite.getAST();
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.modifiers().addAll(ASTNodeFactory.newModifiers(ast, delegate.getModifiers() & 0xFFFFFFDF & 0xFFFFFBFF & 0xFFFFFEFF));
        decl.setName(ast.newSimpleName(delegate.getName()));
        decl.setConstructor(false);
        StubUtility2.createTypeParameters(imports, context, ast, delegate, decl);
        decl.setReturnType2(imports.addImport(delegate.getReturnType(), ast, context));
        List<SingleVariableDeclaration> params = StubUtility2.createParameters(unit.getJavaProject(), imports, context, ast, delegate, null, decl);
        StubUtility2.createThrownExceptions(decl, delegate, imports, context, ast);
        Block body = ast.newBlock();
        decl.setBody(body);
        String delimiter = StubUtility.getLineDelimiterUsed((IJavaElement)unit);
        ReturnStatement statement = null;
        MethodInvocation invocation = ast.newMethodInvocation();
        invocation.setName(ast.newSimpleName(delegate.getName()));
        List arguments = invocation.arguments();
        int i = 0;
        while (i < params.size()) {
            arguments.add(ast.newSimpleName(params.get(i).getName().getIdentifier()));
            ++i;
        }
        if (settings.useKeywordThis) {
            FieldAccess access = ast.newFieldAccess();
            access.setExpression((Expression)ast.newThisExpression());
            access.setName(ast.newSimpleName(delegatingField.getName()));
            invocation.setExpression((Expression)access);
        } else {
            invocation.setExpression((Expression)ast.newSimpleName(delegatingField.getName()));
        }
        if (delegate.getReturnType().isPrimitive() && delegate.getReturnType().getName().equals("void")) {
            statement = ast.newExpressionStatement((Expression)invocation);
        } else {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression((Expression)invocation);
            statement = returnStatement;
        }
        body.statements().add(statement);
        ITypeBinding declaringType = delegatingField.getDeclaringClass();
        if (declaringType == null) {
            return decl;
        }
        String qualifiedName = declaringType.getQualifiedName();
        IPackageBinding packageBinding = declaringType.getPackage();
        if (packageBinding != null && packageBinding.getName().length() > 0 && qualifiedName.startsWith(packageBinding.getName())) {
            qualifiedName = qualifiedName.substring(packageBinding.getName().length());
        }
        if (settings.createComments) {
            delegate = delegate.getMethodDeclaration();
            String declaringClassQualifiedName = delegate.getDeclaringClass().getQualifiedName();
            String linkToMethodName = delegate.getName();
            String[] parameterTypesQualifiedNames = StubUtility.getParameterTypeNamesForSeeTag(delegate);
            String string = StubUtility.getMethodComment(unit, qualifiedName, decl, delegate.isDeprecated(), linkToMethodName, declaringClassQualifiedName, parameterTypesQualifiedNames, true, delimiter);
            if (string != null) {
                Javadoc javadoc = (Javadoc)rewrite.createStringPlaceholder(string, 29);
                decl.setJavadoc(javadoc);
            }
        }
        return decl;
    }

    public static MethodDeclaration createImplementationStub(ICompilationUnit unit, ASTRewrite rewrite, ImportRewrite imports, ImportRewrite.ImportRewriteContext context, IMethodBinding binding, String type, CodeGenerationSettings settings, boolean inInterface) throws CoreException {
        return StubUtility2.createImplementationStub(unit, rewrite, imports, context, binding, null, type, settings, inInterface);
    }

    public static MethodDeclaration createImplementationStub(ICompilationUnit unit, ASTRewrite rewrite, ImportRewrite imports, ImportRewrite.ImportRewriteContext context, IMethodBinding binding, String[] parameterNames, String type, CodeGenerationSettings settings, boolean inInterface) throws CoreException {
        String string;
        Assert.isNotNull((Object)imports);
        Assert.isNotNull((Object)rewrite);
        AST ast = rewrite.getAST();
        MethodDeclaration decl = ast.newMethodDeclaration();
        decl.modifiers().addAll(StubUtility2.getImplementationModifiers(ast, binding, inInterface, imports, context));
        decl.setName(ast.newSimpleName(binding.getName()));
        decl.setConstructor(false);
        ITypeBinding bindingReturnType = binding.getReturnType();
        if (bindingReturnType.isWildcardType()) {
            ITypeBinding bound = bindingReturnType.getBound();
            ITypeBinding iTypeBinding = bindingReturnType = bound != null ? bound : bindingReturnType.getErasure();
        }
        if (JavaModelUtil.is50OrHigher(unit.getJavaProject())) {
            StubUtility2.createTypeParameters(imports, context, ast, binding, decl);
        } else {
            bindingReturnType = bindingReturnType.getErasure();
        }
        decl.setReturnType2(imports.addImport(bindingReturnType, ast, context));
        List<SingleVariableDeclaration> parameters = StubUtility2.createParameters(unit.getJavaProject(), imports, context, ast, binding, parameterNames, decl);
        StubUtility2.createThrownExceptions(decl, binding, imports, context, ast);
        String delimiter = unit.findRecommendedLineSeparator();
        if (!inInterface) {
            String placeHolder;
            Map options = unit.getJavaProject().getOptions(true);
            Block body = ast.newBlock();
            decl.setBody(body);
            String bodyStatement = "";
            ITypeBinding declaringType = binding.getDeclaringClass();
            if (Modifier.isAbstract((int)binding.getModifiers()) || declaringType.isAnnotation() || declaringType.isInterface()) {
                Expression expression = ASTNodeFactory.newDefaultExpression(ast, decl.getReturnType2(), decl.getExtraDimensions());
                if (expression != null) {
                    ReturnStatement returnStatement = ast.newReturnStatement();
                    returnStatement.setExpression(expression);
                    bodyStatement = ASTNodes.asFormattedString((ASTNode)returnStatement, 0, delimiter, options);
                }
            } else {
                SuperMethodInvocation invocation = ast.newSuperMethodInvocation();
                invocation.setName(ast.newSimpleName(binding.getName()));
                SingleVariableDeclaration varDecl2 = null;
                for (SingleVariableDeclaration varDecl2 : parameters) {
                    invocation.arguments().add(ast.newSimpleName(varDecl2.getName().getIdentifier()));
                }
                SuperMethodInvocation expression = invocation;
                Type returnType = decl.getReturnType2();
                if (returnType instanceof PrimitiveType && ((PrimitiveType)returnType).getPrimitiveTypeCode().equals(PrimitiveType.VOID)) {
                    bodyStatement = ASTNodes.asFormattedString((ASTNode)ast.newExpressionStatement((Expression)expression), 0, delimiter, options);
                } else {
                    ReturnStatement returnStatement = ast.newReturnStatement();
                    returnStatement.setExpression((Expression)expression);
                    bodyStatement = ASTNodes.asFormattedString((ASTNode)returnStatement, 0, delimiter, options);
                }
            }
            if ((placeHolder = CodeGeneration.getMethodBodyContent(unit, type, binding.getName(), false, bodyStatement, delimiter)) != null) {
                ReturnStatement todoNode = (ReturnStatement)rewrite.createStringPlaceholder(placeHolder, 41);
                body.statements().add(todoNode);
            }
        }
        if (settings != null && settings.createComments && (string = CodeGeneration.getMethodComment(unit, type, decl, binding, delimiter)) != null) {
            Javadoc javadoc = (Javadoc)rewrite.createStringPlaceholder(string, 29);
            decl.setJavadoc(javadoc);
        }
        if (settings != null && settings.overrideAnnotation && JavaModelUtil.is50OrHigher(unit.getJavaProject())) {
            StubUtility2.addOverrideAnnotation(unit.getJavaProject(), rewrite, decl, binding);
        }
        return decl;
    }

    private static void createTypeParameters(ImportRewrite imports, ImportRewrite.ImportRewriteContext context, AST ast, IMethodBinding binding, MethodDeclaration decl) {
        ITypeBinding[] typeParams = binding.getTypeParameters();
        List typeParameters = decl.typeParameters();
        int i = 0;
        while (i < typeParams.length) {
            ITypeBinding curr = typeParams[i];
            TypeParameter newTypeParam = ast.newTypeParameter();
            newTypeParam.setName(ast.newSimpleName(curr.getName()));
            ITypeBinding[] typeBounds = curr.getTypeBounds();
            if (typeBounds.length != 1 || !"java.lang.Object".equals(typeBounds[0].getQualifiedName())) {
                List newTypeBounds = newTypeParam.typeBounds();
                int k = 0;
                while (k < typeBounds.length) {
                    newTypeBounds.add(imports.addImport(typeBounds[k], ast, context));
                    ++k;
                }
            }
            typeParameters.add(newTypeParam);
            ++i;
        }
    }

    private static List<SingleVariableDeclaration> createParameters(IJavaProject project, ImportRewrite imports, ImportRewrite.ImportRewriteContext context, AST ast, IMethodBinding binding, String[] paramNames, MethodDeclaration decl) {
        boolean is50OrHigher = JavaModelUtil.is50OrHigher(project);
        List parameters = decl.parameters();
        ITypeBinding[] params = binding.getParameterTypes();
        if (paramNames == null || paramNames.length < params.length) {
            paramNames = StubUtility.suggestArgumentNames(project, binding);
        }
        int i = 0;
        while (i < params.length) {
            IAnnotationBinding[] annotations;
            ITypeBinding type;
            SingleVariableDeclaration var = ast.newSingleVariableDeclaration();
            if (binding.isVarargs() && params[i].isArray() && i == params.length - 1) {
                type = params[i].getElementType();
                if (!is50OrHigher) {
                    type = type.getErasure();
                }
                StringBuffer buffer = new StringBuffer(imports.addImport(type, context));
                int dim = 1;
                while (dim < params[i].getDimensions()) {
                    buffer.append("[]");
                    ++dim;
                }
                var.setType(ASTNodeFactory.newType(ast, buffer.toString()));
                var.setVarargs(true);
            } else {
                type = params[i];
                if (type.isWildcardType()) {
                    ITypeBinding bound = type.getBound();
                    ITypeBinding iTypeBinding = type = bound != null ? bound : type.getErasure();
                }
                if (!is50OrHigher) {
                    type = type.getErasure();
                }
                var.setType(imports.addImport(type, ast, context));
            }
            var.setName(ast.newSimpleName(paramNames[i]));
            IAnnotationBinding[] iAnnotationBindingArray = annotations = binding.getParameterAnnotations(i);
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotationBinding annotation = iAnnotationBindingArray[n2];
                if (StubUtility2.isCopyOnInheritAnnotation(annotation.getAnnotationType(), project)) {
                    var.modifiers().add(imports.addAnnotation(annotation, ast, context));
                }
                ++n2;
            }
            parameters.add(var);
            ++i;
        }
        return parameters;
    }

    private static void createThrownExceptions(MethodDeclaration decl, IMethodBinding method, ImportRewrite imports, ImportRewrite.ImportRewriteContext context, AST ast) {
        ITypeBinding[] excTypes = method.getExceptionTypes();
        if (ast.apiLevel() >= 8) {
            List thrownExceptions = decl.thrownExceptionTypes();
            int i = 0;
            while (i < excTypes.length) {
                Type excType = imports.addImport(excTypes[i], ast, context);
                thrownExceptions.add(excType);
                ++i;
            }
        } else {
            List<Name> thrownExceptions = StubUtility2.getThrownExceptions(decl);
            int i = 0;
            while (i < excTypes.length) {
                String excTypeName = imports.addImport(excTypes[i], context);
                thrownExceptions.add(ASTNodeFactory.newName(ast, excTypeName));
                ++i;
            }
        }
    }

    private static List<Name> getThrownExceptions(MethodDeclaration decl) {
        return decl.thrownExceptions();
    }

    private static IMethodBinding findMethodBinding(IMethodBinding method, List<IMethodBinding> allMethods) {
        int i = 0;
        while (i < allMethods.size()) {
            IMethodBinding curr = allMethods.get(i);
            if (Bindings.isSubsignature(method, curr)) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    private static IMethodBinding findOverridingMethod(IMethodBinding method, List<IMethodBinding> allMethods) {
        int i = 0;
        while (i < allMethods.size()) {
            IMethodBinding curr = allMethods.get(i);
            if (Bindings.areOverriddenMethods(curr, method) || Bindings.isSubsignature(curr, method)) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    private static void findUnimplementedInterfaceMethods(ITypeBinding typeBinding, HashSet<ITypeBinding> visited, ArrayList<IMethodBinding> allMethods, IPackageBinding currPack, ArrayList<IMethodBinding> toImplement) {
        if (visited.add(typeBinding)) {
            IMethodBinding[] typeMethods = typeBinding.getDeclaredMethods();
            int i = 0;
            while (i < typeMethods.length) {
                block7: {
                    IMethodBinding curr = typeMethods[i];
                    Iterator<IMethodBinding> allIter = allMethods.iterator();
                    while (allIter.hasNext()) {
                        IMethodBinding oneMethod = allIter.next();
                        if (Bindings.isSubsignature(oneMethod, curr)) {
                            if (!(!Bindings.isSubsignature(curr, oneMethod) || Bindings.isVisibleInHierarchy(oneMethod, currPack) && oneMethod.getReturnType().getErasure().isSubTypeCompatible(curr.getReturnType().getErasure()))) {
                                allIter.remove();
                                toImplement.remove(oneMethod);
                                continue;
                            }
                            break block7;
                        }
                        if (!Bindings.isSubsignature(curr, oneMethod)) continue;
                        allIter.remove();
                        toImplement.remove(oneMethod);
                    }
                    if (Modifier.isAbstract((int)curr.getModifiers())) {
                        toImplement.add(curr);
                        allMethods.add(curr);
                    }
                }
                ++i;
            }
            ITypeBinding[] superInterfaces = typeBinding.getInterfaces();
            int i2 = 0;
            while (i2 < superInterfaces.length) {
                StubUtility2.findUnimplementedInterfaceMethods(superInterfaces[i2], visited, allMethods, currPack, toImplement);
                ++i2;
            }
        }
    }

    public static AddDelegateMethodsOperation.DelegateEntry[] getDelegatableMethods(ITypeBinding binding) {
        ArrayList<AddDelegateMethodsOperation.DelegateEntry> tuples = new ArrayList<AddDelegateMethodsOperation.DelegateEntry>();
        ArrayList<IMethodBinding> declared = new ArrayList<IMethodBinding>();
        IMethodBinding[] typeMethods = binding.getDeclaredMethods();
        int index = 0;
        while (index < typeMethods.length) {
            declared.add(typeMethods[index]);
            ++index;
        }
        IVariableBinding[] typeFields = binding.getDeclaredFields();
        int index2 = 0;
        while (index2 < typeFields.length) {
            IVariableBinding fieldBinding = typeFields[index2];
            if (fieldBinding.isField() && !fieldBinding.isEnumConstant() && !fieldBinding.isSynthetic()) {
                StubUtility2.getDelegatableMethods(new ArrayList<IMethodBinding>(declared), fieldBinding, fieldBinding.getType(), binding, tuples);
            }
            ++index2;
        }
        return tuples.toArray(new AddDelegateMethodsOperation.DelegateEntry[tuples.size()]);
    }

    private static void getDelegatableMethods(List<IMethodBinding> methods, IVariableBinding fieldBinding, ITypeBinding typeBinding, ITypeBinding binding, List<AddDelegateMethodsOperation.DelegateEntry> result) {
        block9: {
            int offset;
            boolean match;
            block7: {
                block8: {
                    match = false;
                    if (!typeBinding.isTypeVariable()) break block7;
                    ITypeBinding[] typeBounds = typeBinding.getTypeBounds();
                    if (typeBounds.length <= 0) break block8;
                    int i = 0;
                    while (i < typeBounds.length) {
                        StubUtility2.getDelegatableMethods(methods, fieldBinding, typeBounds[i], binding, result);
                        ++i;
                    }
                    break block9;
                }
                ITypeBinding objectBinding = Bindings.findTypeInHierarchy(binding, "java.lang.Object");
                if (objectBinding == null) break block9;
                StubUtility2.getDelegatableMethods(methods, fieldBinding, objectBinding, binding, result);
                break block9;
            }
            IMethodBinding[] candidates = StubUtility2.getDelegateCandidates(typeBinding, binding);
            int index = 0;
            while (index < candidates.length) {
                match = false;
                IMethodBinding methodBinding = candidates[index];
                offset = 0;
                while (offset < methods.size() && !match) {
                    if (Bindings.areOverriddenMethods(methods.get(offset), methodBinding)) {
                        match = true;
                    }
                    ++offset;
                }
                if (!match) {
                    result.add(new AddDelegateMethodsOperation.DelegateEntry(methodBinding, fieldBinding));
                    methods.add(methodBinding);
                }
                ++index;
            }
            ITypeBinding superclass = typeBinding.getSuperclass();
            if (superclass != null) {
                StubUtility2.getDelegatableMethods(methods, fieldBinding, superclass, binding, result);
            }
            ITypeBinding[] superInterfaces = typeBinding.getInterfaces();
            offset = 0;
            while (offset < superInterfaces.length) {
                StubUtility2.getDelegatableMethods(methods, fieldBinding, superInterfaces[offset], binding, result);
                ++offset;
            }
        }
    }

    private static IMethodBinding[] getDelegateCandidates(ITypeBinding binding, ITypeBinding hierarchy) {
        ArrayList<IMethodBinding> allMethods = new ArrayList<IMethodBinding>();
        boolean isInterface = binding.isInterface();
        IMethodBinding[] typeMethods = binding.getDeclaredMethods();
        int index = 0;
        while (index < typeMethods.length) {
            IMethodBinding result;
            int modifiers = typeMethods[index].getModifiers();
            if (!(typeMethods[index].isConstructor() || Modifier.isStatic((int)modifiers) || !isInterface && !Modifier.isPublic((int)modifiers) || (result = Bindings.findOverriddenMethodInHierarchy(hierarchy, typeMethods[index])) != null && Flags.isFinal((int)result.getModifiers()))) {
                ITypeBinding[] parameterBindings = typeMethods[index].getParameterTypes();
                boolean upper = false;
                int offset = 0;
                while (offset < parameterBindings.length) {
                    if (parameterBindings[offset].isWildcardType() && parameterBindings[offset].isUpperbound()) {
                        upper = true;
                    }
                    ++offset;
                }
                if (!upper) {
                    allMethods.add(typeMethods[index]);
                }
            }
            ++index;
        }
        return allMethods.toArray(new IMethodBinding[allMethods.size()]);
    }

    private static List<IExtendedModifier> getImplementationModifiers(AST ast, IMethodBinding method, boolean inInterface, ImportRewrite importRewrite, ImportRewrite.ImportRewriteContext context) throws JavaModelException {
        IMethod iMethod;
        IJavaProject javaProject = importRewrite.getCompilationUnit().getJavaProject();
        int modifiers = method.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF & 0xFFFFFFFD;
        if (inInterface) {
            modifiers &= 0xFFFFFFFB;
            modifiers |= 1;
        }
        IAnnotationBinding[] annotations = method.getAnnotations();
        if (modifiers != 0 && annotations.length > 0 && (iMethod = (IMethod)method.getJavaElement()) != null && JavaElementUtil.isSourceAvailable((ISourceReference)iMethod)) {
            ASTParser parser = ASTParser.newParser((int)8);
            parser.setSource(iMethod.getTypeRoot());
            parser.setIgnoreMethodBodies(true);
            CompilationUnit otherCU = (CompilationUnit)parser.createAST(null);
            ASTNode otherMethod = NodeFinder.perform((ASTNode)otherCU, (ISourceRange)iMethod.getSourceRange());
            if (otherMethod instanceof MethodDeclaration) {
                MethodDeclaration otherMD = (MethodDeclaration)otherMethod;
                ArrayList<IExtendedModifier> result = new ArrayList<IExtendedModifier>();
                List otherModifiers = otherMD.modifiers();
                block0: for (IExtendedModifier otherModifier : otherModifiers) {
                    if (otherModifier instanceof Modifier) {
                        int otherFlag = ((Modifier)otherModifier).getKeyword().toFlagValue();
                        if ((otherFlag & modifiers) == 0) continue;
                        modifiers = ~otherFlag & modifiers;
                        result.addAll(ast.newModifiers(otherFlag));
                        continue;
                    }
                    Annotation otherAnnotation = (Annotation)otherModifier;
                    String n = otherAnnotation.getTypeName().getFullyQualifiedName();
                    IAnnotationBinding[] iAnnotationBindingArray = annotations;
                    int n2 = annotations.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        IAnnotationBinding annotation = iAnnotationBindingArray[n3];
                        ITypeBinding otherAnnotationType = annotation.getAnnotationType();
                        String qn = otherAnnotationType.getQualifiedName();
                        if (qn.endsWith(n) && (qn.length() == n.length() || qn.charAt(qn.length() - n.length() - 1) == '.')) {
                            if (!StubUtility2.isCopyOnInheritAnnotation(otherAnnotationType, javaProject)) continue block0;
                            result.add((IExtendedModifier)importRewrite.addAnnotation(annotation, ast, context));
                            continue block0;
                        }
                        ++n3;
                    }
                }
                result.addAll(ASTNodeFactory.newModifiers(ast, modifiers));
                return result;
            }
        }
        ArrayList<IExtendedModifier> result = new ArrayList<IExtendedModifier>();
        IAnnotationBinding[] iAnnotationBindingArray = annotations;
        int n = annotations.length;
        int n4 = 0;
        while (n4 < n) {
            IAnnotationBinding annotation = iAnnotationBindingArray[n4];
            if (StubUtility2.isCopyOnInheritAnnotation(annotation.getAnnotationType(), javaProject)) {
                result.add((IExtendedModifier)importRewrite.addAnnotation(annotation, ast, context));
            }
            ++n4;
        }
        result.addAll(ASTNodeFactory.newModifiers(ast, modifiers));
        return result;
    }

    public static IMethodBinding[] getOverridableMethods(AST ast, ITypeBinding typeBinding, boolean isSubType) {
        int index;
        int modifiers;
        ArrayList<IMethodBinding> allMethods = new ArrayList<IMethodBinding>();
        IMethodBinding[] typeMethods = typeBinding.getDeclaredMethods();
        int index2 = 0;
        while (index2 < typeMethods.length) {
            modifiers = typeMethods[index2].getModifiers();
            if (!(typeMethods[index2].isConstructor() || Modifier.isStatic((int)modifiers) || Modifier.isPrivate((int)modifiers))) {
                allMethods.add(typeMethods[index2]);
            }
            ++index2;
        }
        ITypeBinding clazz = typeBinding.getSuperclass();
        while (clazz != null) {
            IMethodBinding[] methods = clazz.getDeclaredMethods();
            int offset = 0;
            while (offset < methods.length) {
                int modifiers2 = methods[offset].getModifiers();
                if (!(methods[offset].isConstructor() || Modifier.isStatic((int)modifiers2) || Modifier.isPrivate((int)modifiers2) || StubUtility2.findOverridingMethod(methods[offset], allMethods) != null)) {
                    allMethods.add(methods[offset]);
                }
                ++offset;
            }
            clazz = clazz.getSuperclass();
        }
        clazz = typeBinding;
        while (clazz != null) {
            ITypeBinding[] superInterfaces = clazz.getInterfaces();
            index = 0;
            while (index < superInterfaces.length) {
                StubUtility2.getOverridableMethods(ast, superInterfaces[index], allMethods);
                ++index;
            }
            clazz = clazz.getSuperclass();
        }
        if (typeBinding.isInterface()) {
            StubUtility2.getOverridableMethods(ast, ast.resolveWellKnownType("java.lang.Object"), allMethods);
        }
        if (!isSubType) {
            allMethods.removeAll(Arrays.asList(typeMethods));
        }
        modifiers = 0;
        if (!typeBinding.isInterface()) {
            index = allMethods.size() - 1;
            while (index >= 0) {
                IMethodBinding method = (IMethodBinding)allMethods.get(index);
                modifiers = method.getModifiers();
                if (Modifier.isFinal((int)modifiers)) {
                    allMethods.remove(index);
                }
                --index;
            }
        }
        return allMethods.toArray(new IMethodBinding[allMethods.size()]);
    }

    private static void getOverridableMethods(AST ast, ITypeBinding superBinding, List<IMethodBinding> allMethods) {
        IMethodBinding[] methods = superBinding.getDeclaredMethods();
        int offset = 0;
        while (offset < methods.length) {
            int modifiers = methods[offset].getModifiers();
            if (!(methods[offset].isConstructor() || Modifier.isStatic((int)modifiers) || Modifier.isPrivate((int)modifiers) || StubUtility2.findOverridingMethod(methods[offset], allMethods) != null || Modifier.isStatic((int)modifiers))) {
                allMethods.add(methods[offset]);
            }
            ++offset;
        }
        ITypeBinding[] superInterfaces = superBinding.getInterfaces();
        int index = 0;
        while (index < superInterfaces.length) {
            StubUtility2.getOverridableMethods(ast, superInterfaces[index], allMethods);
            ++index;
        }
    }

    private static String suggestParameterName(ICompilationUnit unit, IVariableBinding binding, String[] excluded) {
        String name = StubUtility.getBaseName(binding, unit.getJavaProject());
        return StubUtility.suggestArgumentName(unit.getJavaProject(), name, excluded);
    }

    public static IMethodBinding[] getUnimplementedMethods(ITypeBinding typeBinding) {
        return StubUtility2.getUnimplementedMethods(typeBinding, false);
    }

    public static IMethodBinding[] getUnimplementedMethods(ITypeBinding typeBinding, boolean implementAbstractsOfInput) {
        int modifiers;
        ArrayList<IMethodBinding> allMethods = new ArrayList<IMethodBinding>();
        ArrayList<IMethodBinding> toImplement = new ArrayList<IMethodBinding>();
        IMethodBinding[] typeMethods = typeBinding.getDeclaredMethods();
        int i = 0;
        while (i < typeMethods.length) {
            IMethodBinding curr = typeMethods[i];
            int modifiers2 = curr.getModifiers();
            if (!(curr.isConstructor() || Modifier.isStatic((int)modifiers2) || Modifier.isPrivate((int)modifiers2))) {
                allMethods.add(curr);
            }
            ++i;
        }
        ITypeBinding superClass = typeBinding.getSuperclass();
        while (superClass != null) {
            typeMethods = superClass.getDeclaredMethods();
            int i2 = 0;
            while (i2 < typeMethods.length) {
                IMethodBinding curr = typeMethods[i2];
                modifiers = curr.getModifiers();
                if (!(curr.isConstructor() || Modifier.isStatic((int)modifiers) || Modifier.isPrivate((int)modifiers) || StubUtility2.findMethodBinding(curr, allMethods) != null)) {
                    allMethods.add(curr);
                }
                ++i2;
            }
            superClass = superClass.getSuperclass();
        }
        int i3 = 0;
        while (i3 < allMethods.size()) {
            IMethodBinding curr = (IMethodBinding)allMethods.get(i3);
            modifiers = curr.getModifiers();
            if ((Modifier.isAbstract((int)modifiers) || curr.getDeclaringClass().isInterface()) && (implementAbstractsOfInput || typeBinding != curr.getDeclaringClass())) {
                toImplement.add(curr);
            }
            ++i3;
        }
        HashSet<ITypeBinding> visited = new HashSet<ITypeBinding>();
        ITypeBinding curr = typeBinding;
        while (curr != null) {
            ITypeBinding[] superInterfaces = curr.getInterfaces();
            int i4 = 0;
            while (i4 < superInterfaces.length) {
                StubUtility2.findUnimplementedInterfaceMethods(superInterfaces[i4], visited, allMethods, typeBinding.getPackage(), toImplement);
                ++i4;
            }
            curr = curr.getSuperclass();
        }
        return toImplement.toArray(new IMethodBinding[toImplement.size()]);
    }

    public static IMethodBinding[] getVisibleConstructors(ITypeBinding binding, boolean accountExisting, boolean proposeDefault) {
        IMethodBinding[] methods;
        ArrayList constructorMethods = new ArrayList();
        ArrayList<IMethodBinding> existingConstructors = null;
        ITypeBinding superType = binding.getSuperclass();
        if (superType == null) {
            return new IMethodBinding[0];
        }
        if (accountExisting) {
            methods = binding.getDeclaredMethods();
            existingConstructors = new ArrayList<IMethodBinding>(methods.length);
            int index = 0;
            while (index < methods.length) {
                IMethodBinding method = methods[index];
                if (method.isConstructor() && !method.isDefaultConstructor()) {
                    existingConstructors.add(method);
                }
                ++index;
            }
        }
        if (existingConstructors != null) {
            constructorMethods.addAll(existingConstructors);
        }
        methods = binding.getDeclaredMethods();
        IMethodBinding[] superMethods = superType.getDeclaredMethods();
        int index = 0;
        while (index < superMethods.length) {
            IMethodBinding method = superMethods[index];
            if (method.isConstructor() && Bindings.isVisibleInHierarchy(method, binding.getPackage()) && (!accountExisting || !Bindings.containsSignatureEquivalentConstructor(methods, method))) {
                constructorMethods.add(method);
            }
            ++index;
        }
        if (existingConstructors != null) {
            constructorMethods.removeAll(existingConstructors);
        }
        if (constructorMethods.isEmpty()) {
            superType = binding;
            while (superType.getSuperclass() != null) {
                superType = superType.getSuperclass();
            }
            IMethodBinding method = Bindings.findMethodInType(superType, "Object", new ITypeBinding[0]);
            if (!(method == null || !proposeDefault && accountExisting && existingConstructors != null && !existingConstructors.isEmpty() || accountExisting && Bindings.containsSignatureEquivalentConstructor(methods, method))) {
                constructorMethods.add(method);
            }
        }
        return constructorMethods.toArray(new IMethodBinding[constructorMethods.size()]);
    }

    public static ASTNode getNodeToInsertBefore(ListRewrite listRewrite, IJavaElement sibling) throws JavaModelException {
        if (sibling instanceof IMember) {
            ISourceRange sourceRange = ((IMember)sibling).getSourceRange();
            if (sourceRange == null) {
                return null;
            }
            int insertPos = sourceRange.getOffset();
            List members = listRewrite.getOriginalList();
            int i = 0;
            while (i < members.size()) {
                ASTNode curr = (ASTNode)members.get(i);
                if (curr.getStartPosition() >= insertPos) {
                    return curr;
                }
                ++i;
            }
        }
        return null;
    }

    private StubUtility2() {
    }

    public static boolean isCopyOnInheritAnnotation(ITypeBinding annotationType, IJavaProject project) {
        if ("enabled".equals(project.getOption("org.eclipse.jdt.core.compiler.annotation.inheritNullAnnotations", true))) {
            return false;
        }
        return Bindings.isNullAnnotation(annotationType, project);
    }
}

