/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.javawebapp.dependency.artifact.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.appservices.IBundleResource;
import oracle.eclipse.tools.application.common.services.variables.JavaResourceBundleDataType;
import oracle.eclipse.tools.common.services.dependency.artifact.AbstractArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactLocator;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReferenceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.URLArtifact;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.transaction.ITransactionContext;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import oracle.eclipse.tools.webtier.javawebapp.dependency.artifact.collection.JavaResourceBundleReferenceLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.context.IModelContext;

public class JavaResourceBundleReference
extends AbstractArtifactReference
implements IArtifactReference,
IAdaptable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final JavaResourceBundleDataType bundleType;

    public JavaResourceBundleReference(IArtifact owner, JavaResourceBundleDataType bundleType, IFile file) {
        super((IArtifactLocator)new BundleResourceArtifactLocator(bundleType, file), owner);
        if (bundleType == null) {
            throw new IllegalArgumentException("bundleType may not be null");
        }
        this.bundleType = bundleType;
    }

    public boolean equals(Object other) {
        if (other instanceof JavaResourceBundleReference) {
            return super.equals(other) && this.bundleType.equals((Object)((JavaResourceBundleReference)other).bundleType);
        }
        return false;
    }

    public int hashCode() {
        HashCodeUtil hcu = HashCodeUtil.newInstance();
        hcu.hash(super.hashCode());
        hcu.hash((Object)this.bundleType);
        return hcu.getHashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException {
        in.defaultReadObject();
        if (this.bundleType == null) {
            throw new IllegalStateException("bundleType may not be null");
        }
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void addLocations(Set<IArtifactReferenceLocation> locations) {
        LinkedHashSet<Object> bundleLocations = new LinkedHashSet<Object>();
        for (IArtifactReferenceLocation location : locations) {
            if (location instanceof JavaResourceBundleReferenceLocation) {
                bundleLocations.add(location);
                continue;
            }
            bundleLocations.add((Object)new JavaResourceBundleReferenceLocation(location, ""));
        }
        super.addLocations(bundleLocations);
    }

    public boolean canMerge(IArtifactReference reference) {
        return reference instanceof JavaResourceBundleReference && super.canMerge(reference);
    }

    protected IArtifact createMissingArtifact() {
        return new IArtifact(){
            private static final long serialVersionUID = 1L;

            public void addReference(IArtifactReference reference) {
            }

            public ResourceLocation getLocation() {
                return new ResourceLocation((IResource)JavaResourceBundleReference.this.bundleType.getProject().getEclipseProject(), null);
            }

            public String getName() {
                return JavaResourceBundleReference.this.bundleType.getBaseName();
            }

            public IArtifact getOwner() {
                return DependencyModelManager.getInstance().getModel().ensureResourceArtifact((IResource)JavaResourceBundleReference.this.bundleType.getProject().getEclipseProject());
            }

            public IProject getProject() {
                return JavaResourceBundleReference.this.bundleType.getProject().getEclipseProject();
            }

            public Set<IArtifactReference> getReferences() {
                return Collections.emptySet();
            }

            public String getType() {
                return "missing";
            }

            public boolean isMissing() {
                return true;
            }

            public void removeReferences(String collectorID, ITransactionContext txContext) {
            }

            public void removeReferences() {
            }

            public IResource[] getAffectedResources() {
                return new IResource[0];
            }
        };
    }

    public String getName() {
        return this.bundleType.getBaseName();
    }

    public String getType() {
        return "bundle";
    }

    public boolean isMissing() {
        return this.getLocator().locateArtifact() == null;
    }

    private static final class BundleResourceArtifactLocator
    implements IArtifactLocator,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final JavaResourceBundleDataType bundleType;
        private final IFile file;

        public BundleResourceArtifactLocator(JavaResourceBundleDataType bundleType, IFile file) {
            this.bundleType = bundleType;
            this.file = file;
        }

        public IArtifact locateArtifact() {
            FilePositionContext modelContext = new FilePositionContext(this.file);
            IBundleResource bundleResource = this.bundleType.getBundleResource((IModelContext)modelContext);
            if (bundleResource != null) {
                IFile underlyingBundleResource = bundleResource.getUnderlyingResource();
                if (underlyingBundleResource != null) {
                    return DependencyModelManager.getInstance().getModel().ensureResourceArtifact((IResource)underlyingBundleResource);
                }
                URL bestMatch = bundleResource.getBestMatchURL();
                if (bestMatch != null) {
                    return new URLArtifact(bestMatch);
                }
            }
            return null;
        }

        public boolean equals(Object other) {
            if (other instanceof BundleResourceArtifactLocator) {
                return this.bundleType == null ? ((BundleResourceArtifactLocator)other).bundleType == null : this.bundleType.equals((Object)((BundleResourceArtifactLocator)other).bundleType);
            }
            return false;
        }

        public int hashCode() {
            return this.bundleType.hashCode();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.bundleType);
            SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
            su.writeResource((IResource)this.file);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
            SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
            su.readFinalFieldFromStream((Object)this, "bundleType", JavaResourceBundleDataType.class);
            su.readFinalFileFromStream((Object)this, "file");
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("bundle-resource-locator[");
            sb.append(this.bundleType == null ? "null" : this.bundleType.toString());
            sb.append(":");
            sb.append(this.file == null ? "null" : this.file.toString());
            sb.append("]");
            return sb.toString();
        }
    }
}

