/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.javawebapp;

import oracle.eclipse.tools.application.common.services.appservices.IAppClassLoaderProvider;
import oracle.eclipse.tools.common.services.concurrency.PreLockCommand;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.javawebapp.Activator;
import oracle.eclipse.tools.webtier.javawebapp.JavaWebAppTechnologyExtension;
import oracle.eclipse.tools.webtier.javawebapp.WebAppClassLoaderManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class WebAppClassloaderResetCommand
implements PreLockCommand {
    private static final int TIMEOUT = WebAppClassLoaderManager.CLASSLOADER_UPDATE_TIMEOUT;
    private static final boolean DEBUG_CLASSLOADER_RESET = Boolean.valueOf(Platform.getDebugOption((String)"oracle.eclipse.tools.webtier.javawebapp/debug/classloader/resetcommand"));
    private static final boolean CLASSLOADER_RESET_PERF = Boolean.valueOf(Platform.getDebugOption((String)"oracle.eclipse.tools.webtier.javawebapp/debug/classloader/resetcommand/perf"));

    public void execute(ISchedulingRule rule, boolean isIncremental) throws InterruptedException {
        if (!isIncremental && rule instanceof IProject) {
            IProject iProject = (IProject)rule;
            if (DEBUG_CLASSLOADER_RESET) {
                System.out.println("->WebAppClassloaderResetCommand executing for: " + iProject.getName());
            }
            if (!iProject.isAccessible()) {
                if (DEBUG_CLASSLOADER_RESET) {
                    System.out.println("->WebAppClassloaderResetCommand done: " + iProject.getName() + " not accessible");
                }
                return;
            }
            Project project = (Project)iProject.getAdapter(Project.class);
            if (project != null) {
                JavaWebAppTechnologyExtension techExt;
                long startTime = 0L;
                if (CLASSLOADER_RESET_PERF) {
                    startTime = System.currentTimeMillis();
                }
                if ((techExt = (JavaWebAppTechnologyExtension)project.getTechnologyExtensionById("javawebapp")) != null) {
                    IAppClassLoaderProvider.IUpdateEvent resetEvent = techExt.reset();
                    resetEvent.waitForSignal(TIMEOUT);
                    if (!resetEvent.isSignalled()) {
                        if (DEBUG_CLASSLOADER_RESET) {
                            System.err.println("--X WebAppClassloaderResetCommand failed to execute for: " + iProject.getName());
                        }
                        LoggingService.logInfo((Plugin)Activator.getDefault(), (String)("Unable to reset classloader for " + iProject.getName() + " within " + String.valueOf(WebAppClassLoaderManager.CLASSLOADER_UPDATE_TIMEOUT) + "ms"));
                    }
                    if (DEBUG_CLASSLOADER_RESET) {
                        System.out.println("--> WebAppClassloaderResetCommand executed for: " + iProject.getName());
                    }
                }
                if (CLASSLOADER_RESET_PERF) {
                    long totalTime = System.currentTimeMillis() - startTime;
                    System.out.println("WebAppClassloaderResetCommand executing for " + iProject.getName() + " with time, " + totalTime);
                }
            }
        }
    }
}

