/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.javawebapp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.eclipse.tools.application.common.services.appservices.IAppClassLoaderProvider;
import oracle.eclipse.tools.common.util.classloader.JarClassLoader;
import oracle.eclipse.tools.webtier.javawebapp.JarSafeJarClassLoader;
import oracle.eclipse.tools.webtier.javawebapp.WebTierJarClassLoader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;

public final class ReusableClassLoader
implements IAppClassLoaderProvider.IClassLoader {
    private static final boolean DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"oracle.eclipse.tools.webtier.javawebapp/debug/classloader/reusableclassloader"));
    private final AtomicInteger _refCount;
    private final AtomicBoolean _isDisposed;
    private final AtomicBoolean _isStale;
    private final Comparable<?> _versionStamp;
    private final ClassLoader _jarClassLoader;
    private final String _classLoaderId;

    public ReusableClassLoader(IProject project, ClassLoader classLoader, Comparable<?> versionStamp) {
        this._jarClassLoader = classLoader;
        this._refCount = new AtomicInteger(0);
        this._isDisposed = new AtomicBoolean(false);
        this._isStale = new AtomicBoolean(false);
        this._versionStamp = versionStamp;
        this._classLoaderId = ReusableClassLoader.createId(project, versionStamp);
    }

    public synchronized void acquire() {
        if (this._isStale.get()) {
            throw new IllegalStateException("Class loaders must never be newly acquired after they are made stale");
        }
        if (this._isDisposed.get()) {
            throw new IllegalStateException("Class loaders must never be newly acquired after they are disposed");
        }
        this._refCount.incrementAndGet();
        if (DEBUG) {
            this.printInfo("[ReusableClassLoader] Acquired");
        }
    }

    private void release() {
        if (this._isDisposed.get()) {
            throw new IllegalStateException("Class loader is being released after disposal");
        }
        this._refCount.decrementAndGet();
        if (DEBUG) {
            this.printInfo("[ReusableClassLoader] Released");
        }
    }

    public synchronized void close() {
        this.release();
        if (this._refCount.get() == 0) {
            if (this._isStale.get()) {
                this.dispose();
            } else if (this._jarClassLoader instanceof JarSafeJarClassLoader) {
                ((JarSafeJarClassLoader)this._jarClassLoader).releaseWorkspaceJarFiles();
            }
        }
    }

    void dispose() {
        if (this._isDisposed.compareAndSet(false, true)) {
            if (this._jarClassLoader instanceof WebTierJarClassLoader) {
                ((WebTierJarClassLoader)this._jarClassLoader).close();
            } else if (this._jarClassLoader instanceof JarClassLoader) {
                ((JarClassLoader)this._jarClassLoader).close();
            } else if (this._jarClassLoader instanceof JarSafeJarClassLoader) {
                ((JarSafeJarClassLoader)this._jarClassLoader).close();
            }
            if (DEBUG) {
                this.printInfo("[ReusableClassLoader] Disposed");
            }
        } else if (DEBUG) {
            this.printInfo("[ReusableClassLoader] Unnecessary disposal");
        }
    }

    public ClassLoader getClassLoader() {
        return this._jarClassLoader;
    }

    public synchronized void markStale() {
        this._isStale.set(true);
    }

    public ClassLoader getParent() {
        return this._jarClassLoader.getParent();
    }

    public URL getResource(String name) {
        return this._jarClassLoader.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return this._jarClassLoader.getResourceAsStream(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return this._jarClassLoader.getResources(name);
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this._jarClassLoader.loadClass(name);
    }

    public Comparable<?> getVersionStamp() {
        return this._versionStamp;
    }

    private void printInfo(String msg) {
        System.out.printf("%s: versionStamp=%s , new ref count = %s, isStale=%s, isDisposed=%s\n", msg, this._classLoaderId.toString(), this._refCount.toString(), this._isStale.toString(), this._isDisposed.toString());
    }

    private static String createId(IProject project, Comparable<?> versionStamp) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(project.getName());
        stringBuilder.append("/");
        stringBuilder.append(versionStamp.toString());
        return stringBuilder.toString();
    }
}

