/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.javawebapp;

import java.util.Set;
import oracle.eclipse.tools.common.services.project.IProjectSharedEventManager;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyDiscoveryProvider;
import oracle.eclipse.tools.common.services.project.technology.DefaultTechnologyDiscoverer;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDiscoveryEvent;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtensionIdentifier;
import oracle.eclipse.tools.common.services.resources.IResourceChange;
import oracle.eclipse.tools.common.services.resources.ISequentialResourceChangeEvent;
import oracle.eclipse.tools.common.util.jdt.JavaProjectUtil;
import oracle.eclipse.tools.webtier.javawebapp.Activator;
import oracle.eclipse.tools.webtier.javawebapp.JavaWebAppRootResolver;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public class JavaWebAppTechnologyDiscoverer
extends DefaultTechnologyDiscoverer {
    private IProjectSharedEventManager.IProjectSharedEventListener listener;

    public JavaWebAppTechnologyDiscoverer(AbstractTechnologyDiscoveryProvider technologyDiscoveryProvider, ITechnologyExtensionIdentifier techId) {
        super(technologyDiscoveryProvider, techId);
    }

    public void start() {
        super.start();
        this.listener = new WebInfFolderChangeListener();
        this.getTechnologyDiscoveryProvider().getProject().addSharedEventListener(this.listener);
    }

    private void fireWebAppIsActiveChanged(boolean isActive) {
        IProject eclipseProject = this.getTechnologyDiscoveryProvider().getProject().getEclipseProject();
        ITechnologyExtensionIdentifier calcVersion = this.calcVersion(eclipseProject);
        if (calcVersion != null && calcVersion.equals(this.getTechnologyId())) {
            this.fireDiscoveryEvent(this.getTechnologyId(), isActive ? ITechnologyDiscoveryEvent.Type.ADDED : ITechnologyDiscoveryEvent.Type.REMOVED, new Object());
        }
    }

    private ITechnologyExtensionIdentifier calcVersion(IProject eclipseProject) {
        IJavaProject javaProj;
        if (JavaProjectUtil.isJavaProject((IProject)eclipseProject) && (javaProj = JavaCore.create((IProject)eclipseProject)) != null && javaProj.exists()) {
            try {
                IVMInstall2 vmInstall = (IVMInstall2)JavaRuntime.getVMInstall((IJavaProject)javaProj);
                if (vmInstall != null) {
                    return this.calcVersion(vmInstall.getJavaVersion());
                }
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
        return null;
    }

    private ITechnologyExtensionIdentifier calcVersion(String javaVersion) {
        if (javaVersion == null) {
            return null;
        }
        if (javaVersion.startsWith("1.5")) {
            return "2.5".equals(this.getTechnologyId().getVersion()) ? this.getTechnologyId() : null;
        }
        if (javaVersion.startsWith("1.6") || javaVersion.startsWith("1.7")) {
            return "3.0".equals(this.getTechnologyId().getVersion()) ? this.getTechnologyId() : null;
        }
        return null;
    }

    public void stop() {
        if (this.listener != null) {
            this.getTechnologyDiscoveryProvider().getProject().removeSharedEventListener(this.listener);
            this.listener = null;
        }
        super.stop();
    }

    public boolean isActive() {
        Project project = this.getTechnologyDiscoveryProvider().getProject();
        IProject eclipseProject = project.getEclipseProject();
        boolean active = false;
        try {
            IFolder findWebInfFolder;
            active = super.isActive();
            if (!active && !FacetedProjectFramework.hasProjectFacet((IProject)eclipseProject, (String)"jst.web") && JavaProjectUtil.isJavaProject((IProject)eclipseProject) && (findWebInfFolder = JavaWebAppRootResolver.findWebInfFolder(eclipseProject)) != null) {
                ITechnologyExtensionIdentifier calcVersion = this.calcVersion(this.getTechnologyDiscoveryProvider().getProject().getEclipseProject());
                return calcVersion != null && calcVersion.equals(this.getTechnologyId());
            }
        }
        catch (CoreException t) {
            Activator.log(t);
        }
        return active;
    }

    private final class WebInfFolderChangeListener
    implements IProjectSharedEventManager.IProjectSharedEventListener {
        private WebInfFolderChangeListener() {
        }

        public void resourceChanged(ISequentialResourceChangeEvent event) {
            if (JavaWebAppTechnologyDiscoverer.this.checkIsActiveByFacet()) {
                return;
            }
            Set resourceChanges = event.getResourceChanges();
            for (IResourceChange change : resourceChanges) {
                IResource resource = change.getResource();
                if (resource == null || resource.getType() != 2 || change.getKind() != IResourceChange.KIND.ADDED && change.getKind() != IResourceChange.KIND.REMOVED || resource.isPhantom() || resource.isTeamPrivateMember() || resource.isDerived() || !resource.getProject().isAccessible() || !resource.getProject().equals((Object)JavaWebAppTechnologyDiscoverer.this.getTechnologyDiscoveryProvider().getProject().getEclipseProject()) || !"WEB-INF".equals(resource.getName())) continue;
                if (!resource.exists() && !change.getFlags().contains(IResourceChange.FLAG.MOVED_TO)) {
                    JavaWebAppTechnologyDiscoverer.this.fireWebAppIsActiveChanged(false);
                    continue;
                }
                JavaWebAppTechnologyDiscoverer.this.fireWebAppIsActiveChanged(true);
            }
        }

        public void facetedProjectStatusChanged(boolean projectIsFaceted) {
        }
    }
}

