/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.javawebapp;

import java.util.HashSet;
import oracle.eclipse.tools.application.common.services.appservices.IAppClassLoaderProvider;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.AbstractSimpleDiscoveryParticipant;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryParticipant;
import oracle.eclipse.tools.common.services.project.Project;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;

public class JavaVariableDiscoveryParticipant
extends AbstractSimpleDiscoveryParticipant
implements IDiscoveryParticipant {
    public static final String ID = "JavaVariableDiscoveryParticipant";
    private static final IContentType JAVACLASS = Platform.getContentTypeManager().getContentType("org.eclipse.jdt.core.javaClass");
    private static final IContentType JSPSOURCE = Platform.getContentTypeManager().getContentType("org.eclipse.jst.jsp.core.jspsource");

    public void startDiscovery(IDiscoveryContext context, IProgressMonitor monitor) {
        HashSet<IProject> projects = new HashSet<IProject>();
        for (IResource res : context.getChangedResources()) {
            if (projects.contains(res.getProject()) || !this.isResourceInteresting(res)) continue;
            projects.add(res.getProject());
        }
        if (projects.size() > 0) {
            for (IProject iproject : projects) {
                Project project = (Project)iproject.getAdapter(Project.class);
                if (project == null) continue;
                IAppClassLoaderProvider iAppClassLoaderProvider = (IAppClassLoaderProvider)project.getAppService(IAppClassLoaderProvider.class);
            }
        }
    }

    private boolean isResourceInteresting(IResource res) {
        if (res instanceof IFile) {
            try {
                IContentType contentType;
                IContentDescription contentDesc = ((IFile)res).getContentDescription();
                if (contentDesc != null && (contentType = contentDesc.getContentType()) != null && (contentType.isKindOf(JAVACLASS) || contentType.isKindOf(JSPSOURCE))) {
                    return true;
                }
            }
            catch (CoreException coreException) {}
        }
        return false;
    }
}

