/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.javawebapp;

import oracle.eclipse.tools.application.common.services.appservices.IAppClassLoaderProvider;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtension;
import oracle.eclipse.tools.webtier.javawebapp.WebAppClassLoaderManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "oracle.eclipse.tools.webtier.javawebapp";
    private static Activator plugin;
    private static final boolean DEBUG_CLASSLOADER;
    private static final int TIMEOUT;

    static {
        DEBUG_CLASSLOADER = Boolean.valueOf(Platform.getDebugOption((String)"oracle.eclipse.tools.webtier.javawebapp/debug/classloader"));
        TIMEOUT = WebAppClassLoaderManager.CLASSLOADER_UPDATE_TIMEOUT;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        if (oracle.eclipse.tools.common.services.Activator.getDefault().getPreferences().isDisabled()) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject[] projects = workspace.getRoot().getProjects();
            ClassLoaderInitJob job = new ClassLoaderInitJob(projects);
            job.schedule();
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void log(Throwable e) {
        if (Activator.getDefault() != null) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "", e));
        } else {
            e.printStackTrace();
        }
    }

    private static class ClassLoaderInitJob
    extends WorkspaceJob {
        private final IProject[] projects;

        private ClassLoaderInitJob(IProject[] projects) {
            super("Initialize Java Classloaders");
            this.projects = projects;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            IProject[] iProjectArray = this.projects;
            int n = this.projects.length;
            int n2 = 0;
            while (n2 < n) {
                ITechnologyExtension techExt;
                Project proj;
                IProject project = iProjectArray[n2];
                if (project.isAccessible() && (proj = (Project)project.getAdapter(Project.class)) != null && (techExt = proj.getTechnologyExtensionById("javawebapp")) instanceof IAppClassLoaderProvider) {
                    if (DEBUG_CLASSLOADER) {
                        System.out.println(">> STARTUP CLASSLOADER RESET for " + project.getName() + " <<");
                    }
                    IAppClassLoaderProvider.IUpdateEvent ev = ((IAppClassLoaderProvider)techExt).reset();
                    ev.waitForSignal(TIMEOUT);
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }
    }
}

