/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev.tasks;

import com.tasktop.c2c.server.tasks.domain.RepositoryConfiguration;
import com.tasktop.c2c.server.tasks.domain.Task;
import java.util.Set;
import oracle.eclipse.tools.cloud.dev.tasks.CloudDevClient;
import oracle.eclipse.tools.cloud.dev.tasks.CloudDevRepositoryConnector;
import oracle.eclipse.tools.cloud.dev.tasks.CloudDevTaskAttributeMapper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class CloudDevTaskDataHandler
extends AbstractTaskDataHandler {
    private CloudDevRepositoryConnector connector;

    public CloudDevTaskDataHandler(CloudDevRepositoryConnector connector) {
        this.connector = connector;
    }

    public RepositoryResponse postTaskData(TaskRepository taskRepository, TaskData taskData, Set<TaskAttribute> oldAttributes, IProgressMonitor monitor) throws CoreException {
        if (taskRepository == null) {
            throw new IllegalArgumentException();
        }
        try {
            CloudDevClient client = this.connector.getCloudDevClientManager().getCloudDevClient(taskRepository);
            if (taskData.isNew()) {
                RepositoryResponse repositoryResponse = client.newTask(taskData, monitor);
                return repositoryResponse;
            }
            RepositoryResponse repositoryResponse = client.modifyTaskById(taskData, monitor);
            return repositoryResponse;
        }
        finally {
            monitor.done();
        }
    }

    public boolean initializeTaskData(TaskRepository taskRepository, TaskData taskData, ITaskMapping initializationData, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask("Initialize task data ", -1);
            CloudDevClient client = this.connector.getCloudDevClientManager().getCloudDevClient(taskRepository);
            RepositoryConfiguration repositoryConfiguration = client.getRepositoryConfiguration(false, monitor);
            client.createDefaultTaskAttributes(repositoryConfiguration, taskData);
        }
        finally {
            monitor.done();
        }
        return true;
    }

    public TaskAttributeMapper getAttributeMapper(TaskRepository repository) {
        return new CloudDevTaskAttributeMapper(repository, this.connector.getCloudDevClientManager().getCloudDevClient(repository));
    }

    public TaskData getTaskData(TaskRepository taskRepository, String taskId, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask("Download task " + taskId, -1);
            CloudDevClient client = this.connector.getCloudDevClientManager().getCloudDevClient(taskRepository);
            RepositoryConfiguration repositoryConfiguration = client.getRepositoryConfiguration(false, monitor);
            Task task = client.getTaskById(taskId, monitor);
            TaskData taskData = this.createTaskDataFromTask(taskRepository, repositoryConfiguration, task);
            return taskData;
        }
        finally {
            monitor.done();
        }
    }

    public TaskData createTaskDataFromTask(TaskRepository taskRepository, RepositoryConfiguration repositoryConfiguration, Task task) {
        TaskData taskData = new TaskData(this.getAttributeMapper(taskRepository), "CloudDev", taskRepository.getRepositoryUrl(), "" + task.getId());
        taskData.setVersion(task.getVersion());
        CloudDevClient client = this.connector.getCloudDevClientManager().getCloudDevClient(taskRepository);
        client.createDefaultTaskAttributes(repositoryConfiguration, taskData);
        client.populateTaskAttributes(taskData, task);
        return taskData;
    }
}

