/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev.tasks;

import java.io.InputStream;
import oracle.eclipse.tools.cloud.dev.tasks.CloudDevClient;
import oracle.eclipse.tools.cloud.dev.tasks.CloudDevRepositoryConnector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentHandler;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;

public class CloudDevTaskAttachmentHandler
extends AbstractTaskAttachmentHandler {
    private CloudDevRepositoryConnector connector;

    public CloudDevTaskAttachmentHandler(CloudDevRepositoryConnector connector) {
        this.connector = connector;
    }

    public boolean canGetContent(TaskRepository repository, ITask task) {
        return true;
    }

    public boolean canPostContent(TaskRepository repository, ITask task) {
        return true;
    }

    public InputStream getContent(TaskRepository repository, ITask task, TaskAttribute attachmentAttribute, IProgressMonitor monitor) throws CoreException {
        if (repository == null) {
            throw new IllegalArgumentException();
        }
        try {
            CloudDevClient client = this.connector.getCloudDevClientManager().getCloudDevClient(repository);
            InputStream inputStream = client.retrieveAttachment(task.getTaskId(), attachmentAttribute, monitor);
            return inputStream;
        }
        finally {
            monitor.done();
        }
    }

    public void postContent(TaskRepository repository, ITask task, AbstractTaskAttachmentSource source, String comment, TaskAttribute attachmentAttribute, IProgressMonitor monitor) throws CoreException {
        if (repository == null) {
            throw new IllegalArgumentException();
        }
        try {
            CloudDevClient client = this.connector.getCloudDevClientManager().getCloudDevClient(repository);
            client.postAttachment(task.getTaskId(), source, comment, attachmentAttribute, monitor);
        }
        finally {
            monitor.done();
        }
    }
}

