/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev.tasks;

import com.tasktop.c2c.server.tasks.domain.TaskStatus;
import org.eclipse.osgi.util.NLS;

public enum CloudDevOperation {
    NONE(Resources.none, "NONE"),
    UNCONFIRMED(Resources.unconfirmed, "UNCONFIRMED"),
    NEW(Resources.markAsNew, "NEW"),
    ASSIGNED(Resources.assigned, "ASSIGNED"),
    REOPENED(Resources.reopen, "REOPENED"),
    RESOLVED(Resources.resolveAs, "RESOLVED", "resolutionInput", "singleSelect"),
    VERIFIED(Resources.markAsVerified, "VERIFIED"),
    CLOSED(Resources.markAsClosed, "CLOSED"),
    DUPLICATE(Resources.duplicateOf, "DUPLICATE", "DUPLICATE_OF", "taskDepenedency");

    private final String label;
    private final String value;
    private final String inputId;
    private final String inputType;

    private CloudDevOperation(String label, String value) {
        this(label, value, null, null);
    }

    private CloudDevOperation(String label, String value, String inputId, String inputType) {
        this.label = label;
        this.value = value;
        this.inputId = inputId;
        this.inputType = inputType;
    }

    public String getLabel() {
        return this.label;
    }

    public String getValue() {
        return this.value;
    }

    public String getInputId() {
        return this.inputId;
    }

    public String getInputType() {
        return this.inputType;
    }

    public static CloudDevOperation getByTaskStatus(TaskStatus status) {
        CloudDevOperation[] cloudDevOperationArray = CloudDevOperation.values();
        int n = cloudDevOperationArray.length;
        int n2 = 0;
        while (n2 < n) {
            CloudDevOperation attr = cloudDevOperationArray[n2];
            if (status.getValue().equals(attr.getValue())) {
                return attr;
            }
            ++n2;
        }
        return null;
    }

    private static final class Resources
    extends NLS {
        public static String none;
        public static String unconfirmed;
        public static String markAsNew;
        public static String assigned;
        public static String reopen;
        public static String resolveAs;
        public static String markAsVerified;
        public static String markAsClosed;
        public static String duplicateOf;

        static {
            Resources.initializeMessages((String)CloudDevOperation.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

