/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev.tasks;

import com.tasktop.c2c.server.common.service.ConcurrentUpdateException;
import com.tasktop.c2c.server.common.service.EntityNotFoundException;
import com.tasktop.c2c.server.common.service.ValidationException;
import com.tasktop.c2c.server.common.service.domain.QueryResult;
import com.tasktop.c2c.server.common.service.domain.Region;
import com.tasktop.c2c.server.common.service.domain.SortInfo;
import com.tasktop.c2c.server.common.service.domain.criteria.Criteria;
import com.tasktop.c2c.server.common.service.domain.criteria.CriteriaParser;
import com.tasktop.c2c.server.common.service.web.ApacheHttpRestClientDelegate;
import com.tasktop.c2c.server.common.service.web.RestClientDelegate;
import com.tasktop.c2c.server.tasks.domain.Attachment;
import com.tasktop.c2c.server.tasks.domain.Comment;
import com.tasktop.c2c.server.tasks.domain.Component;
import com.tasktop.c2c.server.tasks.domain.FieldDescriptor;
import com.tasktop.c2c.server.tasks.domain.Iteration;
import com.tasktop.c2c.server.tasks.domain.Keyword;
import com.tasktop.c2c.server.tasks.domain.Milestone;
import com.tasktop.c2c.server.tasks.domain.PredefinedTaskQuery;
import com.tasktop.c2c.server.tasks.domain.Priority;
import com.tasktop.c2c.server.tasks.domain.Product;
import com.tasktop.c2c.server.tasks.domain.QuerySpec;
import com.tasktop.c2c.server.tasks.domain.RepositoryConfiguration;
import com.tasktop.c2c.server.tasks.domain.Task;
import com.tasktop.c2c.server.tasks.domain.TaskHandle;
import com.tasktop.c2c.server.tasks.domain.TaskResolution;
import com.tasktop.c2c.server.tasks.domain.TaskSeverity;
import com.tasktop.c2c.server.tasks.domain.TaskStatus;
import com.tasktop.c2c.server.tasks.domain.TaskUserProfile;
import com.tasktop.c2c.server.tasks.service.TaskServiceClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.eclipse.tools.cloud.dev.tasks.CloudDevAttribute;
import oracle.eclipse.tools.cloud.dev.tasks.CloudDevOperation;
import oracle.eclipse.tools.cloud.dev.tasks.CloudDevTasksConnectorBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;

public class CloudDevClient {
    private final TaskRepository taskRepository;
    private RepositoryConfiguration repositoryConfiguration = null;
    private TaskServiceClient taskServiceClient = null;
    private final CloudDevOperation[] OPERATIONS = new CloudDevOperation[]{CloudDevOperation.NONE, CloudDevOperation.UNCONFIRMED, CloudDevOperation.NEW, CloudDevOperation.ASSIGNED, CloudDevOperation.REOPENED, CloudDevOperation.VERIFIED, CloudDevOperation.CLOSED, CloudDevOperation.DUPLICATE, CloudDevOperation.RESOLVED};
    private final List<CloudDevOperation> OPERATION_PREDEFINED_ORDER = Arrays.asList(this.OPERATIONS);

    public CloudDevClient(TaskRepository taskRepository) {
        this.taskRepository = taskRepository;
    }

    public QueryResult<Task> query(IRepositoryQuery query, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        String url = query.getUrl();
        Region region = new Region(Integer.valueOf(0), Integer.valueOf(Short.MAX_VALUE));
        SortInfo sortInfo = new SortInfo("creationDate", SortInfo.Order.ASCENDING);
        QuerySpec querySpec = new QuerySpec(region, sortInfo, true);
        monitor.worked(1);
        if (url.equals("findTasksWithCriteria")) {
            Criteria criteria = CriteriaParser.parse((String)query.getAttribute("QueryCriteria"));
            TaskServiceClient client = this.getTaskServiceClient();
            return client.findTasksWithCriteria(criteria, querySpec);
        }
        if (url.equals("findTasksWithQuery")) {
            String name = query.getAttribute("QueryName");
            TaskServiceClient client = this.getTaskServiceClient();
            return client.findTasksWithQuery(PredefinedTaskQuery.valueOfString((String)name), querySpec);
        }
        throw new IllegalStateException();
    }

    public String getTaskUrl(String repositoryUrl, String taskId) {
        StringBuilder builder = new StringBuilder();
        String url = this.taskRepository.getUrl();
        builder.append(url);
        if (!url.endsWith("/")) {
            builder.append("/");
        }
        builder.append("task");
        builder.append("/");
        builder.append(taskId);
        builder.append("/");
        return builder.toString();
    }

    public RepositoryConfiguration getRepositoryConfiguration(boolean forceRefresh, IProgressMonitor monitor) throws CoreException {
        if (this.repositoryConfiguration == null || forceRefresh) {
            this.repositoryConfiguration = this.getRepositoryConfiguration(monitor);
        }
        return this.repositoryConfiguration;
    }

    private RepositoryConfiguration getRepositoryConfiguration() {
        try {
            return this.getRepositoryConfiguration(false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private RepositoryConfiguration getRepositoryConfiguration(IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        TaskServiceClient client = this.getTaskServiceClient();
        RepositoryConfiguration config = client.getRepositoryContext();
        monitor.worked(1);
        return config;
    }

    private TaskServiceClient getTaskServiceClient() {
        if (this.taskServiceClient == null) {
            this.taskServiceClient = new TaskServiceClient();
            this.taskServiceClient.setBaseUrl(this.taskRepository.getRepositoryUrl());
            AuthenticationCredentials credentials = this.taskRepository.getCredentials(AuthenticationType.HTTP);
            ApacheHttpRestClientDelegate delegate = new ApacheHttpRestClientDelegate(credentials.getUserName(), credentials.getPassword());
            this.taskServiceClient.setRestClientDelegate((RestClientDelegate)delegate);
        }
        return this.taskServiceClient;
    }

    public Task getTaskById(String id, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        if (id == null || id.length() == 0) {
            throw new IllegalStateException();
        }
        try {
            TaskServiceClient client = this.getTaskServiceClient();
            monitor.worked(1);
            return client.retrieveTask(Integer.valueOf(id));
        }
        catch (EntityNotFoundException e) {
            throw new CoreException((IStatus)new RepositoryStatus(this.taskRepository, 4, CloudDevTasksConnectorBundle.ID, 7, e.getMessage(), (Throwable)e));
        }
    }

    public InputStream retrieveAttachment(String id, TaskAttribute attachmentAttribute, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            TaskServiceClient client = this.getTaskServiceClient();
            Attachment attachment = client.retrieveAttachment(Integer.valueOf(attachmentAttribute.getValue()));
            monitor.worked(1);
            return new ByteArrayInputStream(attachment.getAttachmentData());
        }
        catch (EntityNotFoundException e) {
            throw new CoreException((IStatus)new RepositoryStatus(this.taskRepository, 4, CloudDevTasksConnectorBundle.ID, 7, e.getMessage(), (Throwable)e));
        }
    }

    public void postAttachment(String id, AbstractTaskAttachmentSource source, String comment, TaskAttribute attachmentAttribute, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            TaskServiceClient client = this.getTaskServiceClient();
            TaskHandle taskHandle = new TaskHandle(new Integer(id), this.getVersion(attachmentAttribute));
            String description = source.getDescription();
            String contentType = source.getContentType();
            String filename = source.getName();
            TaskAttachmentMapper mapper = TaskAttachmentMapper.createFrom((TaskAttribute)attachmentAttribute);
            if (mapper.getDescription() != null) {
                description = mapper.getDescription();
            }
            if (mapper.getContentType() != null) {
                contentType = mapper.getContentType();
            }
            if (mapper.getFileName() != null) {
                filename = mapper.getFileName();
            }
            Attachment attachment = new Attachment();
            attachment.setDescription(description);
            attachment.setMimeType(contentType);
            attachment.setFilename(filename);
            attachment.setTaskHandle(taskHandle);
            try {
                byte[] byteArray = this.toByteArray(source.createInputStream(null));
                attachment.setAttachmentData(byteArray);
                attachment.setByteSize(Integer.valueOf(byteArray.length));
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new RepositoryStatus(this.taskRepository, 4, CloudDevTasksConnectorBundle.ID, 5, e.getMessage(), (Throwable)e));
            }
            Comment c = new Comment();
            c.setCommentText(comment);
            if (mapper.getComment() != null) {
                c.setCommentText(mapper.getComment());
            }
            client.saveAttachment(taskHandle, attachment, c);
            monitor.worked(1);
        }
        catch (ValidationException e) {
            throw new CoreException((IStatus)new RepositoryStatus(this.taskRepository, 4, CloudDevTasksConnectorBundle.ID, 7, e.getMessage(), (Throwable)e));
        }
        catch (EntityNotFoundException e) {
            throw new CoreException((IStatus)new RepositoryStatus(this.taskRepository, 4, CloudDevTasksConnectorBundle.ID, 7, e.getMessage(), (Throwable)e));
        }
        catch (ConcurrentUpdateException concurrentUpdateException) {
            throw new CoreException((IStatus)RepositoryStatus.createCollisionError((String)this.taskRepository.getRepositoryUrl(), (String)CloudDevTasksConnectorBundle.ID));
        }
    }

    private String getVersion(TaskAttribute attachmentAttribute) {
        TaskAttribute root = attachmentAttribute.getParentAttribute();
        TaskAttribute versionAttribute = root.getAttribute(CloudDevAttribute.VERSION.getTaskName());
        if (versionAttribute != null) {
            return versionAttribute.getValue();
        }
        return null;
    }

    private byte[] toByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        int count = is.read(bytes);
        while (count != -1) {
            buf.write(bytes, 0, count);
            count = is.read(bytes);
        }
        return buf.toByteArray();
    }

    public RepositoryResponse newTask(TaskData taskData, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            TaskServiceClient client = this.getTaskServiceClient();
            Task task = new Task();
            this.updateTask(task, taskData);
            monitor.worked(1);
            Task newTask = client.createTask(task);
            return new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_CREATED, "" + newTask.getId());
        }
        catch (ValidationException e) {
            throw new CoreException((IStatus)new RepositoryStatus(this.taskRepository, 4, CloudDevTasksConnectorBundle.ID, 7, e.getMessage(), (Throwable)e));
        }
        catch (EntityNotFoundException e) {
            throw new CoreException((IStatus)new RepositoryStatus(this.taskRepository, 4, CloudDevTasksConnectorBundle.ID, 7, e.getMessage(), (Throwable)e));
        }
    }

    public RepositoryResponse modifyTaskById(TaskData taskData, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            Task task = new Task();
            String id = taskData.getTaskId();
            task.setId(Integer.valueOf(id));
            this.updateTask(task, taskData);
            monitor.worked(1);
            TaskServiceClient client = this.getTaskServiceClient();
            task = client.updateTask(task);
            return new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_UPDATED, "" + task.getId());
        }
        catch (ValidationException e) {
            throw new CoreException((IStatus)new RepositoryStatus(this.taskRepository, 4, CloudDevTasksConnectorBundle.ID, 7, e.getMessage(), (Throwable)e));
        }
        catch (EntityNotFoundException e) {
            throw new CoreException((IStatus)new RepositoryStatus(this.taskRepository, 4, CloudDevTasksConnectorBundle.ID, 7, e.getMessage(), (Throwable)e));
        }
        catch (ConcurrentUpdateException concurrentUpdateException) {
            throw new CoreException((IStatus)RepositoryStatus.createCollisionError((String)this.taskRepository.getRepositoryUrl(), (String)CloudDevTasksConnectorBundle.ID));
        }
    }

    private void updateTask(Task task, TaskData taskData) throws CoreException {
        TaskAttribute attributeOperation;
        Date deadline;
        List values;
        TaskUserProfile assignee;
        String value;
        Iteration iteration;
        Milestone milestone;
        Component component;
        TaskSeverity taskSeverity;
        Priority priority;
        TaskStatus status;
        String value2;
        TaskAttribute root = taskData.getRoot();
        TaskAttributeMapper mapper = taskData.getAttributeMapper();
        TaskAttribute taskAttribute = root.getAttribute(CloudDevAttribute.SHORT_DESCRIPTION.getTaskName());
        if (taskAttribute != null && !CloudDevClient.equal(value2 = taskAttribute.getValue(), task.getShortDescription())) {
            task.setShortDescription(value2);
        }
        if ((taskAttribute = root.getAttribute(CloudDevAttribute.DESCRIPTION.getTaskName())) != null && !CloudDevClient.equal(value2 = taskAttribute.getValue(), task.getDescription())) {
            task.setDescription(value2);
        }
        if ((taskAttribute = root.getAttribute(CloudDevAttribute.STATUS_NEW.getTaskName())) != null && !CloudDevClient.equal(status = this.getTaskStatus(taskAttribute.getValue()), task.getStatus())) {
            task.setStatus(status);
        }
        if ((taskAttribute = root.getAttribute(CloudDevAttribute.VERSION.getTaskName())) != null) {
            task.setVersion(taskAttribute.getValue());
        }
        if ((taskAttribute = root.getAttribute(CloudDevAttribute.TASK_TYPE.getTaskName())) != null && !CloudDevClient.equal(value2 = taskAttribute.getValue(), task.getTaskType())) {
            task.setTaskType(value2);
        }
        if ((taskAttribute = root.getAttribute(CloudDevAttribute.PRIORITY.getTaskName())) != null && !CloudDevClient.equal(priority = this.getPriority(taskAttribute.getValue()), task.getPriority())) {
            task.setPriority(priority);
        }
        if ((taskAttribute = root.getAttribute(CloudDevAttribute.SEVERITY.getTaskName())) != null && !CloudDevClient.equal(taskSeverity = this.getTaskSeverity(taskAttribute.getValue()), task.getSeverity())) {
            task.setSeverity(taskSeverity);
        }
        Product product = null;
        taskAttribute = root.getAttribute(CloudDevAttribute.PRODUCT.getTaskName());
        if (taskAttribute != null && !CloudDevClient.equal(product = this.getProduct(taskAttribute.getValue()), task.getProduct())) {
            task.setProduct(product);
        }
        if ((taskAttribute = root.getAttribute(CloudDevAttribute.COMPONENT.getTaskName())) != null && !CloudDevClient.equal(component = this.getComponent(product, taskAttribute.getValue()), task.getComponent())) {
            task.setComponent(component);
        }
        if ((taskAttribute = root.getAttribute(CloudDevAttribute.MILESTONE.getTaskName())) != null && !CloudDevClient.equal(milestone = this.getMilestone(product, taskAttribute.getValue()), task.getMilestone())) {
            task.setMilestone(milestone);
        }
        if ((taskAttribute = root.getAttribute(CloudDevAttribute.ITERATION.getTaskName())) != null && !CloudDevClient.equal(iteration = this.getIteration(taskAttribute.getValue()), task.getIteration())) {
            task.setIteration(iteration);
        }
        if ((taskAttribute = root.getAttribute(CloudDevAttribute.ESTIMATED_TIME.getTaskName())) != null) {
            BigDecimal estimatedTime = null;
            try {
                estimatedTime = new BigDecimal(taskAttribute.getValue());
            }
            catch (NumberFormatException numberFormatException) {}
            if (!CloudDevClient.equal(estimatedTime, task.getEstimatedTime())) {
                task.setEstimatedTime(estimatedTime);
            }
        }
        if ((taskAttribute = root.getAttribute(CloudDevAttribute.REMAINING_TIME.getTaskName())) != null) {
            BigDecimal remainingTime = null;
            try {
                remainingTime = new BigDecimal(taskAttribute.getValue());
            }
            catch (NumberFormatException numberFormatException) {}
            if (!CloudDevClient.equal(remainingTime, task.getRemainingTime())) {
                task.setRemainingTime(remainingTime);
            }
        }
        if ((taskAttribute = root.getAttribute(CloudDevAttribute.NEW_COMMENT.getTaskName())) != null && (value = taskAttribute.getValue()) != null && value.length() > 0) {
            task.addComment(value);
        }
        if ((taskAttribute = root.getAttribute(CloudDevAttribute.ASSIGNEE.getTaskName())) != null && !CloudDevClient.equal(assignee = this.getUser(value = taskAttribute.getValue()), task.getAssignee())) {
            task.setAssignee(assignee);
        }
        if ((taskAttribute = root.getAttribute(CloudDevAttribute.CC.getTaskName())) != null) {
            values = taskAttribute.getValues();
            ArrayList<TaskUserProfile> watchers = new ArrayList<TaskUserProfile>(values.size());
            for (String value3 : values) {
                TaskUserProfile watcher = this.getUser(value3);
                if (watcher == null) continue;
                watchers.add(watcher);
            }
            task.setWatchers(watchers);
        }
        if ((taskAttribute = root.getAttribute(CloudDevAttribute.SUBTASKS.getTaskName())) != null && !CloudDevClient.equal(value = taskAttribute.getValue(), this.getTaskIds(task.getSubTasks()))) {
            List<Task> subtasks = this.getTaskList(value);
            task.setSubTasks(subtasks);
        }
        if ((taskAttribute = root.getAttribute(CloudDevAttribute.PARENT_TASK.getTaskName())) != null && !CloudDevClient.equal(value = taskAttribute.getValue(), this.getTaskId(task.getParentTask()))) {
            Task parentTask = this.getTaskById(value, null);
            task.setParentTask(parentTask);
        }
        if ((taskAttribute = root.getAttribute(CloudDevAttribute.KEYWORDS.getTaskName())) != null) {
            values = taskAttribute.getValues();
            ArrayList<Keyword> keywords = new ArrayList<Keyword>();
            for (Object str : values) {
                keywords.add(this.getKeyword((String)str));
            }
            task.setKeywords(keywords);
        }
        if ((taskAttribute = root.getAttribute(CloudDevAttribute.DEADLINE.getTaskName())) != null && !CloudDevClient.equal(deadline = mapper.getDateValue(taskAttribute), task.getDeadline())) {
            task.setDeadline(deadline);
        }
        if ((taskAttribute = root.getAttribute(CloudDevAttribute.FOUND_IN_RELEASE.getTaskName())) != null) {
            value = taskAttribute.getValue();
            String string = value = value.length() == 0 ? null : value;
            if (!CloudDevClient.equal(value, task.getFoundInRelease())) {
                task.setFoundInRelease(value);
            }
        }
        HashMap<String, String> customFields = new HashMap<String, String>();
        for (FieldDescriptor customDescriptor : this.repositoryConfiguration.getCustomFields()) {
            String key = customDescriptor.getName();
            taskAttribute = root.getAttribute(key);
            if (taskAttribute == null) continue;
            String value4 = taskAttribute.getValue();
            value4 = value4.length() == 0 ? null : value4;
            customFields.put(key, value4);
        }
        task.setCustomFields(customFields);
        taskAttribute = root.getMappedAttribute("task.common.status");
        if (taskAttribute != null) {
            task.setStatus(this.getStatus(taskAttribute.getValue()));
        }
        if ((taskAttribute = root.getMappedAttribute("task.common.resolution")) != null) {
            task.setResolution(this.getResolution(taskAttribute.getValue()));
        }
        if ((attributeOperation = root.getMappedAttribute("task.common.operation")) != null) {
            TaskAttribute inputAttribute;
            String inputAttributeId;
            TaskAttribute originalOperation;
            TaskStatus status2;
            String value3;
            value3 = attributeOperation.getValue();
            if (CloudDevOperation.DUPLICATE.getValue().equals(value3)) {
                value3 = CloudDevOperation.RESOLVED.getValue();
                task.setResolution(this.getResolution(CloudDevOperation.DUPLICATE.getValue()));
            }
            if ((status2 = this.getTaskStatus(value3)) != null && !CloudDevClient.equal(status2, task.getStatus())) {
                task.setStatus(status2);
                if (CloudDevOperation.REOPENED.getValue().equals(status2.getValue())) {
                    task.setResolution(null);
                    task.setDuplicateOf(null);
                }
            }
            if ((originalOperation = root.getAttribute("task.common.operation-" + attributeOperation.getValue())) != null && (inputAttributeId = originalOperation.getMetaData().getValue("task.meta.associated.attribute")) != null && !inputAttributeId.equals("") && (inputAttribute = attributeOperation.getTaskData().getRoot().getAttribute(inputAttributeId)) != null) {
                if (inputAttribute.getOptions().size() > 0) {
                    String sel = inputAttribute.getValue();
                    TaskResolution resolution = this.getResolution(inputAttribute.getOption(sel));
                    if (resolution != null && !CloudDevClient.equal(resolution, task.getResolution())) {
                        task.setResolution(resolution);
                    }
                } else {
                    Task duplicateTask;
                    String duplicateOf = inputAttribute.getValue();
                    if (!CloudDevClient.equal(duplicateOf, (duplicateTask = task.getDuplicateOf()) == null ? "" : "" + duplicateTask.getId())) {
                        Task newDuplicateTask = this.getTaskById(duplicateOf, (IProgressMonitor)new NullProgressMonitor());
                        task.setDuplicateOf(newDuplicateTask);
                    }
                }
            }
        }
    }

    private Keyword getKeyword(String value) {
        if (value != null) {
            for (Keyword keyword : this.getRepositoryConfiguration().getKeywords()) {
                if (!value.equals(keyword.getName())) continue;
                return keyword;
            }
        }
        return null;
    }

    private List<Task> getTaskList(String value) throws CoreException {
        if (value != null) {
            ArrayList<Task> list = new ArrayList<Task>();
            StringTokenizer t = new StringTokenizer(value, ", ");
            while (t.hasMoreTokens()) {
                String id = t.nextToken();
                Task task = this.getTaskById(id, (IProgressMonitor)new NullProgressMonitor());
                list.add(task);
            }
            return list;
        }
        return null;
    }

    public boolean isComplete(String value) {
        if (value != null) {
            for (TaskStatus status : this.getRepositoryConfiguration().getStatuses()) {
                if (!value.equals(status.getValue())) continue;
                return !status.isOpen();
            }
        }
        return false;
    }

    private TaskStatus getTaskStatus(String value) {
        if (value != null) {
            for (TaskStatus status : this.getRepositoryConfiguration().getStatuses()) {
                if (!value.equals(status.getValue())) continue;
                return status;
            }
        }
        return null;
    }

    private TaskResolution getResolution(String value) {
        if (value != null) {
            for (TaskResolution resolution : this.getRepositoryConfiguration().getResolutions()) {
                if (!value.equals(resolution.getValue())) continue;
                return resolution;
            }
        }
        return null;
    }

    private Priority getPriority(String value) {
        if (value != null) {
            for (Priority priority : this.getRepositoryConfiguration().getPriorities()) {
                if (!value.equals(priority.getValue())) continue;
                return priority;
            }
        }
        return null;
    }

    private TaskSeverity getTaskSeverity(String value) {
        if (value != null) {
            for (TaskSeverity severity : this.getRepositoryConfiguration().getSeverities()) {
                if (!value.equals(severity.getValue())) continue;
                return severity;
            }
        }
        return null;
    }

    private Product getProduct(String value) {
        if (value != null) {
            for (Product product : this.getRepositoryConfiguration().getProducts()) {
                if (!value.equals(product.getName())) continue;
                return product;
            }
        }
        return null;
    }

    private TaskStatus getStatus(String value) {
        if (value != null) {
            for (TaskStatus status : this.getRepositoryConfiguration().getStatuses()) {
                if (!value.equals(status.getValue())) continue;
                return status;
            }
        }
        return null;
    }

    private Component getComponent(Product product, String value) {
        if (value != null) {
            List components = product != null ? product.getComponents() : this.getRepositoryConfiguration().getComponents();
            for (Component component : components) {
                if (!value.equals(component.getName())) continue;
                return component;
            }
        }
        return null;
    }

    private Milestone getMilestone(Product product, String value) {
        if (value != null) {
            List milestones = product != null ? product.getMilestones() : this.getRepositoryConfiguration().getMilestones();
            for (Milestone milestone : milestones) {
                if (!value.equals(milestone.getValue())) continue;
                return milestone;
            }
        }
        return null;
    }

    private Iteration getIteration(String value) {
        if (value != null) {
            for (Iteration iteration : this.getRepositoryConfiguration().getIterations()) {
                if (!value.equals(iteration.getValue())) continue;
                return iteration;
            }
        }
        return null;
    }

    private TaskUserProfile getUser(String value) {
        if (value != null) {
            for (TaskUserProfile profile : this.getRepositoryConfiguration().getUsers()) {
                if (!value.equals(profile.getLoginName()) && !value.equals(profile.getRealname())) continue;
                return profile;
            }
        }
        return null;
    }

    public void createDefaultTaskAttributes(RepositoryConfiguration repositoryConfiguration, TaskData taskData) {
        boolean isExisting = !taskData.isNew();
        TaskAttribute rootAttribute = taskData.getRoot();
        TaskAttributeMetaData rootMetaData = rootAttribute.getMetaData();
        rootMetaData.setType("shortText");
        rootMetaData.setKind("task.common.kind.default");
        this.createAttribute(taskData, CloudDevAttribute.SHORT_DESCRIPTION);
        this.createAttribute(taskData, CloudDevAttribute.DESCRIPTION);
        this.createAttribute(taskData, CloudDevAttribute.CREATION_DATE);
        this.createAttribute(taskData, CloudDevAttribute.MODIFIED_DATE);
        if (isExisting) {
            this.createAttribute(taskData, CloudDevAttribute.VERSION);
        }
        TaskAttribute attribute = this.createAttribute(taskData, CloudDevAttribute.TASK_TYPE);
        for (String type : repositoryConfiguration.getTaskTypes()) {
            attribute.putOption(type, type);
        }
        attribute.setValue(repositoryConfiguration.getDefaultType());
        if (isExisting) {
            attribute = this.createAttribute(taskData, CloudDevAttribute.STATUS);
        } else {
            attribute = this.createAttribute(taskData, CloudDevAttribute.STATUS_NEW);
            for (TaskStatus status : repositoryConfiguration.computeValidStatuses(null)) {
                attribute.putOption(status.getValue(), status.getValue());
            }
            if (repositoryConfiguration.getDefaultStatus() != null) {
                attribute.setValue(repositoryConfiguration.getDefaultStatus().getValue());
            }
        }
        if (isExisting) {
            attribute = this.createAttribute(taskData, CloudDevAttribute.RESOLUTION);
            for (TaskResolution resolution : repositoryConfiguration.getResolutions()) {
                attribute.putOption(resolution.getValue(), resolution.getValue());
            }
        }
        attribute = this.createAttribute(taskData, CloudDevAttribute.PRIORITY);
        for (Priority priority : repositoryConfiguration.getPriorities()) {
            attribute.putOption(priority.getValue(), priority.getValue());
        }
        if (repositoryConfiguration.getDefaultPriority() != null) {
            attribute.setValue(repositoryConfiguration.getDefaultPriority().getValue());
        }
        attribute = this.createAttribute(taskData, CloudDevAttribute.SEVERITY);
        for (TaskSeverity severity : repositoryConfiguration.getSeverities()) {
            attribute.putOption(severity.getValue(), severity.getValue());
        }
        if (repositoryConfiguration.getDefaultSeverity() != null) {
            attribute.setValue(repositoryConfiguration.getDefaultSeverity().getValue());
        }
        attribute = this.createAttribute(taskData, CloudDevAttribute.PRODUCT);
        for (Product product : repositoryConfiguration.getProducts()) {
            attribute.putOption(product.getName(), product.getName());
        }
        Product defaultProduct = repositoryConfiguration.getDefaultProduct();
        if (defaultProduct != null) {
            attribute.setValue(defaultProduct.getName());
        }
        attribute = this.createAttribute(taskData, CloudDevAttribute.COMPONENT);
        if (!isExisting && defaultProduct != null) {
            for (Component component : defaultProduct.getComponents()) {
                attribute.putOption(component.getName(), component.getName());
            }
            if (defaultProduct.getDefaultComponent() != null) {
                attribute.setValue(defaultProduct.getDefaultComponent().getName());
            }
        }
        attribute = this.createAttribute(taskData, CloudDevAttribute.MILESTONE);
        if (!isExisting && defaultProduct != null) {
            for (Milestone milestone : defaultProduct.getMilestones()) {
                attribute.putOption(milestone.getValue(), milestone.getValue());
            }
            if (defaultProduct.getDefaultMilestone() != null) {
                attribute.setValue(defaultProduct.getDefaultMilestone().getValue());
            }
        }
        this.createAttribute(taskData, CloudDevAttribute.FOUND_IN_RELEASE);
        attribute = this.createAttribute(taskData, CloudDevAttribute.ITERATION);
        for (Iteration iteration : repositoryConfiguration.getActiveIterations()) {
            attribute.putOption(iteration.getValue(), iteration.getValue());
        }
        if (repositoryConfiguration.getDefaultIteration() != null) {
            attribute.setValue(repositoryConfiguration.getDefaultIteration().getValue());
        }
        this.createAttribute(taskData, CloudDevAttribute.DEADLINE);
        this.createAttribute(taskData, CloudDevAttribute.ESTIMATED_TIME);
        if (isExisting) {
            this.createAttribute(taskData, CloudDevAttribute.REMAINING_TIME);
        }
        attribute = this.createAttribute(taskData, CloudDevAttribute.KEYWORDS);
        for (Keyword keyword : repositoryConfiguration.getKeywords()) {
            attribute.putOption(keyword.getName(), keyword.getName());
        }
        this.createAttribute(taskData, CloudDevAttribute.ASSIGNEE);
        attribute = this.createAttribute(taskData, CloudDevAttribute.CC);
        for (TaskUserProfile user : repositoryConfiguration.getUsers()) {
            this.taskRepository.createPerson(user.getLoginName());
            attribute.putOption(user.getLoginName(), user.getLoginName());
        }
        if (isExisting) {
            this.createAttribute(taskData, CloudDevAttribute.URL);
            this.createAttribute(taskData, CloudDevAttribute.SUBTASKS);
            this.createAttribute(taskData, CloudDevAttribute.PARENT_TASK);
            this.createAttribute(taskData, CloudDevAttribute.SUM_OF_SUBTASKS_ESTIMATED_TIME);
            this.createAttribute(taskData, CloudDevAttribute.SUM_OF_SUBTASKS_TIME_SPENT);
            this.createAttribute(taskData, CloudDevAttribute.NEW_COMMENT);
            this.createAttribute(taskData, CloudDevAttribute.DUPLICATE_OF);
            this.createAttribute(taskData, CloudDevAttribute.DUPLICATES);
            this.createAttribute(taskData, CloudDevAttribute.REPORTER);
        }
        for (FieldDescriptor customDescriptor : repositoryConfiguration.getCustomFields()) {
            if (!isExisting && (isExisting || !customDescriptor.isAvailableForNewTasks())) continue;
            this.createAttribute(taskData, customDescriptor);
        }
    }

    public void populateTaskAttributes(TaskData taskData, Task task) {
        List watchers;
        IRepositoryPerson person;
        List keywords;
        List deuplicates;
        TaskAttributeMapper mapper = taskData.getAttributeMapper();
        TaskAttribute rootAttribute = taskData.getRoot();
        TaskAttributeMetaData rootMetaData = rootAttribute.getMetaData();
        rootMetaData.setLabel(task.getShortDescription());
        TaskAttribute attribute = rootAttribute.getAttribute(CloudDevAttribute.SHORT_DESCRIPTION.getTaskName());
        attribute.setValue(task.getShortDescription());
        attribute = rootAttribute.getAttribute(CloudDevAttribute.DESCRIPTION.getTaskName());
        attribute.setValue(task.getDescription());
        attribute = rootAttribute.getAttribute(CloudDevAttribute.CREATION_DATE.getTaskName());
        mapper.setDateValue(attribute, task.getCreationDate());
        attribute = rootAttribute.getAttribute(CloudDevAttribute.MODIFIED_DATE.getTaskName());
        mapper.setDateValue(attribute, task.getModificationDate());
        attribute = rootAttribute.getAttribute(CloudDevAttribute.VERSION.getTaskName());
        if (attribute != null) {
            attribute.setValue(task.getVersion());
        }
        attribute = rootAttribute.getAttribute(CloudDevAttribute.TASK_TYPE.getTaskName());
        attribute.setValue(task.getTaskType());
        if (task.getStatus() != null) {
            attribute = rootAttribute.getAttribute(CloudDevAttribute.STATUS.getTaskName());
            attribute.setValue(task.getStatus().getValue());
        }
        if (task.getResolution() != null) {
            attribute = rootAttribute.getAttribute(CloudDevAttribute.RESOLUTION.getTaskName());
            attribute.setValue(task.getResolution().getValue());
        }
        if (task.getPriority() != null) {
            attribute = rootAttribute.getAttribute(CloudDevAttribute.PRIORITY.getTaskName());
            attribute.setValue(task.getPriority().getValue());
        }
        if (task.getSeverity() != null) {
            attribute = rootAttribute.getAttribute(CloudDevAttribute.SEVERITY.getTaskName());
            attribute.setValue(task.getSeverity().getValue());
        }
        if (task.getProduct() != null) {
            attribute = rootAttribute.getAttribute(CloudDevAttribute.PRODUCT.getTaskName());
            attribute.setValue(task.getProduct().getName());
        }
        attribute = rootAttribute.getAttribute(CloudDevAttribute.DEADLINE.getTaskName());
        mapper.setDateValue(attribute, task.getDeadline());
        attribute = rootAttribute.getAttribute(CloudDevAttribute.FOUND_IN_RELEASE.getTaskName());
        this.setStringValue(attribute, task.getFoundInRelease());
        if (task.getIteration() != null) {
            attribute = rootAttribute.getAttribute(CloudDevAttribute.ITERATION.getTaskName());
            attribute.setValue(task.getIteration().getValue());
        }
        attribute = rootAttribute.getAttribute(CloudDevAttribute.URL.getTaskName());
        attribute.setValue(task.getUrl());
        attribute = rootAttribute.getAttribute(CloudDevAttribute.ESTIMATED_TIME.getTaskName());
        BigDecimal estimatedTime = task.getEstimatedTime();
        if (estimatedTime == null) {
            attribute.clearValues();
        } else {
            attribute.setValue(estimatedTime.toString());
        }
        attribute = rootAttribute.getAttribute(CloudDevAttribute.REMAINING_TIME.getTaskName());
        BigDecimal remainingTime = task.getRemainingTime();
        if (remainingTime == null) {
            attribute.clearValues();
        } else {
            attribute.setValue(remainingTime.toString());
        }
        attribute = rootAttribute.getAttribute(CloudDevAttribute.SUM_OF_SUBTASKS_ESTIMATED_TIME.getTaskName());
        BigDecimal sumOfSubtasksEstimatedTime = task.getSumOfSubtasksEstimatedTime();
        if (sumOfSubtasksEstimatedTime == null) {
            attribute.clearValues();
        } else {
            attribute.setValue(sumOfSubtasksEstimatedTime.toString());
        }
        attribute = rootAttribute.getAttribute(CloudDevAttribute.SUM_OF_SUBTASKS_TIME_SPENT.getTaskName());
        BigDecimal sumOfSubtasksTimeSpent = task.getSumOfSubtasksTimeSpent();
        if (sumOfSubtasksTimeSpent == null) {
            attribute.clearValues();
        } else {
            attribute.setValue(sumOfSubtasksTimeSpent.toString());
        }
        String subtasks = this.getTaskIds(task.getSubTasks());
        if (subtasks != null) {
            attribute = rootAttribute.getAttribute(CloudDevAttribute.SUBTASKS.getTaskName());
            attribute.setValue(subtasks);
        }
        if (task.getParentTask() != null) {
            attribute = rootAttribute.getAttribute(CloudDevAttribute.PARENT_TASK.getTaskName());
            attribute.setValue("" + task.getParentTask().getId());
        }
        if (task.getDuplicateOf() != null) {
            attribute = rootAttribute.getAttribute(CloudDevAttribute.DUPLICATE_OF.getTaskName());
            attribute.setValue("" + task.getDuplicateOf().getId());
        }
        if ((deuplicates = task.getDuplicates()) != null && deuplicates.size() > 0) {
            attribute = rootAttribute.getAttribute(CloudDevAttribute.DUPLICATES.getTaskName());
            attribute.setValue(this.getTaskIds(deuplicates));
        }
        if ((keywords = task.getKeywords()) != null && keywords.size() > 0) {
            attribute = rootAttribute.getAttribute(CloudDevAttribute.KEYWORDS.getTaskName());
            attribute.setValues(this.getKeywordList(keywords));
        }
        if (task.getAssignee() != null) {
            attribute = rootAttribute.getAttribute(CloudDevAttribute.ASSIGNEE.getTaskName());
            person = this.taskRepository.createPerson(task.getAssignee().getLoginName());
            person.setName(task.getAssignee().getRealname());
            mapper.setRepositoryPerson(attribute, person);
        }
        if (task.getReporter() != null) {
            attribute = rootAttribute.getAttribute(CloudDevAttribute.REPORTER.getTaskName());
            person = this.taskRepository.createPerson(task.getReporter().getLoginName());
            person.setName(task.getReporter().getRealname());
            mapper.setRepositoryPerson(attribute, person);
        }
        if ((watchers = task.getWatchers()) != null && watchers.size() > 0) {
            attribute = rootAttribute.getAttribute(CloudDevAttribute.CC.getTaskName());
            ArrayList<String> cc = new ArrayList<String>();
            for (TaskUserProfile watcher : watchers) {
                cc.add(watcher.getLoginName());
            }
            attribute.setValues(cc);
        }
        int count = 1;
        for (Comment comment : task.getComments()) {
            TaskCommentMapper commentMapper = new TaskCommentMapper();
            commentMapper.setCommentId("" + comment.getId());
            TaskUserProfile author = comment.getAuthor();
            if (author != null) {
                IRepositoryPerson person2 = this.taskRepository.createPerson(author.getLoginName());
                person2.setName(author.getRealname());
                commentMapper.setAuthor(person2);
            }
            commentMapper.setText(comment.getCommentText());
            commentMapper.setCreationDate(comment.getCreationDate());
            commentMapper.setNumber(Integer.valueOf(count));
            TaskAttribute taskAttribute = taskData.getRoot().createAttribute("task.common.comment-" + count);
            commentMapper.applyTo(taskAttribute);
            ++count;
        }
        count = 1;
        List attachments = task.getAttachments();
        if (attachments != null && attachments.size() > 0) {
            for (Attachment attachment : attachments) {
                TaskAttachmentMapper attachmentMapper = new TaskAttachmentMapper();
                attachmentMapper.setAttachmentId("" + attachment.getId());
                TaskUserProfile submitter = attachment.getSubmitter();
                if (submitter != null) {
                    IRepositoryPerson person3 = this.taskRepository.createPerson(submitter.getLoginName());
                    person3.setName(submitter.getRealname());
                    attachmentMapper.setAuthor(person3);
                }
                attachmentMapper.setDescription(attachment.getDescription());
                attachmentMapper.setCreationDate(attachment.getCreationDate());
                attachmentMapper.setContentType(attachment.getMimeType());
                attachmentMapper.setFileName(attachment.getFilename());
                attachmentMapper.setLength(Long.valueOf(Long.parseLong(String.valueOf(attachment.getByteSize()))));
                attachmentMapper.setUrl(attachment.getUrl());
                TaskAttribute taskAttribute = taskData.getRoot().createAttribute("task.common.attachment-" + count);
                attachmentMapper.applyTo(taskAttribute);
                ++count;
            }
        }
        for (Map.Entry entry : task.getCustomFields().entrySet()) {
            attribute = rootAttribute.getAttribute((String)entry.getKey());
            if (attribute == null) continue;
            this.setStringValue(attribute, (String)entry.getValue());
        }
        this.updateAttributeOptions(taskData, task);
        this.addValidOperations(taskData);
    }

    private void updateAttributeOptions(TaskData taskData, Task task) {
        Product product;
        TaskAttribute root = taskData.getRoot();
        TaskAttribute taskAttribute = root.getAttribute(CloudDevAttribute.PRODUCT.getTaskName());
        if (taskAttribute != null && (product = this.getProduct(taskAttribute.getValue())) != null) {
            TaskAttribute componentAttribute = root.getAttribute(CloudDevAttribute.COMPONENT.getTaskName());
            componentAttribute.clearOptions();
            for (Component comp : product.getComponents()) {
                componentAttribute.putOption(comp.getName(), comp.getName());
            }
            if (task.getComponent() != null) {
                componentAttribute.setValue(task.getComponent().getName());
            } else if (product.getDefaultComponent() != null) {
                componentAttribute.setValue(product.getDefaultComponent().getName());
            }
            TaskAttribute milestoneAttribute = root.getAttribute(CloudDevAttribute.MILESTONE.getTaskName());
            milestoneAttribute.clearOptions();
            for (Milestone milestone : product.getMilestones()) {
                milestoneAttribute.putOption(milestone.getValue(), milestone.getValue());
            }
            if (task.getMilestone() != null) {
                milestoneAttribute.setValue(task.getMilestone().getValue());
            } else if (product.getDefaultMilestone() != null) {
                milestoneAttribute.setValue(product.getDefaultMilestone().getValue());
            }
        }
    }

    private void addValidOperations(TaskData taskData) {
        TaskAttribute root = taskData.getRoot();
        TaskAttribute statusAttribute = root.getAttribute(CloudDevAttribute.STATUS.getTaskName());
        RepositoryConfiguration config = this.getRepositoryConfiguration();
        TaskStatus status = config.getDefaultStatus();
        if (statusAttribute != null) {
            status = this.getStatus(statusAttribute.getValue());
        }
        ArrayList<CloudDevOperation> operations = new ArrayList<CloudDevOperation>();
        operations.add(CloudDevOperation.NONE);
        for (TaskStatus validStatus : config.computeValidStatuses(status)) {
            CloudDevOperation operation = CloudDevOperation.getByTaskStatus(validStatus);
            if (operation == CloudDevOperation.RESOLVED) {
                operations.add(operation);
                operations.add(CloudDevOperation.DUPLICATE);
                continue;
            }
            if (status.getValue().equals(validStatus.getValue())) continue;
            operations.add(operation);
        }
        Collections.sort(operations, new Comparator<CloudDevOperation>(){

            @Override
            public int compare(CloudDevOperation o1, CloudDevOperation o2) {
                return CloudDevClient.this.OPERATION_PREDEFINED_ORDER.indexOf((Object)o1) - CloudDevClient.this.OPERATION_PREDEFINED_ORDER.indexOf((Object)o2);
            }
        });
        for (CloudDevOperation operation : operations) {
            this.addOperation(taskData, operation);
        }
    }

    private void addOperation(TaskData taskData, CloudDevOperation operation) {
        if (operation == null) {
            return;
        }
        TaskAttribute root = taskData.getRoot();
        TaskAttribute operationAttribute = root.getAttribute("task.common.operation");
        if (operationAttribute == null) {
            operationAttribute = root.createAttribute("task.common.operation");
        }
        TaskAttribute attribute = root.createAttribute("task.common.operation-" + operation.getValue());
        switch (operation) {
            case NONE: {
                TaskAttribute statusAttribute = root.getMappedAttribute("task.common.status");
                TaskAttribute resolutionAttribute = root.getMappedAttribute("task.common.resolution");
                String label = operation.getLabel();
                if (statusAttribute != null && resolutionAttribute != null) {
                    label = String.valueOf(label) + " " + statusAttribute.getValue() + " " + resolutionAttribute.getValue();
                }
                TaskOperation.applyTo((TaskAttribute)attribute, (String)operation.getValue(), (String)label);
                TaskOperation.applyTo((TaskAttribute)operationAttribute, (String)operation.getValue(), (String)label);
                break;
            }
            case RESOLVED: {
                TaskOperation.applyTo((TaskAttribute)attribute, (String)operation.getValue(), (String)operation.getLabel());
                TaskAttribute resolvedInputAttribute = attribute.getTaskData().getRoot().createAttribute(operation.getInputId());
                resolvedInputAttribute.getMetaData().setType(operation.getInputType());
                attribute.getMetaData().putValue("task.meta.associated.attribute", operation.getInputId());
                for (TaskResolution resolution : this.getRepositoryConfiguration().getResolutions()) {
                    if (resolution.getValue().length() <= 0 || resolution.getValue().compareTo("DUPLICATE") == 0) continue;
                    resolvedInputAttribute.putOption(resolution.getValue(), resolution.getValue());
                }
                resolvedInputAttribute.setValue(this.getRepositoryConfiguration().getDefaultResolution().getValue());
                break;
            }
            case DUPLICATE: {
                TaskOperation.applyTo((TaskAttribute)attribute, (String)operation.getValue(), (String)operation.getLabel());
                if (operation.getInputId() == null) break;
                TaskAttribute attrInput = root.getAttribute(operation.getInputId());
                if (attrInput == null) {
                    attrInput = root.createAttribute(operation.getInputId());
                }
                attrInput.getMetaData().defaults().setReadOnly(false).setType(operation.getInputType());
                attribute.getMetaData().putValue("task.meta.associated.attribute", operation.getInputId());
                break;
            }
            default: {
                TaskOperation.applyTo((TaskAttribute)attribute, (String)operation.getValue(), (String)operation.getLabel());
            }
        }
    }

    private void setStringValue(TaskAttribute attribute, String value) {
        if (value == null) {
            attribute.clearValues();
        } else {
            attribute.setValue(value);
        }
    }

    private List<String> getKeywordList(List<Keyword> keywords) {
        ArrayList<String> list = new ArrayList<String>();
        for (Keyword keyword : keywords) {
            list.add(keyword.getName());
        }
        return list;
    }

    private String getTaskId(Task task) {
        if (task != null) {
            return "" + task.getId();
        }
        return "";
    }

    private String getTaskIds(List<Task> tasks) {
        if (tasks != null && tasks.size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (Task task : tasks) {
                if (builder.length() > 0) {
                    builder.append(",");
                }
                builder.append(task.getId());
            }
            return builder.toString();
        }
        return null;
    }

    private TaskAttribute createAttribute(TaskData taskData, CloudDevAttribute attribute) {
        TaskAttribute taskAttribute = taskData.getRoot().createAttribute(attribute.getTaskName());
        TaskAttributeMetaData metaData = taskAttribute.getMetaData();
        metaData.setLabel(attribute.getLabel());
        metaData.setType(attribute.getType());
        metaData.setReadOnly(attribute.isReadonly());
        metaData.setKind(attribute.getKind());
        return taskAttribute;
    }

    private TaskAttribute createAttribute(TaskData taskData, FieldDescriptor descriptor) {
        TaskAttribute taskAttribute = taskData.getRoot().createAttribute(descriptor.getName());
        TaskAttributeMetaData metaData = taskAttribute.getMetaData();
        metaData.setLabel(descriptor.getName());
        metaData.setKind("task.common.kind.default");
        switch (descriptor.getFieldType()) {
            case TEXT: {
                metaData.setType("shortText");
                break;
            }
            case SINGLE_SELECT: {
                metaData.setType("singleSelect");
                for (String value : descriptor.getValueStrings()) {
                    taskAttribute.putOption(value, value);
                }
                break;
            }
            case MULTI_SELECT: {
                metaData.setType("multiSelect");
                for (String value : descriptor.getValueStrings()) {
                    taskAttribute.putOption(value, value);
                }
                break;
            }
            case LONG_TEXT: {
                metaData.setType("longText");
                break;
            }
            case TIMESTAMP: {
                metaData.setType("dateTime");
                break;
            }
            case TASK_REFERENCE: {
                metaData.setType("taskDepenedency");
                break;
            }
        }
        return taskAttribute;
    }

    private static final boolean equal(Object obj1, Object obj2) {
        boolean objectsAreEqual = false;
        if (obj1 == obj2) {
            objectsAreEqual = true;
        } else if (obj1 != null && obj2 != null) {
            objectsAreEqual = obj1.getClass().isArray() && obj2.getClass().isArray() ? Arrays.equals((Object[])obj1, (Object[])obj2) : obj1.equals(obj2);
        }
        return objectsAreEqual;
    }
}

