/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev.tasks;

public enum CloudDevAttribute {
    SHORT_DESCRIPTION("shortDescription", "task.common.summary", "Summary:", "shortRichText"),
    DESCRIPTION("description", "task.common.description", "Description:", "longRichText"),
    CREATION_DATE("creationDate", "task.common.date.created", "Creation Date:", "date"),
    MODIFIED_DATE("modifiedDate", "task.common.date.modified", "Modified Date:", "date"),
    STATUS("status", "task.common.status", "Status:", "shortText", true, false),
    STATUS_NEW("status", "task.common.status", "Status:", "singleSelect", false, true),
    RESOLUTION("resolution", "task.common.resolution", "Resolution:", "singleSelect", true, true),
    TASK_TYPE("taskType", "TASK_TYPE", "Task Type:", "singleSelect", false, true),
    VERSION("version", "task.common.version", "Version:", "shortText", true, false),
    NEW_COMMENT("newComment", "task.common.comment.new", "Comment:", "longRichText"),
    ASSIGNEE("assignee", "task.common.user.assigned", "Assignee:", "person"),
    REPORTER("reporter", "task.common.user.reporter", "Reporter:", "person", true, false),
    CC("cc", "task.common.user.cc", "CC:", "cloud.dev.cc"),
    SUBTASKS("subtasks", "SUBTASKS", "Subtasks:", "taskDepenedency", false, true),
    PARENT_TASK("parentTask", "PARENT_BLOCKS", "Parent Task:", "taskDepenedency", false, true),
    DUPLICATE_OF("deplicateOf", "DUPLICATE_OF", "Duplicate of:", "taskDepenedency", true, false),
    DUPLICATES("deplicates", "DUPLICATES", "Duplicates:", "taskDepenedency", true, false),
    KEYWORDS("keywords", "task.common.keywords", "Keywords:", "cloud.dev.keywords", false, true),
    PRIORITY("priority", "task.common.priority", "Priority:", "singleSelect", false, true),
    SEVERITY("severity", "task.common.severity", "Severity:", "singleSelect", false, true),
    PRODUCT("product", "task.common.product", "Product:", "singleSelect", false, true),
    COMPONENT("component", "task.common.component", "Component:", "singleSelect", false, true),
    MILESTONE("milestone", "MILESTONE", "Milestone:", "singleSelect", false, true),
    ITERATION("iteration", "ITERATION", "Iteration:", "singleSelect", false, true),
    URL("url", "task.common.url", "URL:", "url", true, false),
    ESTIMATED_TIME("estimateTime", "ESTIMATED_TIME", "Estimated Time:", "shortText", false, true),
    REMAINING_TIME("remainingTime", "REMAINING_TIME", "Remaining Time:", "shortText", false, true),
    SUM_OF_SUBTASKS_ESTIMATED_TIME("sumOfSubtasksEstimatedTime", "SUM_OF_SUBTASKS_ESTIMATED_TIME", "Subtasks Estimated Time:", "shortText", true, true),
    SUM_OF_SUBTASKS_TIME_SPENT("sumOfSubtasksTimeSpent", "SUM_OF_SUBTASKS_TIME_SPENT", "Subtasks Time Spent:", "shortText", true, true),
    DEADLINE("deadline", "task.common.date.due", "Due Date:", "date", false, true),
    FOUND_IN_RELEASE("foundInRelease", "FOUND_IN_RELEASE", "Found in Release:", "shortText", false, true);

    private final String name;
    private final String taskName;
    private final String label;
    private final String type;
    private final boolean readonly;
    private final boolean attribute;

    public static CloudDevAttribute getByName(String name) {
        CloudDevAttribute[] cloudDevAttributeArray = CloudDevAttribute.values();
        int n = cloudDevAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CloudDevAttribute attr = cloudDevAttributeArray[n2];
            if (name.equals(attr.getName())) {
                return attr;
            }
            ++n2;
        }
        return null;
    }

    public static CloudDevAttribute getByTaskName(String taskName) {
        CloudDevAttribute[] cloudDevAttributeArray = CloudDevAttribute.values();
        int n = cloudDevAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CloudDevAttribute attr = cloudDevAttributeArray[n2];
            if (taskName.equals(attr.getTaskName())) {
                return attr;
            }
            ++n2;
        }
        return null;
    }

    private CloudDevAttribute(String name, String taskName, String label, String type) {
        this(name, taskName, label, type, false, false);
    }

    private CloudDevAttribute(String name, String taskName, String label, String type, boolean readonly, boolean attribute) {
        this.name = name;
        this.taskName = taskName;
        this.label = label;
        this.type = type;
        this.readonly = readonly;
        this.attribute = attribute;
    }

    public String getName() {
        return this.name;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getLabel() {
        return this.label;
    }

    public String getType() {
        return this.type;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public boolean isAttribute() {
        return this.attribute;
    }

    public String getKind() {
        if (this.isAttribute()) {
            return "task.common.kind.default";
        }
        return null;
    }
}

