/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.wtp.java.core.export;

import oracle.eclipse.tools.common.wtp.java.core.export.ExportDataModelProvider;
import oracle.eclipse.tools.common.wtp.java.core.export.ExportExtensionManager;
import oracle.eclipse.tools.common.wtp.java.core.export.IExportContext;
import oracle.eclipse.tools.common.wtp.java.core.internal.CommonWtpJavaExtensionsPlugin;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.osgi.framework.Bundle;

public abstract class AbstractExportOperation
extends AbstractDataModelOperation {
    private ExportExtensionManager.OperationType type;
    private boolean isPreOperation;
    private IDataModel nestedModel;

    public AbstractExportOperation(ExportExtensionManager.OperationType type, boolean isPreOperation) {
        this.type = type;
        this.isPreOperation = isPreOperation;
        this.nestedModel = DataModelFactory.createDataModel((IDataModelProvider)new ExportDataModelProvider());
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        IDataModel model = this.getDataModel();
        IExportContext context = this.getContext(model, this.isPreOperation);
        this.nestedModel.setProperty("IOracleExportDataModelProperties.EXPORT_CONTEXT", (Object)context);
        model.addNestedModel("ExportDataModelProvider", this.nestedModel);
        try {
            try {
                context.initialize();
                for (ExportExtensionManager.ExportOperationElement element : ExportExtensionManager.getInstance().getExportOperations(this.type)) {
                    if (status.isOK()) {
                        IDataModelOperation op = this.isPreOperation ? element.getPreOperation() : element.getPostOperation();
                        if (op == null) continue;
                        op.setDataModel(model);
                        status = op.execute(monitor, info);
                        continue;
                    }
                    Platform.getLog((Bundle)CommonWtpJavaExtensionsPlugin.getBundle()).log(status);
                }
            }
            catch (Exception e) {
                CommonWtpJavaExtensionsPlugin.logException(e);
                context.close();
            }
        }
        finally {
            context.close();
        }
        return status;
    }

    public abstract IExportContext getContext(IDataModel var1, boolean var2);
}

