/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.wtp.core;

import java.util.Collection;
import java.util.Collections;
import oracle.eclipse.tools.common.util.IOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.ResourceManager;

public class ServerUtil {
    public static String createDefaultRuntimeName(IRuntimeType rtype) {
        return ServerUtil.createDefaultRuntimeName(rtype, null);
    }

    public static String createDefaultRuntimeName(IRuntimeType rtype, Collection<String> namesToAvoid) {
        if (namesToAvoid == null) {
            namesToAvoid = Collections.emptyList();
        }
        int counter = 1;
        String name;
        while (ServerCore.findRuntime((String)(name = ServerUtil.createDefaultRuntimeName(rtype, counter))) != null || namesToAvoid.contains(name)) {
            ++counter;
        }
        return name;
    }

    private static String createDefaultRuntimeName(IRuntimeType rtype, int counter) {
        StringBuilder buf = new StringBuilder();
        buf.append(rtype.getName());
        if (counter != 1) {
            buf.append(" (");
            buf.append(counter);
            buf.append(')');
        }
        return buf.toString();
    }

    public static boolean isAssociatedWithServer(IServer server, IProject project) {
        return ServerUtil.isAssociatedWithServer(server, project, server.getModules());
    }

    private static boolean isAssociatedWithServer(IServer server, IProject project, IModule[] modulesToSearch) {
        if (modulesToSearch == null) {
            return false;
        }
        IModule[] iModuleArray = modulesToSearch;
        int n = modulesToSearch.length;
        int n2 = 0;
        while (n2 < n) {
            IModule m = iModuleArray[n2];
            if (m != null) {
                IProject p = m.getProject();
                if (p != null && p.equals((Object)project)) {
                    return true;
                }
                IModule[] childModules = server.getChildModules(new IModule[]{m}, null);
                if (ServerUtil.isAssociatedWithServer(server, project, childModules)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public static void removeModulesFromServer(IServer server, IModule ... modules) throws CoreException {
        IServerWorkingCopy wc = server.createWorkingCopy();
        wc.modifyModules(null, modules, null);
        wc.save(true, null);
    }

    public static void removeModulesFromServer(IServer server, Collection<IModule> modules) throws CoreException {
        ServerUtil.removeModulesFromServer(server, modules.toArray(new IModule[modules.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void modifyServerCoreMetadata(IOperation operation) throws CoreException {
        ResourceManager resourceManager = ResourceManager.getInstance();
        synchronized (resourceManager) {
            try {
                operation.execute(null);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

