/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.wtp.webxml;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.operations.OperationUtil;
import oracle.eclipse.tools.common.util.ObjectUtil;
import oracle.eclipse.tools.common.util.wtp.webxml.WebXmlUtilsForJ2EE;
import oracle.eclipse.tools.common.util.wtp.webxml.WebXmlUtilsForJavaEE;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebXmlUtils {
    public static final IPath WEB_XML_PATH = new Path("WEB-INF").append("web.xml");

    public static boolean isMappedUri(IProject project, String uri) {
        int indexQuery;
        if (project == null || uri == null) {
            return false;
        }
        List<String> patterns = null;
        Object webAppObj = ModelProviderManager.getModelProvider((IProject)project).getModelObject();
        if (webAppObj != null) {
            if (webAppObj instanceof WebApp) {
                patterns = WebXmlUtilsForJavaEE.getServletMappingPatterns((WebApp)webAppObj);
            } else if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                patterns = WebXmlUtilsForJ2EE.getServletMappingPatterns((org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj);
            }
        }
        if ((indexQuery = uri.indexOf(63)) > 0) {
            uri = uri.substring(0, indexQuery);
        }
        return WebXmlUtils.isMappedUri(uri, patterns);
    }

    private static boolean isMappedUri(String uri, List<String> patterns) {
        if (patterns == null) {
            return false;
        }
        for (String pattern : patterns) {
            String target;
            int indexStarDot = pattern.indexOf("*.");
            int indexStar = pattern.indexOf(42);
            if (indexStarDot == 0) {
                String target2;
                String extension = WebXmlUtils.getFileExtension(uri);
                if (pattern.length() <= 2 || (target2 = pattern.substring(indexStarDot + 2)).equalsIgnoreCase("jsp") || !ObjectUtil.equals(extension, target2)) continue;
                return true;
            }
            if (!(indexStar == pattern.length() - 1 ? uri.startsWith(target = pattern.substring(0, indexStar)) : uri.equals("/") || pattern.equalsIgnoreCase(uri))) continue;
            return true;
        }
        return false;
    }

    private static String getFileExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex < 0) {
            return null;
        }
        return fileName.substring(dotIndex + 1);
    }

    public static IDOMModel getWebXmlModelForEdit(IProject project) throws CoreException {
        String WEB_CONTENT_FOLDER = OperationUtil.getWebContentFolderName(project);
        IFile webXmlIfile = project.getFile(String.valueOf(WEB_CONTENT_FOLDER) + "/WEB-INF/web.xml");
        if (!webXmlIfile.exists()) {
            throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.common", "web.xml not found in project " + project.getName()));
        }
        try {
            return (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(webXmlIfile);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.common", e.getLocalizedMessage()));
        }
    }

    public static void saveWebXmlModel(IDOMModel model) throws CoreException {
        try {
            model.save();
        }
        catch (UnsupportedEncodingException e) {
            throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.common", e.getLocalizedMessage()));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.common", e.getLocalizedMessage()));
        }
    }

    public static List<Node> getNodes(IDOMModel model, String nodeName, String childNodeName, String childNodeValue) {
        ArrayList<Node> result = new ArrayList<Node>();
        NodeList nodes = model.getDocument().getElementsByTagName(nodeName);
        int numberOfNodes = nodes.getLength();
        int i = 0;
        while (i < numberOfNodes) {
            Node node = nodes.item(i);
            NodeList childNodes = node.getChildNodes();
            int numberOfChildNodes = childNodes.getLength();
            int j = 0;
            while (j < numberOfChildNodes) {
                String childNodeTextContent;
                Node childNode = childNodes.item(j);
                if (childNode.getNodeName().equals(childNodeName) && (childNodeTextContent = childNode.getFirstChild().getNodeValue()).trim().equals(childNodeValue)) {
                    result.add(node);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static void removeNodes(List<Node> nodes) {
        if (nodes.size() == 0) {
            return;
        }
        Node parentNode = nodes.get(0).getParentNode();
        for (Node node : nodes) {
            Node previousSibling = node.getPreviousSibling();
            if (previousSibling != null && WebXmlUtils.isWhitespaceTextNode(previousSibling)) {
                parentNode.removeChild(previousSibling);
            }
            parentNode.removeChild(node);
        }
    }

    private static boolean isWhitespaceTextNode(Node node) {
        return node != null && node.getNodeType() == 3 && node.getNodeValue().trim().length() == 0;
    }

    public static void removeNodes(IDOMModel model, String nodeName, String childNodeName, String childNodeValue) {
        WebXmlUtils.removeNodes(WebXmlUtils.getNodes(model, nodeName, childNodeName, childNodeValue));
    }
}

