/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.wtp.webxml;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.CommonToolsPlugin;
import oracle.eclipse.tools.common.util.wtp.webxml.internal.AbstractWebXmlUpdater;
import oracle.eclipse.tools.common.util.wtp.webxml.internal.WebXmlUpdaterForJ2EE;
import oracle.eclipse.tools.common.util.wtp.webxml.internal.WebXmlUpdaterForJavaEE;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public class WebXmlUpdater {
    private final IProject project;
    private final IProgressMonitor monitor;
    private final AbstractWebXmlUpdater updater;
    private IModelProvider provider;

    public WebXmlUpdater(IProject project, IProgressMonitor monitor) {
        this.project = project;
        this.monitor = monitor;
        try {
            this.provider = FacetedProjectFramework.isFacetedProject((IProject)project) ? ModelProviderManager.getModelProvider((IProject)project) : null;
        }
        catch (CoreException e) {
            CommonToolsPlugin.log((Exception)((Object)e));
            this.provider = null;
        }
        this.updater = this.initUpdater();
    }

    public IModelProvider getProvider() {
        return this.provider;
    }

    public boolean isJavaEEWebapp() {
        return this.updater instanceof WebXmlUpdaterForJavaEE;
    }

    public boolean isJ2EEWebapp() {
        return this.updater instanceof WebXmlUpdaterForJ2EE;
    }

    public void addServlet(String servletName, String servletClass, String loadOnStartup) {
        this.updater.addServlet(servletName, servletClass, loadOnStartup);
    }

    public void removeServlet(String servletClassName) {
        this.updater.removeServlet(servletClassName);
    }

    public void addServletMapping(String servletName, String servletClass, String urlPattern) {
        this.updater.addServletMapping(servletName, servletClass, urlPattern);
    }

    public void addFilter(String filterName, String filterClass) {
        this.updater.addFilter(filterName, filterClass);
    }

    public void removeFilter(String filterName) {
        this.updater.removeFilter(filterName);
    }

    public void addFilterMapping(String filterName, String filterClass, String servletName) {
        this.updater.addFilterMapping(filterName, filterClass, servletName);
    }

    public void addFilterMapping(String filterName, String filterClass, String servletName, List<String> dispatchers) {
        this.updater.addFilterMapping(filterName, filterClass, servletName, dispatchers);
    }

    public void addContextParam(String paramName, String paramValue, String description) {
        this.updater.addContextParam(paramName, paramValue, description);
    }

    public void addCommaSeparatedValueToContextParam(String paramName, String paramValue) {
        this.updater.addCommaSeparatedValueToContextParam(paramName, paramValue);
    }

    public void removeContextParam(String paramName, String paramValue) {
        this.updater.removeContextParam(paramName, paramValue);
    }

    public void addListener(String listenerClass) {
        this.updater.addListener(listenerClass);
    }

    public void removeListener(String listenerClass) {
        this.updater.removeListener(listenerClass);
    }

    public List<String> getContextParamValues(String paramName) {
        return this.updater.getContextParamValues(paramName);
    }

    private AbstractWebXmlUpdater initUpdater() {
        Object webAppObj;
        IModelProvider modelProvider;
        IModelProvider iModelProvider = modelProvider = ModelProviderManager.hasModelProvider((IProject)this.project) ? ModelProviderManager.getModelProvider((IProject)this.project) : null;
        if (modelProvider != null && (webAppObj = modelProvider.getModelObject()) != null) {
            if (webAppObj instanceof WebApp) {
                return new WebXmlUpdaterForJavaEE(webAppObj, this.project, this.getProvider(), this.monitor);
            }
            if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                return new WebXmlUpdaterForJ2EE(webAppObj, this.project, this.getProvider(), this.monitor);
            }
        }
        return new NullWebXmlUpdater(this.project, this.monitor);
    }

    public static class NullWebXmlUpdater
    extends AbstractWebXmlUpdater {
        public NullWebXmlUpdater(IProject project, IProgressMonitor monitor) {
            super(null, project, null, monitor);
        }

        @Override
        public void addServlet(String servletName, String servletClass, String loadOnStartup) {
        }

        @Override
        public void addServletMapping(String servletName, String servletClass, String urlPattern) {
        }

        @Override
        public void removeServlet(String servletClassName) {
        }

        @Override
        public void addFilter(String filterName, String filterClass) {
        }

        @Override
        public void removeFilter(String filterName) {
        }

        @Override
        public void addFilterMapping(String filterName, String filterClass, String servletName) {
        }

        @Override
        public void addFilterMapping(String filterName, String filterClass, String servletName, List<String> dispatchers) {
        }

        @Override
        public void addContextParam(String paramName, String paramValue, String description) {
        }

        @Override
        public void addCommaSeparatedValueToContextParam(String paramName, String paramValue) {
        }

        @Override
        public void removeContextParam(String paramName, String paramValue) {
        }

        @Override
        public List<String> getContextParamValues(String paramName) {
            return Collections.emptyList();
        }

        @Override
        public void addListener(String listenerClass) {
        }

        @Override
        public void removeListener(String listenerClass) {
        }
    }
}

