/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.wtp.validation.internal.model;

import oracle.eclipse.tools.common.util.wtp.validation.internal.Deserializer;
import oracle.eclipse.tools.common.util.wtp.validation.internal.Serializer;

public class FilterRule {
    private String _pattern;
    private String _type;
    protected static final String PortableFileDelim = "/";

    static FilterRule create(Deserializer des) {
        String type = des.getString();
        if ("fileext".equals(type)) {
            String pattern = des.getString();
            boolean caseSensitive = des.getBoolean();
            return new FileExt(pattern, caseSensitive);
        }
        if ("projectNature".equals(type)) {
            String pattern = des.getString();
            return new ProjectNature(pattern);
        }
        if ("file".equals(type)) {
            String pattern = des.getString();
            boolean caseSensitive = des.getBoolean();
            int fileType = des.getInt();
            return FilterRule.createFileRule(pattern, caseSensitive, fileType);
        }
        if ("contentType".equals(type)) {
            String pattern = des.getString();
            boolean exactMatch = des.getBoolean();
            return new ContentType(pattern, exactMatch);
        }
        if ("facet".equals(type)) {
            String pattern = des.getString();
            return new Facet(pattern, null);
        }
        if ("pattern".equals(type)) {
            String pattern = des.getString();
            boolean caseSensitive = des.getBoolean();
            return new FilePattern(pattern, caseSensitive);
        }
        return null;
    }

    public static File createFileRule(String pattern, boolean caseSensitive, int fileType) {
        return new File(pattern, caseSensitive, fileType);
    }

    private FilterRule(String pattern, String type) {
        this._pattern = pattern;
        this._type = type;
    }

    public String getPattern() {
        return this._pattern;
    }

    public String getType() {
        return this._type;
    }

    public void save(Serializer ser) {
        ser.put(this.getType());
        ser.put(this.getPattern());
    }

    /* synthetic */ FilterRule(String string, String string2, FilterRule filterRule) {
        this(string, string2);
    }

    public static final class ContentType
    extends FilterRule {
        private final boolean _exactMatch;

        private ContentType(String pattern, boolean exactMatch) {
            super(pattern, "contentType", null);
            this._exactMatch = exactMatch;
        }

        @Override
        public void save(Serializer ser) {
            super.save(ser);
            ser.put(this._exactMatch);
        }
    }

    public static final class Facet
    extends FilterRule {
        public Facet(String facetId, String versionExpression) {
            super(facetId, "facet", null);
        }
    }

    public static final class File
    extends FilterRuleCaseSensitive {
        private final int _type;
        public static final int FileTypeFile = 1;
        public static final int FileTypeFolder = 2;
        public static final int FileTypeFull = 3;

        private File(String pattern, boolean caseSensitive, int type) {
            super(pattern, caseSensitive, "file");
            this._type = type;
        }

        @Override
        public void save(Serializer ser) {
            super.save(ser);
            ser.put(this._type);
        }
    }

    public static final class FileExt
    extends FilterRuleCaseSensitive {
        private FileExt(String pattern, boolean caseSensitive) {
            super(pattern, caseSensitive, "fileext");
        }
    }

    public static final class FilePattern
    extends FilterRuleCaseSensitive {
        private FilePattern(String pattern, boolean caseSensitive) {
            super(pattern, caseSensitive, "pattern");
        }
    }

    public static abstract class FilterRuleCaseSensitive
    extends FilterRule {
        private final boolean _caseSensitive;

        public FilterRuleCaseSensitive(String pattern, boolean caseSensitive, String type) {
            super(pattern, type, null);
            this._caseSensitive = caseSensitive;
        }

        @Override
        public void save(Serializer ser) {
            super.save(ser);
            ser.put(this._caseSensitive);
        }

        public boolean isCaseSensitive() {
            return this._caseSensitive;
        }
    }

    public static final class ProjectNature
    extends FilterRule {
        public ProjectNature(String projectNature) {
            super(projectNature, "projectNature", null);
        }
    }
}

