/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.wtp.validation.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.util.wtp.validation.internal.Deserializer;
import oracle.eclipse.tools.common.util.wtp.validation.internal.Serializer;
import oracle.eclipse.tools.common.util.wtp.validation.internal.model.FilterGroup;
import oracle.eclipse.tools.common.util.wtp.validation.internal.model.FilterRule;

public class FilterGroups {
    private ArrayList<FilterGroup> filterGroups = new ArrayList();

    public FilterGroups(String serializedValue) {
        if (serializedValue.trim().length() > 0) {
            Deserializer deserialize = new Deserializer(serializedValue);
            while (deserialize.hasNext()) {
                FilterGroup group = FilterGroup.create(deserialize);
                this.filterGroups.add(group);
            }
        }
    }

    public String getSerializedValue() {
        Serializer serializer = new Serializer(500);
        for (FilterGroup group : this.filterGroups) {
            group.save(serializer);
        }
        return serializer.toString();
    }

    public List<FilterGroup> getGroups() {
        return Collections.unmodifiableList(this.filterGroups);
    }

    public FilterGroup createGroup(String type) {
        FilterGroup group = FilterGroup.create(type, new FilterRule[0]);
        if (group != null) {
            this.filterGroups.add(group);
        }
        return group;
    }
}

