/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.wtp.validation.internal.model;

import java.util.LinkedList;
import oracle.eclipse.tools.common.util.wtp.validation.internal.Deserializer;
import oracle.eclipse.tools.common.util.wtp.validation.internal.Serializer;
import oracle.eclipse.tools.common.util.wtp.validation.internal.model.FilterRule;

public abstract class FilterGroup {
    private static final int SerializationVersion = 1;
    private FilterRule[] _rules;

    private FilterGroup(FilterRule[] rules) {
        this._rules = rules;
    }

    public final FilterRule[] getRules() {
        FilterRule[] rules = new FilterRule[this._rules.length];
        System.arraycopy(this._rules, 0, rules, 0, this._rules.length);
        return rules;
    }

    public void addRule(FilterRule rule) {
        FilterRule[] rules = new FilterRule[this._rules.length + 1];
        System.arraycopy(this._rules, 0, rules, 0, this._rules.length);
        rules[rules.length - 1] = rule;
        this._rules = rules;
    }

    public abstract String getType();

    public static FilterGroup create(Deserializer des) {
        des.getInt();
        String type = des.getString();
        int numberRules = des.getInt();
        LinkedList<FilterRule> list = new LinkedList<FilterRule>();
        int i = 0;
        while (i < numberRules) {
            FilterRule rule = FilterRule.create(des);
            if (rule != null) {
                list.add(rule);
            }
            ++i;
        }
        FilterRule[] rules = new FilterRule[list.size()];
        list.toArray(rules);
        return FilterGroup.create(type, rules);
    }

    public static FilterGroup create(String name, FilterRule[] rules) {
        if ("include".equals(name)) {
            return new FilterIncludeGroup(rules);
        }
        if ("exclude".equals(name)) {
            return new FilterExcludeGroup(rules);
        }
        return null;
    }

    public void save(Serializer ser) {
        ser.put(1);
        ser.put(this.getType());
        ser.put(this._rules.length);
        FilterRule[] filterRuleArray = this._rules;
        int n = this._rules.length;
        int n2 = 0;
        while (n2 < n) {
            FilterRule rule = filterRuleArray[n2];
            rule.save(ser);
            ++n2;
        }
    }

    /* synthetic */ FilterGroup(FilterRule[] filterRuleArray, FilterGroup filterGroup) {
        this(filterRuleArray);
    }

    public static final class FilterExcludeGroup
    extends FilterGroup {
        private FilterExcludeGroup(FilterRule[] rules) {
            super(rules, null);
        }

        @Override
        public String getType() {
            return "exclude";
        }
    }

    public static final class FilterIncludeGroup
    extends FilterGroup {
        private FilterIncludeGroup(FilterRule[] rules) {
            super(rules, null);
        }

        @Override
        public String getType() {
            return "include";
        }
    }
}

