/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.wtp.validation.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.util.wtp.validation.IValidatorUtil;
import oracle.eclipse.tools.common.util.wtp.validation.internal.model.FilterGroup;
import oracle.eclipse.tools.common.util.wtp.validation.internal.model.FilterGroups;
import oracle.eclipse.tools.common.util.wtp.validation.internal.model.FilterRule;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.validation.IMutableValidator;
import org.eclipse.wst.validation.MutableProjectSettings;
import org.eclipse.wst.validation.MutableWorkspaceSettings;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.internal.ValidatorMutable;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProvisionalValidatorUtil
implements IValidatorUtil {
    @Override
    public synchronized void disableValidation(IProject project, String ... validatorsToDisable) throws CoreException {
        assert (project != null) : "Must specify a non-null Project";
        assert (validatorsToDisable.length > 0) : "Must specify a validator to disable";
        if (!project.exists() || !project.isOpen()) {
            LoggingService.logInfo("oracle.eclipse.tools.common", "Unable to disable validators since the project is inaccessible");
            return;
        }
        try {
            ValidationFramework validationFramework = ValidationFramework.getDefault();
            MutableWorkspaceSettings workspaceSettings = validationFramework.getWorkspaceSettings();
            if (!workspaceSettings.getOverride()) {
                return;
            }
            MutableProjectSettings oldSettings = validationFramework.getProjectSettings(project);
            IMutableValidator[] validators = this.replaceValidators(oldSettings.getValidators(), workspaceSettings.getValidators());
            String[] stringArray = validatorsToDisable;
            int n = validatorsToDisable.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                IMutableValidator validator = this.getValidator(id, validators);
                validator.setBuildValidation(false);
                ++n2;
            }
            MutableProjectSettings newSettings = new MutableProjectSettings(project, validators);
            newSettings.setOverride(true);
            newSettings.setSuspend(oldSettings.getSuspend());
            validationFramework.applyChanges(newSettings, true);
            this.fixDisabledValidatorPreferences(project, validatorsToDisable);
        }
        catch (InvocationTargetException x) {
            Status status = new Status(4, "oracle.eclipse.tools.common", 4, x.getMessage(), (Throwable)x);
            throw new CoreException((IStatus)status);
        }
    }

    @Override
    public synchronized void addExcludeFileToProjectValidator(IProject project, String validatorId, String relativeDirectoryToExclude) throws CoreException {
        assert (project != null) : "Must specify a non-null Project";
        assert (validatorId != null) : "Must specify a validator ID to exclude";
        assert (relativeDirectoryToExclude != null) : "Must specify a relative directory to exclude";
        if (!project.exists() || !project.isOpen()) {
            LoggingService.logInfo("oracle.eclipse.tools.common", "Unable to disable validators since the project is inaccessible");
            return;
        }
        try {
            ValidationFramework validationFramework = ValidationFramework.getDefault();
            MutableWorkspaceSettings workspaceSettings = validationFramework.getWorkspaceSettings();
            if (!workspaceSettings.getOverride()) {
                return;
            }
            MutableProjectSettings oldSettings = validationFramework.getProjectSettings(project);
            IMutableValidator[] validators = this.replaceValidators(oldSettings.getValidators(), workspaceSettings.getValidators());
            IMutableValidator validator = this.getValidator(validatorId, validators);
            boolean modif = false;
            if (validator instanceof ValidatorMutable) {
                org.eclipse.wst.validation.internal.model.FilterGroup[] groups;
                ValidatorMutable vm = (ValidatorMutable)validator;
                org.eclipse.wst.validation.internal.model.FilterGroup[] filterGroupArray = groups = vm.getGroups();
                int n = groups.length;
                int n2 = 0;
                while (n2 < n) {
                    org.eclipse.wst.validation.internal.model.FilterGroup group = filterGroupArray[n2];
                    if (group.isExclude()) {
                        org.eclipse.wst.validation.internal.model.FilterRule rule = org.eclipse.wst.validation.internal.model.FilterRule.createFile((String)relativeDirectoryToExclude, (boolean)false, (int)2);
                        org.eclipse.wst.validation.internal.model.FilterGroup newGroup = org.eclipse.wst.validation.internal.model.FilterGroup.addRule((org.eclipse.wst.validation.internal.model.FilterGroup)group, (org.eclipse.wst.validation.internal.model.FilterRule)rule);
                        vm.replaceFilterGroup(group, newGroup);
                        modif = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (modif) {
                MutableProjectSettings newSettings = new MutableProjectSettings(project, validators);
                newSettings.setOverride(true);
                newSettings.setSuspend(oldSettings.getSuspend());
                validationFramework.applyChanges(newSettings, true);
            }
        }
        catch (InvocationTargetException x) {
            Status status = new Status(4, "oracle.eclipse.tools.common", 4, x.getMessage(), (Throwable)x);
            throw new CoreException((IStatus)status);
        }
    }

    @Override
    public void addExcludeFileToWorkspaceV2Validator(String validatorId, String relativeDirectoryToExclude) {
        if (!"org.eclipse.wst.xml.core.xml".equals(validatorId)) {
            return;
        }
        ValidationFramework validationFramework = ValidationFramework.getDefault();
        IEclipsePreferences preferences = validationFramework.getPreferenceStore();
        int keys = 0;
        try {
            keys = preferences.keys().length;
        }
        catch (BackingStoreException backingStoreException) {}
        if (keys == 0) {
            try {
                MutableWorkspaceSettings workspaceSettings = validationFramework.getWorkspaceSettings();
                validationFramework.applyChanges(workspaceSettings, true);
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        Preferences node = preferences.node("vals").node(validatorId);
        boolean changed = false;
        String defaultValue = "0107include05111contentType128org.eclipse.core.runtime.xmlT111contentType134org.eclipse.wst.xml.core.xmlsourceT111contentType134org.eclipse.wst.xml.core.xslsourceT111contentType134org.eclipse.jst.jsp.core.tldsourceT07fileext03xmlF0107exclude05113projectNature134org.eclipse.jst.j2ee.ejb.EJBNature113projectNature130org.eclipse.jst.j2ee.EARNature04file08.projectT0104file110.classpathT0104file110.settings/T02";
        changed = this.addExcludeToValidatorPreferences(node, relativeDirectoryToExclude, defaultValue);
        if (changed) {
            try {
                preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    private IMutableValidator[] replaceValidators(IMutableValidator[] projectValidators, IMutableValidator[] workspaceValidators) {
        ArrayList<IMutableValidator> validators = new ArrayList<IMutableValidator>();
        IMutableValidator[] iMutableValidatorArray = workspaceValidators;
        int n = workspaceValidators.length;
        int n2 = 0;
        while (n2 < n) {
            IMutableValidator validator = iMutableValidatorArray[n2];
            IMutableValidator tempValidator = this.getValidator(validator.getId(), projectValidators);
            if (tempValidator != null) {
                validator = tempValidator;
            }
            validators.add(validator);
            ++n2;
        }
        return validators.toArray(new IMutableValidator[0]);
    }

    private IMutableValidator getValidator(String id, IMutableValidator[] validators) {
        IMutableValidator[] iMutableValidatorArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            IMutableValidator validator = iMutableValidatorArray[n2];
            if (id.equals(validator.getId())) {
                return validator;
            }
            ++n2;
        }
        return null;
    }

    private void fixDisabledValidatorPreferences(IProject project, String ... validatorsToDisable) {
        boolean changed = false;
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences preferences = context.getNode("org.eclipse.wst.validation");
        String[] stringArray = validatorsToDisable;
        int n = validatorsToDisable.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            changed = this.fixDisabledValidatorPreference(id, preferences);
            ++n2;
        }
        try {
            if (changed) {
                preferences.flush();
            }
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private boolean fixDisabledValidatorPreference(String id, IEclipsePreferences preferences) {
        String validatorEntry;
        boolean changed = false;
        String USER_BUILD_PREFERENCE_KEY = "USER_BUILD_PREFERENCE";
        String build = preferences.get(USER_BUILD_PREFERENCE_KEY, "");
        int index = build.indexOf(validatorEntry = String.valueOf(id) + ";");
        if (index != -1) {
            int startIndex = index - 1;
            if (index == 0) {
                startIndex = 0;
            }
            build = String.valueOf(build.substring(0, startIndex)) + build.substring(startIndex + validatorEntry.length());
            preferences.put(USER_BUILD_PREFERENCE_KEY, build);
            changed = true;
        }
        return changed;
    }

    private boolean addExcludeToValidatorPreferences(Preferences validatorNode, String relativeDirectoryToExclude, String defaultValue) {
        String groups = validatorNode.get("groups", defaultValue);
        FilterGroups groupPrefs = new FilterGroups(groups);
        List<FilterGroup> filterGroups = groupPrefs.getGroups();
        FilterGroup group = null;
        for (FilterGroup currentGroup : filterGroups) {
            if (!"exclude".equals(currentGroup.getType())) continue;
            group = currentGroup;
        }
        if (group == null) {
            group = groupPrefs.createGroup("exclude");
        }
        if (group != null && !this.fileRuleExists(group, relativeDirectoryToExclude)) {
            FilterRule.File fileRule = FilterRule.createFileRule(relativeDirectoryToExclude, false, 2);
            group.addRule(fileRule);
            validatorNode.put("groups", groupPrefs.getSerializedValue());
            return true;
        }
        return false;
    }

    private boolean fileRuleExists(FilterGroup group, String file) {
        FilterRule[] rules = group.getRules();
        boolean exists = false;
        FilterRule[] filterRuleArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            FilterRule.File fileRule;
            FilterRule rule = filterRuleArray[n2];
            if ("file".equals(rule.getType()) && ((fileRule = (FilterRule.File)rule).isCaseSensitive() && fileRule.getPattern().equalsIgnoreCase(file) || !fileRule.isCaseSensitive() && fileRule.getPattern().equals(file))) {
                exists = true;
                break;
            }
            ++n2;
        }
        return exists;
    }
}

