/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.wtp;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.internal.OracleCommonToolsPlugin;
import oracle.eclipse.tools.common.util.ValidateEditUtil;
import oracle.eclipse.tools.common.util.jdt.JavaProjectUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.util.resources.IProjectFilter;
import oracle.eclipse.tools.common.util.wtp.J2EEProjectDependencyUtil;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.common.internal.modulecore.util.ArchiveManifest;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestDataModelProvider;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEBinaryComponentHelper;
import org.eclipse.jst.j2ee.project.facet.EARFacetUtils;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class WtpProjectUtil
extends JavaProjectUtil {
    public static final String WEB_INF_LIB_PATH_STR = "/WEB-INF/lib";
    public static final IPath WEB_INF_LIB_PATH = new Path("/WEB-INF/lib");

    public static boolean isDynamicWebProject(IProject project) {
        return WtpProjectUtil.hasProjectFacet(project, WebFacetUtils.WEB_FACET);
    }

    public static boolean isEarProject(IProject project) {
        return WtpProjectUtil.hasProjectFacet(project, EARFacetUtils.EAR_FACET);
    }

    public static boolean isUtilityProject(IProject project) {
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.utility");
        return WtpProjectUtil.hasProjectFacet(project, facet);
    }

    public static boolean isEJBProject(IProject project) {
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
        return WtpProjectUtil.hasProjectFacet(project, facet);
    }

    public static boolean hasProjectFacet(IProject project, IProjectFacet facet) {
        try {
            IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
            if (fproj != null) {
                return fproj.hasProjectFacet(facet);
            }
        }
        catch (CoreException e) {
            LoggingService.logException("oracle.eclipse.tools.common", e);
        }
        return false;
    }

    public static final List<IProject> findEarProjects() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = ws.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject proj = iProjectArray[n2];
            if (WtpProjectUtil.isEarProject(proj)) {
                result.add(proj);
            }
            ++n2;
        }
        return result;
    }

    public static final List<IProject> findDynamicWebProjects() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = ws.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject proj = iProjectArray[n2];
            if (WtpProjectUtil.isDynamicWebProject(proj)) {
                result.add(proj);
            }
            ++n2;
        }
        return result;
    }

    public static boolean isEjbModule(IProject ear, String jarName) {
        EARArtifactEdit earEdit = null;
        try {
            Module m;
            Application application;
            earEdit = EARArtifactEdit.getEARArtifactEditForRead((IProject)ear);
            if (earEdit != null && (application = earEdit.getApplication()) != null && (m = application.getFirstModule(jarName)) != null && m.isEjbModule()) {
                return true;
            }
        }
        finally {
            if (earEdit != null) {
                earEdit.dispose();
            }
        }
        return false;
    }

    public static boolean isEjbComponent(IVirtualComponent aBinaryComponent) {
        JavaEEBinaryComponentHelper helper = null;
        try {
            helper = new JavaEEBinaryComponentHelper(aBinaryComponent);
            IArchive archive = null;
            archive = helper.accessArchive();
            Path ddPath = new Path("META-INF/ejb-jar.xml");
            Path weblogicDdPath = new Path("META-INF/weblogic-ejb-jar.xml");
            if (archive.containsArchiveResource((IPath)ddPath) || archive.containsArchiveResource((IPath)weblogicDdPath)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public static IProjectFilter createEarProjectFilter() {
        IProjectFilter filter = new IProjectFilter(){

            @Override
            public boolean check(IProject project) {
                return WtpProjectUtil.isEarProject(project);
            }
        };
        return filter;
    }

    public static IProjectFilter createDynamicWebProjectFilter() {
        IProjectFilter filter = new IProjectFilter(){

            @Override
            public boolean check(IProject project) {
                return WtpProjectUtil.isDynamicWebProject(project);
            }
        };
        return filter;
    }

    public static final Set<IProject> findReferencingEarProjects(IProject project) {
        HashSet<IProject> referencing = new HashSet<IProject>();
        for (IProject ear : WtpProjectUtil.findEarProjects()) {
            if (!WtpProjectUtil.findProjectsReferencedByEar(ear).contains(project)) continue;
            referencing.add(ear);
        }
        return Collections.unmodifiableSet(referencing);
    }

    public static final IProject findReferencingEarProject(IProject project) {
        for (IProject ear : WtpProjectUtil.findEarProjects()) {
            if (!WtpProjectUtil.findProjectsReferencedByEar(ear).contains(project)) continue;
            return ear;
        }
        return null;
    }

    public static final Set<IProject> findProjectsReferencedByEar(IProject earProject) {
        HashSet<IProject> result = new HashSet<IProject>();
        for (IProject refpj : WtpProjectUtil.findReferencedProjects(earProject)) {
            result.add(refpj);
            if (!WtpProjectUtil.isDynamicWebProject(refpj)) continue;
            result.addAll(WtpProjectUtil.findReferencedProjects(refpj));
        }
        return Collections.unmodifiableSet(result);
    }

    public static final Set<IProject> findProjectsReferencedByWebApp(IProject webProject) {
        return WtpProjectUtil.findReferencedProjects(webProject);
    }

    public static final Set<IProject> findProjectsReferencedByWebApp(IProject webProject, final boolean includeExternalRefs, final boolean includeWebInfLibRefs) {
        ValidProjectReferenceFilter filter = new ValidProjectReferenceFilter(){

            @Override
            public boolean check(IVirtualReference ref) {
                boolean res = super.check(ref);
                if (res) {
                    boolean isWebInfLibRef = WtpProjectUtil.isWebInfLibReference(ref);
                    res = includeExternalRefs && !isWebInfLibRef || includeWebInfLibRefs && isWebInfLibRef;
                }
                return res;
            }
        };
        return WtpProjectUtil.findReferencedProjects(webProject, filter);
    }

    public static final Set<IProject> findReferencedProjects(IProject project) {
        return WtpProjectUtil.findReferencedProjects(project, new ValidProjectReferenceFilter(null, null));
    }

    private static final Set<IProject> findReferencedProjects(IProject project, IVirtualReferenceFilter filter) {
        HashSet<IProject> result = new HashSet<IProject>();
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            IVirtualReference[] iVirtualReferenceArray = component.getReferences();
            int n = iVirtualReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVirtualReference ref = iVirtualReferenceArray[n2];
                if (filter.check(ref)) {
                    result.add(ref.getReferencedComponent().getProject());
                }
                ++n2;
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public static void addProjectToEar(IProject earProject, IProject moduleProject) throws CoreException {
        try {
            J2EEProjectDependencyUtil.addEARDependency(earProject, moduleProject, null);
        }
        catch (ExecutionException e) {
            throw new CoreException(OracleCommonToolsPlugin.createErrorStatus(e));
        }
    }

    public static void removeProjectFromEar(IProject earProject, IProject moduleProject) throws CoreException {
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earProject);
        ArrayList<IVirtualReference> newRefs = new ArrayList<IVirtualReference>();
        IVirtualReference[] iVirtualReferenceArray = earComp.getReferences();
        int n = iVirtualReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualComponent refTarget;
            IVirtualReference ref = iVirtualReferenceArray[n2];
            boolean skip = false;
            if (ref != null && !(refTarget = ref.getReferencedComponent()).isBinary() && refTarget.getProject().equals((Object)moduleProject)) {
                skip = true;
            }
            if (!skip) {
                newRefs.add(ref);
            }
            ++n2;
        }
        earComp.setReferences(newRefs.toArray(new IVirtualReference[newRefs.size()]));
    }

    public static void addArchiveToEar(IProject earProject, IPath archiveLocation) throws CoreException {
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earProject);
        ArrayList<IVirtualReference> newRefs = new ArrayList<IVirtualReference>();
        File archiveLocationFile = archiveLocation.toFile();
        IVirtualReference[] iVirtualReferenceArray = earComp.getReferences();
        int n = iVirtualReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            File location;
            IVirtualComponent refTarget;
            IVirtualReference ref = iVirtualReferenceArray[n2];
            if (ref != null && (refTarget = ref.getReferencedComponent()).isBinary() && archiveLocationFile.equals(location = ((VirtualArchiveComponent)refTarget).getUnderlyingDiskFile())) {
                return;
            }
            newRefs.add(ref);
            ++n2;
        }
        IVirtualComponent archiveComponent = ComponentCore.createArchiveComponent((IProject)earProject, (String)("lib/" + archiveLocation.toString()));
        newRefs.add(ComponentCore.createReference((IVirtualComponent)earComp, (IVirtualComponent)archiveComponent));
        earComp.setReferences(newRefs.toArray(new IVirtualReference[newRefs.size()]));
    }

    public static void removeArchiveFromEar(IProject earProject, IPath archiveLocation) throws CoreException {
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earProject);
        ArrayList<IVirtualReference> newRefs = new ArrayList<IVirtualReference>();
        File archiveLocationFile = archiveLocation.toFile();
        IVirtualReference[] iVirtualReferenceArray = earComp.getReferences();
        int n = iVirtualReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            File location;
            IVirtualComponent refTarget;
            IVirtualReference ref = iVirtualReferenceArray[n2];
            boolean skip = false;
            if (ref != null && (refTarget = ref.getReferencedComponent()).isBinary() && archiveLocationFile.equals(location = ((VirtualArchiveComponent)refTarget).getUnderlyingDiskFile())) {
                skip = true;
            }
            if (!skip) {
                newRefs.add(ref);
            }
            ++n2;
        }
        earComp.setReferences(newRefs.toArray(new IVirtualReference[newRefs.size()]));
    }

    public static void addProjectToWebApp(IProject webProject, IProject utilProject) throws CoreException {
        IVirtualComponent webComponent = ComponentCore.createComponent((IProject)webProject);
        IVirtualComponent utilComponent = ComponentCore.createComponent((IProject)utilProject);
        IDataModel refdm = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
        List targetCompList = (List)refdm.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        targetCompList.add(utilComponent);
        refdm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)webComponent);
        refdm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)targetCompList);
        refdm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)WEB_INF_LIB_PATH_STR);
        try {
            refdm.getDefaultOperation().execute(null, null);
        }
        catch (ExecutionException e) {
            throw new CoreException(OracleCommonToolsPlugin.createErrorStatus(e));
        }
    }

    public static void addManifestDependency(IProject source, IProject target, IProgressMonitor monitor) throws ExecutionException {
        WtpProjectUtil.addManifestDependency(source, String.valueOf(target.getName()) + ".jar", monitor);
    }

    public static void addManifestDependency(IProject source, String libraryName, IProgressMonitor monitor) throws ExecutionException {
        WtpProjectUtil.updateManifestDependency(source, libraryName, false, monitor);
    }

    public static void removeManifestDependency(IProject source, IProject target, IProgressMonitor monitor) throws ExecutionException {
        WtpProjectUtil.removeManifestDependency(source, String.valueOf(target.getName()) + ".jar", monitor);
    }

    public static void removeManifestDependency(IProject source, String libraryName, IProgressMonitor monitor) throws ExecutionException {
        WtpProjectUtil.updateManifestDependency(source, libraryName, true, monitor);
    }

    private static void updateManifestDependency(IProject dependentProject, String libraryName, boolean removeDependency, IProgressMonitor monitor) throws ExecutionException {
        IVirtualComponent sourceComp = ComponentCore.createComponent((IProject)dependentProject);
        IVirtualFile vf = sourceComp.getRootFolder().getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        IFile manifestmf = null;
        IFile[] files = vf.getUnderlyingFiles();
        if (files.length == 1) {
            manifestmf = files[0];
        } else {
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile f = iFileArray[n2];
                if (f.exists()) {
                    manifestmf = f;
                    break;
                }
                ++n2;
            }
        }
        if (manifestmf == null) {
            throw new ExecutionException("error-reading-manifest");
        }
        IStatus status = ValidateEditUtil.validateEdit(manifestmf);
        if (!status.isOK()) {
            throw new ExecutionException(status.getMessage());
        }
        IDataModel updateManifestDataModel = DataModelFactory.createDataModel((IDataModelProvider)new UpdateManifestDataModelProvider());
        updateManifestDataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)dependentProject.getName());
        updateManifestDataModel.setBooleanProperty("UpdateManifestDataModel.MERGE", false);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.MANIFEST_FILE", (Object)manifestmf);
        ArchiveManifest manifest = J2EEProjectDependencyUtil.getArchiveManifest(manifestmf);
        String[] cp = manifest.getClassPathTokenized();
        ArrayList<String> cpList = new ArrayList<String>();
        int i = 0;
        while (i < cp.length) {
            if (!cp[i].equals(libraryName)) {
                cpList.add(cp[i]);
            }
            ++i;
        }
        if (!removeDependency) {
            cpList.add(libraryName);
        }
        updateManifestDataModel.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", cpList);
        updateManifestDataModel.getDefaultOperation().execute(monitor, null);
    }

    public static boolean isWebInfLibReference(IVirtualReference ref) {
        return ref.getRuntimePath().equals((Object)WEB_INF_LIB_PATH);
    }

    private static interface IVirtualReferenceFilter {
        public boolean check(IVirtualReference var1);
    }

    private static class ValidProjectReferenceFilter
    implements IVirtualReferenceFilter {
        private ValidProjectReferenceFilter() {
        }

        @Override
        public boolean check(IVirtualReference ref) {
            IVirtualComponent comp = ref.getReferencedComponent();
            return comp != null && comp.getProject() != null;
        }

        /* synthetic */ ValidProjectReferenceFilter(ValidProjectReferenceFilter validProjectReferenceFilter, ValidProjectReferenceFilter validProjectReferenceFilter2) {
            this();
        }
    }
}

