/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.wtp;

import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.eclipse.tools.common.util.DomUtil;
import oracle.eclipse.tools.common.util.EclipseDomUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.w3c.dom.Element;

public final class ServerCorePrefs {
    private static final String SERVER_CORE_PREF = "org.eclipse.wst.server.core";
    private static final String SERVER_CORE_PREF_RUNTIMES = "runtimes";
    private static final String EL_RUNTIME = "runtime";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_RUNTIME_TYPE_ID = "runtime-type-id";
    private static final String ATTR_TIMESTAMP = "timestamp";
    private final String runtimeString;
    private static ServerCorePrefs instance;
    private final Set<Runtime> runtimes = new LinkedHashSet<Runtime>();
    private final Set<Runtime> runtimesReadOnly = Collections.unmodifiableSet(this.runtimes);

    private ServerCorePrefs() {
        IEclipsePreferences preference = new InstanceScope().getNode(SERVER_CORE_PREF);
        this.runtimeString = preference.get(SERVER_CORE_PREF_RUNTIMES, null);
    }

    public static synchronized ServerCorePrefs getInstance() {
        if (instance == null) {
            instance = new ServerCorePrefs();
        }
        return instance;
    }

    public Set<Runtime> getRuntimes() throws CoreException {
        if (this.runtimes.isEmpty()) {
            this.parse();
        }
        return this.runtimesReadOnly;
    }

    private void parse() throws CoreException {
        StringReader reader = new StringReader(this.runtimeString);
        for (Element e : DomUtil.elements(EclipseDomUtil.root(reader))) {
            String nodeName = e.getNodeName();
            if (!nodeName.equals(EL_RUNTIME)) continue;
            String id = e.getAttribute(ATTR_ID);
            String name = e.getAttribute(ATTR_NAME);
            String runtimeTypeId = e.getAttribute(ATTR_RUNTIME_TYPE_ID);
            String timeStamp = e.getAttribute(ATTR_TIMESTAMP);
            Runtime runtime = new Runtime(id, name, runtimeTypeId, timeStamp);
            this.runtimes.add(runtime);
        }
    }

    public static final class Runtime {
        private String name = null;
        private String id = null;
        private String runtimeTypeId = null;
        private String timestamp = null;

        public Runtime(String name, String id, String runtimeTypeId, String timestamp) {
            this.name = name;
            this.id = id;
            this.runtimeTypeId = runtimeTypeId;
            this.timestamp = timestamp;
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }

        public String getRuntimeTypeId() {
            return this.runtimeTypeId;
        }

        public String getTimestamp() {
            return this.timestamp;
        }
    }
}

