/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.wtp;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.eclipse.tools.common.util.DomUtil;
import oracle.eclipse.tools.common.util.EclipseDomUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Element;

public final class FacetedProjectMetadata {
    public static final String METADATA_FILE_PATH = ".settings/org.eclipse.wst.common.project.facet.core.xml";
    public static final String PREFS_FILE_PATH = ".settings/org.eclipse.jst.common.project.facet.core.prefs";
    private static final String EL_FIXED = "fixed";
    private static final String EL_INSTALLED = "installed";
    private static final String EL_RUNTIME = "runtime";
    private static final String EL_SECONDARY_RUNTIME = "secondary-runtime";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_FACET = "facet";
    private static final String ATTR_VERSION = "version";
    private final Set<FixedFacet> fixed = new LinkedHashSet<FixedFacet>();
    private final Set<FixedFacet> fixedReadOnly = Collections.unmodifiableSet(this.fixed);
    private final Set<InstalledFacet> installed = new LinkedHashSet<InstalledFacet>();
    private final Set<InstalledFacet> installedReadOnly = Collections.unmodifiableSet(this.installed);
    private Runtime primaryRuntime = null;
    private final Set<Runtime> secondaryRuntimes = new LinkedHashSet<Runtime>();
    private final Set<Runtime> secondaryRuntimesReadOnly = Collections.unmodifiableSet(this.secondaryRuntimes);

    public FacetedProjectMetadata() {
    }

    public FacetedProjectMetadata(IProject project) throws CoreException {
        this.load(project);
    }

    public Set<FixedFacet> getFixedFacets() {
        return this.fixedReadOnly;
    }

    public void addFixedFacet(FixedFacet fixedFacet) {
        this.fixed.add(fixedFacet);
    }

    public void removeFixedFacet(FixedFacet fixedFacet) {
        this.fixed.remove(fixedFacet);
    }

    public Set<InstalledFacet> getInstalledFacets() {
        return this.installedReadOnly;
    }

    public void addInstalledFacet(InstalledFacet installedFacet) {
        this.installed.add(installedFacet);
    }

    public void removeInstalledFacet(InstalledFacet installedFacet) {
        this.installed.remove(installedFacet);
    }

    public Runtime getPrimaryRuntime() {
        return this.primaryRuntime;
    }

    public void setPrimaryRuntime(Runtime runtime) {
        this.primaryRuntime = runtime;
    }

    public Set<Runtime> getSecondaryRuntimes() {
        return this.secondaryRuntimesReadOnly;
    }

    public void addSecondaryRuntime(Runtime runtime) {
        this.secondaryRuntimes.add(runtime);
    }

    public void removeSecondaryRuntime(Runtime runtime) {
        this.secondaryRuntimes.remove(runtime);
    }

    public void load(IProject project) throws CoreException {
        this.fixed.clear();
        this.installed.clear();
        this.primaryRuntime = null;
        this.secondaryRuntimes.clear();
        if (!project.isAccessible()) {
            return;
        }
        IFile mdfile = FacetedProjectMetadata.getMetadataFile(project);
        mdfile.refreshLocal(0, null);
        if (mdfile.isAccessible()) {
            for (Element e : DomUtil.elements(EclipseDomUtil.root(mdfile))) {
                String name = e.getNodeName();
                if (name.equals(EL_FIXED)) {
                    FixedFacet ffacet = new FixedFacet();
                    ffacet.setFacetId(e.getAttribute(ATTR_FACET));
                    this.fixed.add(ffacet);
                    continue;
                }
                if (name.equals(EL_INSTALLED)) {
                    InstalledFacet ifacet = new InstalledFacet();
                    ifacet.setFacetId(e.getAttribute(ATTR_FACET));
                    ifacet.setVersion(e.getAttribute(ATTR_VERSION));
                    this.installed.add(ifacet);
                    continue;
                }
                if (name.equals(EL_RUNTIME)) {
                    this.primaryRuntime = new Runtime();
                    this.primaryRuntime.setName(e.getAttribute(ATTR_NAME));
                    continue;
                }
                if (!name.equals(EL_SECONDARY_RUNTIME)) continue;
                Runtime r = new Runtime();
                r.setName(e.getAttribute(ATTR_NAME));
                this.secondaryRuntimes.add(r);
            }
        }
    }

    public void save(IProject project) throws CoreException {
        IFile mdfile = FacetedProjectMetadata.getMetadataFile(project);
        StringWriter w = new StringWriter();
        PrintWriter out = new PrintWriter(w);
        String nl = System.getProperty("line.separator");
        out.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.print(nl);
        out.print("<faceted-project>");
        out.print(nl);
        if (this.primaryRuntime != null) {
            out.print("  <runtime name=\"");
            out.print(this.primaryRuntime.getName());
            out.print("\"/>");
            out.print(nl);
        }
        for (Runtime r : this.secondaryRuntimes) {
            out.print("  <secondary-runtime name=\"");
            out.print(r.getName());
            out.print("\"/>");
            out.print(nl);
        }
        for (FixedFacet ffacet : this.fixed) {
            out.print("  <fixed facet=\"");
            out.print(ffacet.getFacetId());
            out.print("\"/>");
            out.print(nl);
        }
        for (InstalledFacet ifacet : this.installed) {
            out.print("  <installed facet=\"");
            out.print(ifacet.getFacetId());
            out.print("\" version=\"");
            out.print(ifacet.getVersion());
            out.print("\"/>");
            out.print(nl);
        }
        out.print("</faceted-project>");
        out.print(nl);
        byte[] bytes = w.getBuffer().toString().getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        if (mdfile.exists()) {
            mdfile.setContents((InputStream)in, true, false, null);
        } else {
            IFolder parent = (IFolder)mdfile.getParent();
            if (!parent.exists()) {
                parent.create(true, true, null);
            }
            mdfile.create((InputStream)in, true, null);
        }
    }

    public static final boolean isFacetedProject(IProject project) {
        return FacetedProjectMetadata.getMetadataFile(project).exists();
    }

    private static final IFile getMetadataFile(IProject project) {
        return project.getFile(METADATA_FILE_PATH);
    }

    public static final class FixedFacet {
        private String fid = null;

        public String getFacetId() {
            return this.fid;
        }

        public void setFacetId(String fid) {
            this.fid = fid;
        }
    }

    public static final class InstalledFacet {
        private String fid = null;
        private String version = null;

        public String getFacetId() {
            return this.fid;
        }

        public void setFacetId(String fid) {
            this.fid = fid;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }

    public static final class Runtime {
        private String name = null;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

