/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.system;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.stream.StreamCaptureService;
import oracle.eclipse.tools.common.util.stream.StringBufferListener;
import oracle.eclipse.tools.common.util.system.RuntimeResponse;
import oracle.eclipse.tools.common.util.system.ServiceRunnable;
import oracle.eclipse.tools.common.util.system.WaitForProcessService;

public final class RuntimeResponseImpl
implements RuntimeResponse {
    private final Process process;
    private final String name;
    private final boolean redirectErrorStream;
    private final StreamCaptureService stdoutSvc;
    private final StreamCaptureService stderrSvc;
    private final StringBufferListener stdoutListener;
    private final StringBufferListener stderrListener;
    private final WaitForProcessService processSvc;

    public RuntimeResponseImpl(Process process, String name, boolean redirectErrorStream) {
        this.process = process;
        this.name = name;
        this.redirectErrorStream = redirectErrorStream;
        this.stdoutListener = new StringBufferListener();
        this.stderrListener = new StringBufferListener();
        this.stdoutSvc = new StreamCaptureService("stdout", process.getInputStream(), this.stdoutListener);
        this.stderrSvc = new StreamCaptureService("stderr", process.getErrorStream(), this.stderrListener);
        this.processSvc = new WaitForProcessService(this.process);
        Thread thread = new Thread((Runnable)this.stdoutSvc, "process-" + name + "-stdoutStreamCapture");
        thread.start();
        thread = new Thread((Runnable)this.stderrSvc, "process-" + name + "-stderrStreamCapture");
        thread.start();
        thread = new Thread((Runnable)this.processSvc, "process-" + name + "-processService");
        thread.start();
        this.processSvc.waitTillStarted(20L);
        this.stdoutSvc.waitTillStarted(20L);
        this.stderrSvc.waitTillStarted(20L);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void join() throws InterruptedException {
        this.join(0L);
    }

    @Override
    public void join(long millis) throws InterruptedException {
        if (millis < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (this.isDone()) {
            return;
        }
        long start = System.currentTimeMillis();
        this.processSvc.join(millis);
        long waitMilli = RuntimeResponseImpl.timeLeft(start, millis);
        if (waitMilli < 0L) {
            return;
        }
        this.stderrSvc.join(waitMilli);
        waitMilli = RuntimeResponseImpl.timeLeft(start, millis);
        if (waitMilli < 0L) {
            return;
        }
        this.stdoutSvc.join(waitMilli);
    }

    @Override
    public void terminate() {
        this.processSvc.terminate();
    }

    @Override
    public boolean isTerminated() {
        return this.processSvc.isTerminated();
    }

    @Override
    public boolean isDone() {
        return this.processSvc.isDone() && this.stdoutSvc.isDone() && this.stderrSvc.isDone();
    }

    @Override
    public boolean isFailed() {
        return this.processSvc.isFailed() || this.stdoutSvc.isFailed() || this.stderrSvc.isFailed();
    }

    @Override
    public int getExitVal() {
        return this.processSvc.getExitVal();
    }

    @Override
    public boolean isRedirectErrorStream() {
        return this.redirectErrorStream;
    }

    @Override
    public String getStdout() {
        return this.stdoutListener.getOutput();
    }

    @Override
    public String getStderr() {
        return this.stderrListener.getOutput();
    }

    @Override
    public int getExceptionCount() {
        return this.processSvc.getExceptionCount() + this.stderrSvc.getExceptionCount() + this.stdoutSvc.getExceptionCount();
    }

    @Override
    public List<Throwable> getExceptions() {
        int count = this.getExceptionCount();
        if (count <= 0) {
            return null;
        }
        List<Throwable> exceptions = new ArrayList<Throwable>(count);
        exceptions = this.addInternal(exceptions, this.processSvc);
        exceptions = this.addInternal(exceptions, this.stderrSvc);
        exceptions = this.addInternal(exceptions, this.stdoutSvc);
        return exceptions;
    }

    private List<Throwable> addInternal(List<Throwable> list, ServiceRunnable runnable) {
        int i = 0;
        while (i < runnable.getExceptionCount()) {
            list.add(runnable.getException(i));
            ++i;
        }
        return list;
    }

    private static long timeLeft(long start, long duration) {
        if (duration == 0L) {
            return 0L;
        }
        if (duration < 0L) {
            return duration;
        }
        long elapsed = System.currentTimeMillis() - start;
        if (elapsed >= duration) {
            return -1L;
        }
        return duration - elapsed + 1L;
    }

    private String getOutput() {
        if (this.redirectErrorStream) {
            return this.getStdout();
        }
        return "stderr:\n" + this.getStderr() + "\n\nstdout:\n" + this.getStdout() + "\n";
    }

    public String toString() {
        return "isDone( " + this.isDone() + " ), is failed( " + this.isFailed() + " ), exitVal(" + this.getExitVal() + "), isRedirectErrorStream( " + this.isRedirectErrorStream() + " ), output( " + this.getOutput() + " ), exceptions( " + this.getExceptionCount() + " ), is terminated( " + this.isTerminated() + " )";
    }
}

