/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.sun;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;

public class ToolsJARLocator {
    private static File _toolsJARPath = null;
    public static final boolean IS_MACOSX = "macosx".equals(Platform.getOS());

    public static File findToolsJAR(File javaVMLocation) {
        File classesLocation;
        if (javaVMLocation == null || !javaVMLocation.exists()) {
            return null;
        }
        if (IS_MACOSX && (classesLocation = new File(javaVMLocation.getParentFile(), "Classes")).exists()) {
            File classesJAR = new File(classesLocation, "classes.jar");
            if (classesJAR.exists()) {
                return classesJAR.getAbsoluteFile();
            }
            return null;
        }
        File toolsJAR = new File(javaVMLocation, "lib/tools.jar");
        if (toolsJAR.exists()) {
            return toolsJAR.getAbsoluteFile();
        }
        return null;
    }

    public static synchronized File findToolsJAR(String execEnvId) {
        IExecutionEnvironment[] envs;
        if (execEnvId == null || execEnvId.length() == 0) {
            return null;
        }
        IExecutionEnvironment[] iExecutionEnvironmentArray = envs = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        int n = envs.length;
        int n2 = 0;
        while (n2 < n) {
            IExecutionEnvironment env = iExecutionEnvironmentArray[n2];
            if (env.getId().equals(execEnvId)) {
                IVMInstall[] vms;
                IVMInstall[] iVMInstallArray = vms = env.getCompatibleVMs();
                int n3 = vms.length;
                int n4 = 0;
                while (n4 < n3) {
                    File toolsJAR;
                    IVMInstall vm = iVMInstallArray[n4];
                    if (env.isStrictlyCompatible(vm) && (toolsJAR = ToolsJARLocator.findToolsJAR(vm.getInstallLocation())) != null) {
                        return toolsJAR;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    public static synchronized File findToolsJAR() {
        IVMInstallType[] vmInstallTypes;
        if (_toolsJARPath != null) {
            return _toolsJARPath;
        }
        File toolsJAR = null;
        String javaHome = System.getProperty("java.home", null);
        File javaHomeFile = new File(javaHome);
        File javaHomeParent = javaHomeFile.getParentFile();
        if (javaHomeParent != null && (toolsJAR = ToolsJARLocator.findToolsJAR(javaHomeParent)) != null) {
            _toolsJARPath = toolsJAR;
            return toolsJAR;
        }
        IVMInstallType[] iVMInstallTypeArray = vmInstallTypes = JavaRuntime.getVMInstallTypes();
        int n = vmInstallTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstall[] vmInstalls;
            IVMInstallType type = iVMInstallTypeArray[n2];
            IVMInstall[] iVMInstallArray = vmInstalls = type.getVMInstalls();
            int n3 = vmInstalls.length;
            int n4 = 0;
            while (n4 < n3) {
                IVMInstall install = iVMInstallArray[n4];
                toolsJAR = ToolsJARLocator.findToolsJAR(install.getInstallLocation());
                if (toolsJAR != null) {
                    _toolsJARPath = toolsJAR;
                    return toolsJAR;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }
}

