/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.performance;

import java.text.NumberFormat;

public class BasicAccumulator {
    public static final String EMPTY_STRING = "";
    protected String name;
    protected String description;
    protected String units;
    protected long opCount;
    protected double total = 0.0;

    public BasicAccumulator() {
        this(null);
    }

    public BasicAccumulator(String name) {
        this(name, null);
    }

    public BasicAccumulator(String name, String description) {
        this.name = name;
        this.description = description;
        if (this.name == null) {
            this.name = EMPTY_STRING;
        }
        if (this.description == null) {
            this.description = EMPTY_STRING;
        }
    }

    public double avg() {
        if (this.opCount == 0L) {
            return this.total;
        }
        return this.total / (double)this.opCount;
    }

    public String getAvgString(NumberFormat format) {
        if (format == null) {
            return Double.toString(this.avg());
        }
        return format.format(this.avg());
    }

    public void setOpCount(long opCount) {
        this.opCount = opCount;
    }

    public long getOpCount() {
        return this.opCount;
    }

    public String getOpCountString(NumberFormat format) {
        if (format == null) {
            return Long.toString(this.opCount);
        }
        return format.format(this.opCount);
    }

    public void setTotal(double total) {
        this.total = total;
    }

    public double getTotal() {
        return this.total;
    }

    public String getTotalString(NumberFormat format) {
        if (format == null) {
            return Double.toString(this.total);
        }
        return format.format(this.total);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUnits() {
        if (this.units == null) {
            return EMPTY_STRING;
        }
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(NumberFormat format) {
        StringBuffer sb = new StringBuffer(256);
        sb.append("[ ");
        sb.append("name( " + this.name + " )");
        sb.append(", opCount( " + this.opCount + " )");
        sb.append(", total( " + this.getTotalString(format) + " " + this.getUnits() + " )");
        sb.append(", avg( " + this.getAvgString(format) + " " + this.getUnits() + " )");
        sb.append(", description( " + this.description + " )");
        sb.append(" ]");
        return sb.toString();
    }
}

