/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.performance;

import oracle.eclipse.tools.common.util.performance.Constants;
import oracle.eclipse.tools.common.util.performance.Timer;

public abstract class AbstractTimer
implements Timer,
Constants {
    private int state;
    private double start;
    private double duration;
    private static final String[] STATE_NAMES = new String[]{"BEGIN", "STARTED", "STOPPED"};

    @Override
    public void start() {
        if (this.state != 0) {
            throw new IllegalStateException("reset timer before starting, timer( " + this + " )");
        }
        this.state = 1;
        this.start = this.time();
        this.duration = 0.0;
    }

    @Override
    public double stop() {
        double endTime = this.time();
        if (this.state != 2 && this.state != 1) {
            throw new IllegalStateException("timer must be started before stopping, timer( " + this + " )");
        }
        this.duration = endTime - this.start;
        this.state = 2;
        return this.duration;
    }

    @Override
    public double getDuration() {
        if (this.state != 2) {
            throw new IllegalStateException("stop the timer before getting the duration, timer( " + this + " )");
        }
        return this.duration;
    }

    @Override
    public void reset() {
        this.state = 0;
        this.start = -1.0;
        this.duration = -1.0;
    }

    protected String getCurrentState() {
        return STATE_NAMES[this.state];
    }

    public abstract double time();

    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        sb.append("[ ");
        sb.append("state( " + this.getCurrentState() + " )");
        sb.append(", start( " + this.start + " )");
        sb.append(", duration( " + this.duration + " )");
        sb.append(" ]");
        return sb.toString();
    }
}

