/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.logging;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.eclipse.tools.common.internal.OracleCommonToolsPlugin;
import oracle.eclipse.tools.common.util.ResourceLoader;
import oracle.eclipse.tools.common.util.logging.IWlwStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class LoggingService {
    private static ResourceLoader _resourceLoader = new ResourceLoader(LoggingService.class);
    private static final String OPTION_DEBUG = "/debug";
    private static final String OPTION_DEBUG_CONSOLE = "/debug/console";
    private static final String OPTION_GLOBAL_DEBUG = "/oepe/debug";
    private static final String OPTION_GLOBAL_INFER_CALLER = "/oepe/inferCaller";
    private static Boolean _globalDebugOption = null;
    private static Boolean _globalInferCallerOption = null;
    private static final String OPTION_GLOBAL_DEBUG_CONSOLE = "/oepe/debug/console";
    private static final String OPTION_GLOBAL_DEBUG_FILTER = "/oepe/debug/filter";
    private static final String OPTION_GLOBAL_ERROR_CONSOLE = "/oepe/error/console";
    private static final String OPTION_GLOBAL_FATAL_CONSOLE = "/oepe/fatal/console";
    private static final String OPTION_GLOBAL_INFO_CONSOLE = "/oepe/info/console";
    private static final String OPTION_GLOBAL_WARNING_CONSOLE = "/oepe/warning/console";
    private static ILog _logInstance = null;
    private static String _loggingBundleName = null;
    private static SimpleDateFormat _formatter = null;
    private static String STACK_TRACE_ROOT_CLASS = LoggingService.class.getName();
    private static WeakHashMap<Plugin, String> _pluginIDs = new WeakHashMap();
    private static HashMap<String, Boolean> _options = new HashMap();
    private static List<Pattern> _globalFilterOption;
    private static Map<String, Boolean> _filteredPlugins;

    static {
        _filteredPlugins = new HashMap<String, Boolean>();
    }

    public static void addLogListener(ILogListener listener) {
        Platform.addLogListener((ILogListener)listener);
    }

    private static synchronized boolean getGlobalDebugOption() {
        if (_globalDebugOption == null) {
            _globalDebugOption = LoggingService.isOptionEnabled(LoggingService.getLoggingBundleName(), OPTION_GLOBAL_DEBUG);
        }
        return _globalDebugOption;
    }

    private static synchronized List<Pattern> getGlobalDebugFilterOption() {
        if (_globalFilterOption == null) {
            _globalFilterOption = new ArrayList<Pattern>();
            String value = LoggingService.getOptionValue(LoggingService.getLoggingBundleName(), OPTION_GLOBAL_DEBUG_FILTER);
            if (value != null) {
                String[] filters;
                String[] stringArray = filters = value.split(",");
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    String next = stringArray[n2];
                    String trimmed = next.trim();
                    if (trimmed.length() > 0) {
                        _globalFilterOption.add(Pattern.compile(trimmed));
                    }
                    ++n2;
                }
            }
        }
        return _globalFilterOption;
    }

    private static synchronized boolean getGlobalInferCallerOption() {
        if (_globalInferCallerOption == null) {
            _globalInferCallerOption = LoggingService.isOptionEnabled(LoggingService.getLoggingBundleName(), OPTION_GLOBAL_INFER_CALLER);
        }
        return _globalInferCallerOption;
    }

    private static synchronized ILog getLogInstance() {
        if (_logInstance == null) {
            _logInstance = Platform.getLog((Bundle)OracleCommonToolsPlugin.getBundle());
        }
        return _logInstance;
    }

    private static synchronized String getLoggingBundleName() {
        if (_loggingBundleName == null) {
            _loggingBundleName = OracleCommonToolsPlugin.getBundle().getSymbolicName();
        }
        return _loggingBundleName;
    }

    private static String getOptionValue(String pluginID, String option) {
        if (pluginID == null || option == null) {
            return null;
        }
        String fullyQualifiedOption = String.valueOf(pluginID) + option;
        return Platform.getDebugOption((String)fullyQualifiedOption);
    }

    private static synchronized String getPluginID(Plugin plugin) {
        String pluginID = _pluginIDs.get(plugin);
        if (pluginID == null) {
            if (plugin != null) {
                Bundle sourceBundle = plugin.getBundle();
                if (sourceBundle != null) {
                    pluginID = sourceBundle.getSymbolicName();
                    assert (pluginID != null) : "Plugin ID was not found.";
                    _pluginIDs.put(plugin, pluginID);
                } else {
                    pluginID = plugin.getClass().getName();
                }
            } else {
                StackTraceElement[] stack = new Throwable().getStackTrace();
                pluginID = stack[1].getClassName();
            }
        }
        assert (pluginID != null) : "Plugin ID was null.";
        return pluginID;
    }

    private static String inferCaller(String callerID) {
        String cname;
        StackTraceElement frame;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        int ix = 0;
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (cname.equals(STACK_TRACE_ROOT_CLASS)) break;
            ++ix;
        }
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!cname.equals(STACK_TRACE_ROOT_CLASS)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("[ ");
                buffer.append(cname);
                buffer.append(".");
                buffer.append(frame.getMethodName());
                buffer.append("(");
                buffer.append(frame.getFileName());
                buffer.append(":");
                buffer.append(frame.getLineNumber());
                buffer.append(") ] ==> ");
                return buffer.toString();
            }
            ++ix;
        }
        return "[ ??" + callerID + "?? ] ==>";
    }

    public static boolean isOptionEnabled(Plugin plugin, String option) {
        String pluginID = LoggingService.getPluginID(plugin);
        return LoggingService.isOptionEnabled(pluginID, option);
    }

    private static synchronized boolean isOptionEnabled(String pluginID, String option) {
        if (pluginID == null || option == null) {
            return false;
        }
        String fullyQualifiedOption = String.valueOf(pluginID) + option;
        Boolean optionValue = _options.get(fullyQualifiedOption);
        if (optionValue == null) {
            String value = LoggingService.getOptionValue(pluginID, option);
            optionValue = value != null && value.equalsIgnoreCase("true");
            _options.put(fullyQualifiedOption, optionValue);
        }
        return optionValue;
    }

    private static synchronized boolean isPluginDebugFiltered(String pluginID) {
        Boolean filterCheck = _filteredPlugins.get(pluginID);
        if (filterCheck == null) {
            List<Pattern> filters = LoggingService.getGlobalDebugFilterOption();
            filterCheck = false;
            for (Pattern filter : filters) {
                Matcher matcher = filter.matcher(pluginID);
                filterCheck = matcher.matches();
                if (filterCheck.booleanValue()) break;
            }
            _filteredPlugins.put(pluginID, filterCheck);
        }
        return filterCheck;
    }

    private static void log(String pluginId, String message, int level, Throwable throwable, String localConsoleCode, String globalConsoleCode, IStatus child) {
        LoggingService.log(pluginId, message, level, throwable, localConsoleCode, globalConsoleCode, child, false);
    }

    private static void log(String pluginId, String message, int level, Throwable throwable, String localConsoleCode, String globalConsoleCode, IStatus child, boolean fatal) {
        boolean toConsole = LoggingService.isOptionEnabled(LoggingService.getLoggingBundleName(), globalConsoleCode) || LoggingService.isOptionEnabled(pluginId, localConsoleCode);
        ILog logInstance = LoggingService.getLogInstance();
        if (LoggingService.getGlobalInferCallerOption()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(LoggingService.inferCaller(pluginId));
            buffer.append(message);
            message = buffer.toString();
        }
        IWlwStatus status = null;
        status = child != null ? new MultiSeverityStatus(pluginId, level, level, new IStatus[]{child}, message != null ? message : "", throwable, fatal) : new WlwStatus(level, pluginId, level, message != null ? message : "", throwable, fatal);
        logInstance.log((IStatus)status);
        if (toConsole) {
            LoggingService.streamStatus(status);
        }
    }

    public static void logDebug(Plugin callingPlugin, String message) {
        LoggingService.logDebug(LoggingService.getPluginID(callingPlugin), message);
    }

    public static void logDebug(String callingPluginId, String message) {
        LoggingService.logDebug(callingPluginId, OPTION_DEBUG, message);
    }

    public static void logDebug(Plugin callingPlugin, String option, String message) {
        LoggingService.logDebug(LoggingService.getPluginID(callingPlugin), option, message, false);
    }

    public static void logDebug(Plugin callingPlugin, String option, String message, boolean explicitOption) {
        LoggingService.logDebug(LoggingService.getPluginID(callingPlugin), option, message, explicitOption);
    }

    public static void logDebug(String callingPluginId, String option, String message) {
        LoggingService.logDebug(callingPluginId, option, message, false);
    }

    public static void logDebug(String callingPluginId, String option, String message, boolean explicitOption) {
        if (!LoggingService.isPluginDebugFiltered(callingPluginId) && (!explicitOption && LoggingService.getGlobalDebugOption() || LoggingService.isOptionEnabled(callingPluginId, option))) {
            LoggingService.log(callingPluginId, message, 1, null, OPTION_DEBUG_CONSOLE, OPTION_GLOBAL_DEBUG_CONSOLE, null);
        }
    }

    public static void logError(Plugin callingPlugin, String message) {
        LoggingService.logError(LoggingService.getPluginID(callingPlugin), message);
    }

    public static void logError(String callingPluginId, String message) {
        LoggingService.log(callingPluginId, message, 4, null, null, OPTION_GLOBAL_ERROR_CONSOLE, null);
    }

    public static void logFatal(Plugin callingPlugin, String message) {
        LoggingService.logFatal(LoggingService.getPluginID(callingPlugin), message);
    }

    public static void logFatal(String callingPluginId, String message) {
        LoggingService.log(callingPluginId, message, 4, new Exception(_resourceLoader.resource("message.fatal.exception", message)), null, OPTION_GLOBAL_FATAL_CONSOLE, null, true);
    }

    public static void logFatal(Plugin callingPlugin, Throwable throwable) {
        LoggingService.logFatal(LoggingService.getPluginID(callingPlugin), throwable);
    }

    public static void logFatal(String callingPluginId, Throwable throwable) {
        LoggingService.log(callingPluginId, throwable.getLocalizedMessage(), 4, throwable, null, OPTION_GLOBAL_ERROR_CONSOLE, null, true);
    }

    public static void logFatal(Plugin callingPlugin, CoreException coreException) {
        LoggingService.logFatal(LoggingService.getPluginID(callingPlugin), coreException);
    }

    public static void logFatal(String callingPluginId, CoreException coreException) {
        IStatus status = coreException.getStatus();
        LoggingService.log(callingPluginId, status.getMessage(), 4, coreException, null, OPTION_GLOBAL_ERROR_CONSOLE, coreException.getStatus(), true);
    }

    public static void logFatal(Plugin callingPlugin, Throwable throwable, String message) {
        LoggingService.logFatal(LoggingService.getPluginID(callingPlugin), throwable, message);
    }

    public static void logFatal(String callingPluginId, Throwable throwable, String message) {
        LoggingService.log(callingPluginId, message, 4, throwable, null, OPTION_GLOBAL_ERROR_CONSOLE, null, true);
    }

    public static void logInfo(Plugin callingPlugin, String message) {
        LoggingService.logInfo(LoggingService.getPluginID(callingPlugin), message);
    }

    public static void logInfo(String callingPluginId, String message) {
        LoggingService.log(callingPluginId, message, 1, null, null, OPTION_GLOBAL_INFO_CONSOLE, null);
    }

    public static void logException(Plugin callingPlugin, Throwable throwable) {
        LoggingService.logException(LoggingService.getPluginID(callingPlugin), throwable);
    }

    public static void logException(String callingPluginId, Throwable throwable) {
        LoggingService.log(callingPluginId, throwable.getLocalizedMessage(), 4, throwable, null, OPTION_GLOBAL_ERROR_CONSOLE, null);
    }

    public static void logException(Plugin callingPlugin, CoreException coreException) {
        LoggingService.logException(LoggingService.getPluginID(callingPlugin), coreException);
    }

    public static void logException(String callingPluginId, CoreException coreException) {
        IStatus status = coreException.getStatus();
        LoggingService.log(callingPluginId, status.getMessage(), 4, coreException, null, OPTION_GLOBAL_ERROR_CONSOLE, coreException.getStatus());
    }

    public static void logException(Plugin callingPlugin, Throwable throwable, String message) {
        LoggingService.logException(LoggingService.getPluginID(callingPlugin), throwable, message);
    }

    public static void logException(String callingPluginId, Throwable throwable, String message) {
        LoggingService.log(callingPluginId, message, 4, throwable, null, OPTION_GLOBAL_ERROR_CONSOLE, null);
    }

    public static void logWarning(Plugin callingPlugin, String message) {
        LoggingService.logWarning(LoggingService.getPluginID(callingPlugin), message);
    }

    public static void logWarning(String callingPluginId, String message) {
        LoggingService.log(callingPluginId, message, 2, null, null, OPTION_GLOBAL_WARNING_CONSOLE, null);
    }

    private static synchronized String now() {
        if (_formatter == null) {
            _formatter = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss.SS");
        }
        return _formatter.format(new Date());
    }

    public static void removeLogListener(ILogListener listener) {
        Platform.removeLogListener((ILogListener)listener);
    }

    private static void streamStatus(IStatus status) {
        IStatus[] children;
        StringBuffer buffer = new StringBuffer();
        buffer.append("<");
        buffer.append(LoggingService.now());
        buffer.append("> (");
        buffer.append(status.getSeverity());
        buffer.append(") ");
        buffer.append(status.getPlugin());
        buffer.append(": ");
        buffer.append(status.getMessage());
        if (status.getSeverity() == 4) {
            System.err.println(buffer.toString());
        } else {
            System.out.println(buffer.toString());
        }
        if (status.getException() != null) {
            status.getException().printStackTrace();
        }
        if ((children = status.getChildren()) != null) {
            IStatus[] iStatusArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus nextChild = iStatusArray[n2];
                LoggingService.streamStatus(nextChild);
                ++n2;
            }
        }
    }

    public static void traceException(Plugin callingPlugin, Throwable throwable) {
        LoggingService.traceException(LoggingService.getPluginID(callingPlugin), throwable);
    }

    public static void traceException(String callingPluginId, Throwable throwable) {
        LoggingService.log(callingPluginId, throwable.getLocalizedMessage(), 1, throwable, null, OPTION_GLOBAL_DEBUG_CONSOLE, null);
    }

    private static class MultiSeverityStatus
    extends MultiStatus
    implements IWlwStatus {
        private int _severity;
        private boolean _fatal;

        public MultiSeverityStatus(String pluginID, int severity, int code, IStatus[] newChildren, String message, Throwable exception, boolean fatal) {
            super(pluginID, code, newChildren, message, exception);
            this._severity = severity;
            this._fatal = fatal;
        }

        public int getSeverity() {
            return this._severity;
        }

        @Override
        public boolean isFatal() {
            return this._fatal;
        }
    }

    public static class WlwStatus
    extends Status
    implements IWlwStatus {
        boolean _fatal;

        public WlwStatus(int severity, String pluginId, int code, String message, Throwable exception, boolean fatal) {
            super(severity, pluginId, code, message, exception);
            this._fatal = fatal;
        }

        @Override
        public boolean isFatal() {
            return this._fatal;
        }
    }
}

