/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.jdt;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.eclipse.tools.common.util.StringUtil;
import org.eclipse.jdt.core.BindingKey;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;

public class ParameterizedTypeUtil {
    public static final String EXTENDS_WILDCARD_KEYWORD = " extends ";
    public static final String SUPER_WILDCARD_KEYWORD = " super ";
    public static final String ALL_TYPES_WILDCARD = "?";

    public static boolean isParameterizedType(String type) {
        if (StringUtil.isEmpty(type)) {
            return false;
        }
        int ltIndex = type.indexOf(60);
        int gtIndex = type.lastIndexOf(62);
        return ltIndex != -1 && gtIndex != -1 && gtIndex >= ltIndex;
    }

    public static String getGenericType(String type) {
        int ltIndex = type.indexOf(60);
        int gtIndex = type.lastIndexOf(62);
        if (ltIndex == -1 || gtIndex == -1 || gtIndex < ltIndex) {
            return type;
        }
        String genType = type.substring(0, ltIndex);
        if (gtIndex < type.length() - 1) {
            genType = String.valueOf(genType) + type.substring(gtIndex + 1);
        }
        return genType;
    }

    public static List<String> getParameterTypesForGenericType(String type) {
        int ltIndex = type.indexOf(60);
        int gtIndex = type.lastIndexOf(62);
        if (ltIndex == -1 || gtIndex == -1 || gtIndex < ltIndex) {
            return null;
        }
        return ParameterizedTypeUtil.extractParameterTypesFormString(type.substring(ltIndex + 1, gtIndex));
    }

    public static String getParameterTypesAsStringForGenericType(String type) {
        int ltIndex = type.indexOf(60);
        int gtIndex = type.lastIndexOf(62);
        if (ltIndex == -1 || gtIndex == -1 || gtIndex < ltIndex) {
            return null;
        }
        return type.substring(ltIndex + 1, gtIndex);
    }

    public static List<String> extractParameterTypesFormString(String paramTypeInfo) {
        if (paramTypeInfo == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(paramTypeInfo, ",");
        ArrayList<String> paramTypes = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            paramTypes.add(st.nextToken());
        }
        return paramTypes;
    }

    public static String getParameterType(String param) {
        int qmIndex = param.indexOf(ALL_TYPES_WILDCARD);
        String keyword = EXTENDS_WILDCARD_KEYWORD;
        int wcKeywordIndex = param.indexOf(keyword);
        if (wcKeywordIndex == -1) {
            keyword = SUPER_WILDCARD_KEYWORD;
            wcKeywordIndex = param.indexOf(keyword);
        }
        if (wcKeywordIndex == -1 || wcKeywordIndex < qmIndex) {
            return param.trim();
        }
        int expectedTypeIndex = wcKeywordIndex + keyword.length();
        if (expectedTypeIndex == param.length() - 1) {
            return param;
        }
        return param.substring(expectedTypeIndex).trim();
    }

    public static ITypeBinding getTypeBinding(String typeName, IJavaProject javaProject) {
        String[] keys = new String[]{BindingKey.createTypeBindingKey((String)typeName)};
        class BindingRequestor
        extends ASTRequestor {
            private ITypeBinding _result = null;

            BindingRequestor() {
            }

            public void acceptBinding(String bindingKey, IBinding binding) {
                if (this._result == null && binding != null && binding.getKind() == 2) {
                    this._result = (ITypeBinding)binding;
                }
            }
        }
        BindingRequestor requestor = new BindingRequestor();
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setProject(javaProject);
        parser.createASTs(new ICompilationUnit[0], keys, (ASTRequestor)requestor, null);
        return requestor._result;
    }
}

