/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.jdt;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.eclipse.tools.common.util.Pair;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.PackageDeclaration;

public class JavaUtil {
    public static final String JAVA_FILE_EXTENSION = "java";
    public static final String CLASS_FILE_EXTENSION = "class";
    private static final String[] KEYWORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    private static final String[] TYPE_KEYWORDS = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void"};

    public static void addToClasspath(IJavaProject javaProject, IClasspathEntry entry) throws JavaModelException {
        if (!JavaUtil.inClasspath(javaProject, entry)) {
            IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
            IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
            System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
            newEntries[oldEntries.length] = entry;
            javaProject.setRawClasspath(newEntries, null);
        }
    }

    public static void removeFromClasspath(IJavaProject javaProject, IPath path) throws JavaModelException {
        IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>(oldEntries.length - 1);
        IClasspathEntry[] iClasspathEntryArray = oldEntries;
        int n = oldEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry oldEntry = iClasspathEntryArray[n2];
            if (!oldEntry.getPath().equals((Object)path)) {
                newEntries.add(oldEntry);
            }
            javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[newEntries.size()]), null);
            ++n2;
        }
    }

    public static void ensureClassPathEntry(IJavaProject javaProject, IPath path) throws CoreException {
        IClasspathEntry entry;
        IClasspathEntry[] entries;
        IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getRawClasspath();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            entry = iClasspathEntryArray[n2];
            if (path.equals((Object)entry.getPath())) {
                return;
            }
            ++n2;
        }
        entry = JavaCore.newSourceEntry((IPath)path);
        JavaUtil.addToClasspath(javaProject, entry);
    }

    public static String getPackageName(CompilationUnit unitAST) throws CoreException {
        PackageDeclaration pkg = unitAST.getPackage();
        if (pkg == null) {
            return "";
        }
        return pkg.getName().getFullyQualifiedName();
    }

    public static IPath getRelativeClasspathPath(IResource resource) {
        IContainer container;
        Pair<ClassPathContainment, IPath> containmentPair;
        ClassPathContainment containment;
        assert (resource != null);
        IProject project = resource.getProject();
        List<IPath> sourcePaths = JavaUtil.getFullSourcePaths((IContainer)project);
        if (sourcePaths != null && !sourcePaths.isEmpty() && (containment = (containmentPair = JavaUtil.isOnClasspathTree(container = JavaUtil.getResourceContainer(resource), sourcePaths)).getFirst()) == ClassPathContainment.CHILDOF) {
            IPath classpath = containmentPair.getSecond();
            IPath resourcePath = resource.getFullPath();
            int matching = resourcePath.matchingFirstSegments(classpath);
            return resourcePath.removeFirstSegments(matching);
        }
        return null;
    }

    public static IContainer getResourceContainer(IResource resource) {
        assert (resource != null);
        IContainer container = null;
        int type = resource.getType();
        switch (type) {
            case 1: {
                IFile file = (IFile)resource;
                container = file.getParent();
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                container = (IContainer)resource;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return container;
    }

    public static List<IPath> getFullSourcePaths(IContainer container) {
        List<IPath> rootPaths = null;
        try {
            rootPaths = JavaUtil.getFullSourcePaths2(container);
        }
        catch (JavaModelException jme) {
            LoggingService.logFatal("oracle.eclipse.tools.common", (CoreException)((Object)jme));
        }
        assert (container != null);
        return rootPaths;
    }

    public static List<IPath> getFullSourcePaths2(IContainer container) throws JavaModelException {
        IJavaProject javaProject;
        assert (container != null);
        ArrayList<IPath> rootPaths = new ArrayList<IPath>();
        IProject project = container.getProject();
        if (project.exists() && (javaProject = JavaCore.create((IProject)project)).exists()) {
            IClasspathEntry[] entries;
            IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getRawClasspath();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry nextEntry = iClasspathEntryArray[n2];
                if (nextEntry.getEntryKind() == 3) {
                    rootPaths.add(nextEntry.getPath());
                }
                ++n2;
            }
        }
        return rootPaths;
    }

    public static List<IPath> getNonDerivedSourcePaths(IProject project) {
        ArrayList<IPath> srcPaths = new ArrayList<IPath>();
        List<IPath> fullSrcPaths = JavaUtil.getFullSourcePaths((IContainer)project);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (IPath path : fullSrcPaths) {
            IResource res = root.findMember(path);
            if (res == null || res.isDerived()) continue;
            srcPaths.add(res.getProjectRelativePath());
        }
        return srcPaths;
    }

    public static List<IPath> getProjectRelativeSourcePaths(IProject project) {
        List<IPath> srcPaths = null;
        try {
            srcPaths = JavaUtil.getProjectRelativeSourcePaths2(project);
        }
        catch (JavaModelException jme) {
            LoggingService.logFatal("oracle.eclipse.tools.common", (CoreException)((Object)jme));
        }
        return srcPaths;
    }

    public static List<IPath> getProjectRelativeSourcePaths2(IProject project) throws JavaModelException {
        ArrayList<IPath> srcPaths = new ArrayList<IPath>();
        List<IPath> fullSrcPaths = JavaUtil.getFullSourcePaths2((IContainer)project);
        String projectName = project.getName();
        for (IPath nextFullPath : fullSrcPaths) {
            String pathString = (nextFullPath = nextFullPath.removeFirstSegments(1)).toPortableString();
            if (pathString.length() > 0 && pathString.charAt(0) == '/') {
                pathString = pathString.substring(1);
                nextFullPath = new Path(pathString);
            }
            LoggingService.logDebug("oracle.eclipse.tools.common", "Found source folder (" + nextFullPath.toOSString() + ") for project: " + projectName);
            srcPaths.add(nextFullPath);
        }
        return srcPaths;
    }

    public static boolean isAllowableFilename(String baseName) {
        if (JavaUtil.isKeyword(baseName)) {
            return false;
        }
        if (JavaUtil.isPrimitiveType(baseName)) {
            return false;
        }
        if (!JavaUtil.isIdentifier(baseName)) {
            return false;
        }
        return baseName.indexOf(36) == -1;
    }

    public static boolean inClasspath(IJavaProject javaProject, IClasspathEntry entry) throws JavaModelException {
        ArrayList<IClasspathEntry> oldEntries = new ArrayList<IClasspathEntry>(Arrays.asList(javaProject.getRawClasspath()));
        return oldEntries.contains(entry);
    }

    public static boolean isIdentifier(String str) {
        if (str.length() == 0 || str.length() > 64) {
            return false;
        }
        if (JavaUtil.isKeyword(str)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(str.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < str.length()) {
            if (!Character.isJavaIdentifierPart(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isKeyword(String str) {
        int i = 0;
        while (i < KEYWORDS.length) {
            if (KEYWORDS[i].equals(str)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Pair<ClassPathContainment, IPath> isOnClasspathTree(IContainer container, List<IPath> rootPaths) {
        assert (container != null);
        assert (rootPaths != null);
        IPath containerPath = container.getFullPath();
        for (IPath nextRootPath : rootPaths) {
            if (nextRootPath.isPrefixOf(containerPath)) {
                return new Pair<ClassPathContainment, IPath>(ClassPathContainment.CHILDOF, nextRootPath);
            }
            if (!containerPath.isPrefixOf(nextRootPath)) continue;
            return new Pair<ClassPathContainment, IPath>(ClassPathContainment.PARENTOF, nextRootPath);
        }
        return new Pair<ClassPathContainment, Object>(ClassPathContainment.NONE, null);
    }

    public static boolean isPrimitiveType(String str) {
        int i = 0;
        while (i < TYPE_KEYWORDS.length) {
            if (TYPE_KEYWORDS[i].equals(str)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPrimitiveNumeric(String javaType) {
        return Integer.TYPE.getName().equals(javaType) || Long.TYPE.getName().equals(javaType) || Float.TYPE.getName().equals(javaType) || Double.TYPE.getName().equals(javaType) || Short.TYPE.getName().equals(javaType) || Byte.TYPE.getName().equals(javaType);
    }

    public static boolean isType(String str) {
        if (JavaUtil.isPrimitiveType(str)) {
            return true;
        }
        StringTokenizer tokens = new StringTokenizer(str, ".", true);
        boolean expectIdent = true;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.equals(".")) {
                if (expectIdent) {
                    return false;
                }
            } else {
                if (!expectIdent) {
                    return false;
                }
                if (!JavaUtil.isIdentifier(token.trim())) {
                    return false;
                }
            }
            boolean bl = expectIdent = !expectIdent;
        }
        return !expectIdent;
    }

    public static CompilationUnit parseCompilationUnit(String source, IProgressMonitor monitor) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(source.toCharArray());
        parser.setResolveBindings(false);
        CompilationUnit unitAST = (CompilationUnit)parser.createAST(monitor);
        return unitAST;
    }

    public static IFolder getOutputFolder(IJavaProject javaProject, IFolder srcFolder) throws JavaModelException {
        IPath outputPath = JavaUtil.getOutputPath(javaProject, srcFolder.getFullPath());
        return javaProject.getProject().getWorkspace().getRoot().getFolder(outputPath);
    }

    public static IPath getOutputPath(IJavaProject javaProject, IPath srcPath) throws JavaModelException {
        IClasspathEntry[] entries;
        IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getRawClasspath();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && entry.getPath().equals((Object)srcPath)) {
                IPath location = entry.getOutputLocation();
                return location == null ? javaProject.getOutputLocation() : location;
            }
            ++n2;
        }
        return javaProject.getOutputLocation();
    }

    public static Set<IPath> getOutputPaths(IJavaProject javaProject) throws JavaModelException {
        IClasspathEntry[] entries;
        HashSet<IPath> outputPaths = new HashSet<IPath>();
        IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getRawClasspath();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IPath location;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && (location = entry.getOutputLocation()) != null && !outputPaths.contains(location)) {
                outputPaths.add(location);
            }
            ++n2;
        }
        IPath projOutputLocation = javaProject.getOutputLocation();
        if (projOutputLocation != null && !outputPaths.contains(projOutputLocation)) {
            outputPaths.add(projOutputLocation);
        }
        return outputPaths;
    }

    public static String getPackageName(IContainer container) {
        IJavaElement elem = JavaCore.create((IResource)container);
        if (elem instanceof IPackageFragmentRoot) {
            return "";
        }
        if (elem instanceof IPackageFragment) {
            return ((IPackageFragment)elem).getElementName();
        }
        return null;
    }

    public static boolean isJavaPackage(IContainer container) {
        assert (container != null);
        try {
            IJavaElement elem = JavaCore.create((IResource)container);
            return elem instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)elem).getKind() == 1 || elem instanceof IPackageFragment && ((IPackageFragment)elem).getKind() == 1;
        }
        catch (JavaModelException e) {
            LoggingService.logException("oracle.eclipse.tools.common", (CoreException)((Object)e));
            return false;
        }
    }

    public static boolean hasJavaNature(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static IJavaProject getJavaProject(IProject project) {
        IJavaProject javaProject = null;
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                javaProject = JavaCore.create((IProject)project);
            }
        }
        catch (CoreException coreException) {}
        return javaProject;
    }

    public static IClasspathEntry newLibraryEntry(IPath library, File src, URL javadoc) {
        Path srcpath = src == null ? null : new Path(src.getAbsolutePath());
        IAccessRule[] access = new IAccessRule[]{};
        IClasspathAttribute[] attrs = javadoc == null ? new IClasspathAttribute[]{} : new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)javadoc.toExternalForm())};
        return JavaCore.newLibraryEntry((IPath)library, (IPath)srcpath, null, (IAccessRule[])access, (IClasspathAttribute[])attrs, (boolean)false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSourceOrOutputDirectory(IContainer folder) {
        IPath path = folder.getFullPath();
        IProject project = folder.getProject();
        if (!JavaUtil.hasJavaNature(project)) return false;
        try {
            IJavaProject jproject = JavaCore.create((IProject)project);
            IClasspathEntry[] cp = jproject.getRawClasspath();
            int i = 0;
            while (true) {
                if (i >= cp.length) {
                    if (!jproject.getOutputLocation().equals((Object)path)) return false;
                    return true;
                }
                IClasspathEntry cpe = cp[i];
                if (cpe.getEntryKind() == 3) {
                    IPath src = cpe.getPath();
                    IPath output = cpe.getOutputLocation();
                    if (src.equals((Object)path) || output != null && output.equals((Object)path)) {
                        return true;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            LoggingService.logException("oracle.eclipse.tools.common", (CoreException)((Object)e));
        }
        return false;
    }

    public static IFile getExistingJavaFile(IProject project, String classname) {
        if (project == null || classname == null || classname.isEmpty()) {
            return null;
        }
        IJavaProject javaProject = JavaUtil.getJavaProject(project);
        if (javaProject != null) {
            try {
                IResource resource;
                ICompilationUnit cu;
                IType type = javaProject.findType(classname);
                if (type != null && (cu = type.getCompilationUnit()) != null && (resource = cu.getCorrespondingResource()) != null && resource.getType() == 1) {
                    return (IFile)resource;
                }
            }
            catch (JavaModelException jme) {
                LoggingService.logException("oracle.eclipse.tools.common", (CoreException)((Object)jme));
            }
        }
        return null;
    }

    public static IFolder getSourceFolder(IFile file) {
        if (file == null) {
            return null;
        }
        IJavaElement javaElement = JavaCore.create((IFile)file);
        if (javaElement == null) {
            return null;
        }
        IPath classPath = file.getFullPath();
        for (IPath path : JavaUtil.getFullSourcePaths((IContainer)file.getProject())) {
            IWorkspaceRoot root;
            IResource resource;
            if (!path.isPrefixOf(classPath) || (resource = (root = ResourcesPlugin.getWorkspace().getRoot()).findMember(path)) == null || resource.getType() != 2) continue;
            return (IFolder)resource;
        }
        return null;
    }

    public static enum ClassPathContainment {
        NONE,
        PARENTOF,
        CHILDOF;

    }
}

