/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.jdt;

import java.net.URL;
import oracle.eclipse.tools.common.util.ProjectUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.core.util.IFactoryPath;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class JavaProjectUtil
extends ProjectUtil {
    public static final String DOT_FACTORYPATH_FILE = ".factorypath";
    public static final String JRE_CONTAINER_ID = "org.eclipse.jdt.launching.JRE_CONTAINER";
    private static final String JAR_PROTOCOL = "jar";
    private static final String JAR_EXTENSION = ".jar";
    private static final String ZIP_EXTENSION = ".zip";

    public static boolean isJavaProject(IProject project) {
        try {
            return project.getNature("org.eclipse.jdt.core.javanature") != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isResourceInsideSourceFolder(IResource resource) {
        IProject proj = resource.getProject();
        if (!JavaProjectUtil.isJavaProject(resource.getProject())) return false;
        IPath path = resource.getFullPath();
        try {
            IJavaProject jproj = JavaCore.create((IProject)proj);
            IClasspathEntry[] iClasspathEntryArray = jproj.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry cpe = iClasspathEntryArray[n2];
                if (cpe.getEntryKind() == 3 && cpe.getPath().isPrefixOf(path)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static void replaceClasspathEntry(IProject project, IClasspathEntry oldEntry, IClasspathEntry newEntry) throws CoreException {
        if (JavaProjectUtil.isJavaProject(project)) {
            JavaProjectUtil.replaceClasspathEntry(JavaCore.create((IProject)project), oldEntry, newEntry);
        }
    }

    public static void replaceClasspathEntry(IJavaProject project, IClasspathEntry oldEntry, IClasspathEntry newEntry) throws CoreException {
        IClasspathEntry[] cp = project.getRawClasspath();
        int i = 0;
        while (i < cp.length) {
            if (cp[i].equals(oldEntry)) {
                IClasspathEntry[] newcp = new IClasspathEntry[cp.length];
                System.arraycopy(cp, 0, newcp, 0, cp.length);
                newcp[i] = newEntry;
                project.setRawClasspath(newcp, null);
                return;
            }
            ++i;
        }
    }

    public static void replaceAptFactoryPathPlugin(IProject project, String oldPluginId, String newPluginId) throws CoreException {
        IJavaProject jproj = JavaCore.create((IProject)project);
        if (jproj == null) {
            return;
        }
        IFactoryPath ifp = AptConfig.getFactoryPath((IJavaProject)jproj);
        ifp.disablePlugin(oldPluginId);
        ifp.enablePlugin(newPluginId);
        AptConfig.setFactoryPath((IJavaProject)jproj, (IFactoryPath)ifp);
        AptConfig.setEnabled((IJavaProject)jproj, (boolean)true);
    }

    public static IClasspathEntry newLibraryEntry(IPath library) {
        return JavaProjectUtil.newLibraryEntry(library, null, null);
    }

    public static IClasspathEntry newLibraryEntry(IPath library, IPath src, URL javadoc) {
        IClasspathAttribute[] attrs;
        IAccessRule[] access = new IAccessRule[]{};
        if (javadoc == null) {
            attrs = new IClasspathAttribute[]{};
        } else {
            String javadocUrlStr = javadoc.toExternalForm();
            if (!javadoc.getProtocol().equals(JAR_PROTOCOL) && (javadocUrlStr.endsWith(ZIP_EXTENSION) || javadocUrlStr.endsWith(JAR_EXTENSION))) {
                javadocUrlStr = "jar:" + javadocUrlStr + "!/";
            }
            attrs = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)javadocUrlStr)};
        }
        return JavaCore.newLibraryEntry((IPath)library, (IPath)src, null, (IAccessRule[])access, (IClasspathAttribute[])attrs, (boolean)false);
    }

    public static String getJavadocLocation(IClasspathEntry cpe) {
        IClasspathAttribute[] iClasspathAttributeArray = cpe.getExtraAttributes();
        int n = iClasspathAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute cpattr = iClasspathAttributeArray[n2];
            if (cpattr.getName().equals("javadoc_location")) {
                return cpattr.getValue();
            }
            ++n2;
        }
        return null;
    }
}

