/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.jdt;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import oracle.eclipse.tools.common.util.ResourceLoader;
import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public final class ClassUtil {
    private static ResourceLoader _resourceLoader = new ResourceLoader(ClassUtil.class);
    public static final String ERROR_TYPE = _resourceLoader.resource("error", new Object[0]);
    private static String[] PRIMITIVE_TYPES = new String[]{"int", "double", "long", "short", "byte", "float", "boolean", "char", "void"};
    private static String[] PRIMITIVE_WRAPPERS = new String[]{Integer.class.getName(), Double.class.getName(), Long.class.getName(), Short.class.getName(), Byte.class.getName(), Float.class.getName(), Boolean.class.getName(), Character.class.getName()};
    private static String[] SIMPLE_TYPES = new String[]{Integer.class.getName(), Double.class.getName(), Long.class.getName(), Short.class.getName(), Byte.class.getName(), Float.class.getName(), Boolean.class.getName(), Character.class.getName(), BigDecimal.class.getName(), BigInteger.class.getName(), String.class.getName(), java.util.Date.class.getName(), Date.class.getName()};
    private static final String[] AMBIGUOUS_TYPE_INTERFACES = new String[]{Collection.class.getName(), Iterator.class.getName(), Enumeration.class.getName()};
    public static final String SET_PREFIX = "set";
    public static final String GET_PREFIX = "get";
    public static final String IS_PREFIX = "is";
    public static final String BOOLEAN = "boolean";
    public static final String VOID = "void";

    public static String getClassName(String fullClassName) {
        if (fullClassName == null) {
            return null;
        }
        int endBracket = fullClassName.lastIndexOf(62);
        if (endBracket >= 0) {
            int beginBracket = fullClassName.indexOf(60);
            assert (beginBracket >= 0) : "no matching '<' for '>' in " + fullClassName;
            assert (beginBracket < endBracket) : "bad class syntax in " + fullClassName;
            return String.valueOf(ClassUtil.getClassName(fullClassName.substring(0, beginBracket))) + "<" + ClassUtil.getClassName(fullClassName.substring(beginBracket + 1, endBracket)) + ">" + fullClassName.substring(endBracket + 1);
        }
        int dotpos = fullClassName.lastIndexOf(46);
        return dotpos < 0 ? fullClassName : fullClassName.substring(dotpos + 1);
    }

    public static String getClassName(Object obj) {
        return ClassUtil.getClassName(obj.getClass().getName());
    }

    public static String getPackageName(String fullClassName) {
        if (fullClassName == null || fullClassName.indexOf(".") < 0) {
            return null;
        }
        return fullClassName.substring(0, fullClassName.lastIndexOf("."));
    }

    public static boolean isFullyQualified(String className) {
        if (ClassUtil.isPrimitiveType(className)) {
            return true;
        }
        return className.indexOf(".") > -1;
    }

    public static boolean isComplexType(String type) {
        return !ClassUtil.isSimpleType(type);
    }

    public static boolean isSimpleType(String type) {
        assert (type != null);
        int i = 0;
        while (i < PRIMITIVE_TYPES.length) {
            if (PRIMITIVE_TYPES[i].equals(type)) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < SIMPLE_TYPES.length) {
            if (SIMPLE_TYPES[i].equals(type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPrimitiveType(String type) {
        assert (type != null);
        int i = 0;
        while (i < PRIMITIVE_TYPES.length) {
            if (PRIMITIVE_TYPES[i].equals(type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPrimitiveWrapper(String type) {
        assert (type != null);
        int i = 0;
        while (i < PRIMITIVE_WRAPPERS.length) {
            if (PRIMITIVE_WRAPPERS[i].equals(type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getPrimitiveWrapper(String type) {
        assert (type != null);
        int i = 0;
        while (i < PRIMITIVE_TYPES.length) {
            if (PRIMITIVE_TYPES[i].equals(type) && !PRIMITIVE_TYPES[i].equals(VOID)) {
                return PRIMITIVE_WRAPPERS[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean isArrayType(String type) {
        return type.endsWith("[]");
    }

    public static String stripTypeParameters(String typeName) {
        int index;
        assert (typeName != null) : "Type name was null.";
        if (ClassUtil.hasMatchingTypeParameterBraces(typeName) && (index = typeName.indexOf(60)) > -1) {
            typeName = typeName.substring(0, index).trim();
        }
        assert (typeName != null) : "Returning null type.";
        return typeName;
    }

    public static boolean isAssignableFrom(String fullyQualifiedSubTypeName, String fullyQualifiedSuperTypeName, IProject project) {
        assert (fullyQualifiedSubTypeName != null) : "Sub type name was null.";
        assert (fullyQualifiedSuperTypeName != null) : "Super type name was null.";
        assert (fullyQualifiedSubTypeName.indexOf(60) == -1) : "Subtype should have type parameter info stripped before calling this method: " + fullyQualifiedSubTypeName;
        assert (fullyQualifiedSuperTypeName.indexOf(60) == -1) : "Supertype should have type parameter info stripped before calling this method: " + fullyQualifiedSuperTypeName;
        boolean assignableFrom = false;
        if (project != null) {
            IType subType = ClassUtil.getType(fullyQualifiedSubTypeName, project);
            IType superType = ClassUtil.getType(fullyQualifiedSuperTypeName, project);
            if (subType != null && superType != null) {
                try {
                    ITypeHierarchy th = subType.newSupertypeHierarchy(null);
                    assert (th != null) : "Type hierarchy was null.";
                    assignableFrom = th.contains(superType);
                }
                catch (JavaModelException jme) {
                    LoggingService.logFatal("oracle.eclipse.tools.common", (CoreException)((Object)jme));
                }
            }
        }
        return assignableFrom;
    }

    public static String $toDot(String fqInnerClassTypeName) {
        return fqInnerClassTypeName.replace('$', '.');
    }

    public static String stripArrayDimensions(String typeName) {
        int index;
        assert (typeName != null) : "Type name was null.";
        if (ClassUtil.hasMatchingArrayBrackets(typeName) && (index = (typeName = ClassUtil.stripTypeParameters(typeName)).indexOf(91)) > -1) {
            typeName = typeName.substring(0, index).trim();
        }
        assert (typeName != null) : "Returning null type.";
        return typeName;
    }

    public static boolean hasMatchingArrayBrackets(String type) {
        int firstBracket = type.indexOf("[");
        int nextBracket = type.indexOf("]");
        if (firstBracket == -1 && nextBracket == -1) {
            return true;
        }
        String tempType = type;
        while (tempType.length() > 0) {
            nextBracket = tempType.indexOf("]");
            if (nextBracket < firstBracket || firstBracket == -1 || nextBracket != firstBracket + 1) {
                return false;
            }
            tempType = tempType.substring(nextBracket + 1);
            firstBracket = tempType.indexOf("[");
        }
        return true;
    }

    public static boolean hasMatchingTypeParameterBraces(String type) {
        assert (type != null) : "Type was null.";
        char[] chars = type.toCharArray();
        int openCount = 0;
        int closeCount = 0;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '<') {
                ++openCount;
            }
            if (chars[i] == '>') {
                ++closeCount;
            }
            if (closeCount > openCount) {
                return false;
            }
            ++i;
        }
        return openCount == closeCount;
    }

    public static String getAlternateGetterName(String rawPropertyName, String type) {
        if (BOOLEAN.equals(type)) {
            return GET_PREFIX + ClassUtil.encodePropertyName(rawPropertyName);
        }
        assert (false) : "Alternate getter names are only applicable for boolean properties.";
        return null;
    }

    public static String getGetterName(String rawPropertyName, String type) {
        if (BOOLEAN.equals(type)) {
            return IS_PREFIX + ClassUtil.encodePropertyName(rawPropertyName);
        }
        return GET_PREFIX + ClassUtil.encodePropertyName(rawPropertyName);
    }

    public static String getSetterName(String propName) {
        return SET_PREFIX + ClassUtil.encodePropertyName(propName);
    }

    public static String encodePropertyName(String rawName) {
        char[] chars;
        String encoded = rawName;
        encoded = rawName.length() < 2 ? StringUtil.capitalizeFirstLetter(rawName) : ((chars = rawName.toCharArray())[0] == '_' ? rawName : (Character.isUpperCase(chars[0]) && (Character.isLowerCase(chars[1]) || Character.isDigit(chars[1])) ? String.valueOf('_') + rawName : (Character.isLowerCase(chars[0]) && (Character.isLowerCase(chars[1]) || Character.isDigit(chars[1])) ? StringUtil.capitalizeFirstLetter(rawName) : rawName)));
        return encoded;
    }

    public static String getPropertyName(IMethodBinding getterOrSetterMethod) {
        return new MethodWrapper(getterOrSetterMethod).getPropertyName();
    }

    public static String getPropertyName(MethodDeclaration getterOrSetterMethod) {
        return new MethodWrapper(getterOrSetterMethod).getPropertyName();
    }

    public static String getPropertyName(IMethod getterOrSetterMethod) {
        return new MethodWrapper(getterOrSetterMethod).getPropertyName();
    }

    public static String decodePropertyName(String encName) {
        char[] chars;
        String decoded = null;
        decoded = encName.length() < 2 ? StringUtil.lowerCaseFirstLetter(encName) : ((chars = encName.toCharArray())[0] == '_' ? encName : (Character.isUpperCase(chars[0]) && (Character.isLowerCase(chars[1]) || Character.isDigit(chars[1])) ? StringUtil.lowerCaseFirstLetter(encName) : encName));
        return decoded;
    }

    public static boolean isGetterOrSetterMethod(IMethodBinding method) {
        return new MethodWrapper(method).isGetterOrSetterMethod();
    }

    public static boolean isGetterOrSetterMethod(MethodDeclaration method) {
        return new MethodWrapper(method).isGetterOrSetterMethod();
    }

    public static boolean isGetterMethod(IMethodBinding method) {
        return new MethodWrapper(method).isGetterMethod();
    }

    public static boolean isGetterMethod(MethodDeclaration method) {
        return new MethodWrapper(method).isGetterMethod();
    }

    public static boolean isGetterMethod(IMethod method) {
        return new MethodWrapper(method).isGetterMethod();
    }

    public static boolean isSetterMethod(IMethodBinding method) {
        return new MethodWrapper(method).isSetterMethod();
    }

    public static boolean isSetterMethod(MethodDeclaration method) {
        return new MethodWrapper(method).isSetterMethod();
    }

    public static boolean isSetterMethod(IMethod method) {
        return new MethodWrapper(method).isSetterMethod();
    }

    public static String resolveType(String typeName, ICompilationUnit icu) throws JavaModelException {
        assert (typeName != null) : "Type name was null.";
        assert (icu != null) : "Compilation unit was null.";
        IType[] types = icu.getTypes();
        IType mainType = null;
        if (types != null && types.length > 0) {
            mainType = types[0];
        }
        if (mainType != null) {
            return ClassUtil.resolveType(typeName, mainType);
        }
        return null;
    }

    public static String resolveType(String typeName, IType type) {
        assert (typeName != null) : "Type name was null.";
        assert (type != null) : "Type was null.";
        int bracketIndex = typeName.indexOf(91);
        int typeParamIndex = typeName.indexOf(60);
        int suffixIndex = -1;
        String typeSuffix = null;
        if (bracketIndex > -1 && typeParamIndex > -1) {
            suffixIndex = bracketIndex <= typeParamIndex ? bracketIndex : typeParamIndex;
        } else if (bracketIndex > -1) {
            suffixIndex = bracketIndex;
        } else if (typeParamIndex > -1) {
            suffixIndex = typeParamIndex;
        }
        if (suffixIndex > -1) {
            typeSuffix = typeName.substring(suffixIndex);
            typeName = typeName.substring(0, suffixIndex).trim();
        }
        try {
            String value = null;
            String[][] typeMatches = type.resolveType(typeName);
            if (typeMatches != null && typeMatches.length == 1) {
                String string = value = typeMatches[0][0].length() == 0 ? typeMatches[0][1] : String.valueOf(typeMatches[0][0]) + "." + typeMatches[0][1];
            }
            if (value == null && type.isBinary()) {
                IProject project = type.getJavaProject().getProject();
                assert (project != null) : "Project was null.";
                IType resolvedType = ClassUtil.getType(typeName, project);
                if (resolvedType != null) {
                    value = resolvedType.getFullyQualifiedName('.');
                }
            }
            if (value != null && typeSuffix != null) {
                value = String.valueOf(value) + typeSuffix;
            }
            return value;
        }
        catch (JavaModelException jme) {
            LoggingService.logException("oracle.eclipse.tools.common", (Throwable)jme, "Caught exception trying to resolve type: " + typeName);
            assert (false) : "This should probably never happen, but it did for type: " + typeName;
            return null;
        }
    }

    public static IType safeGetType(String typeName, IProject project) {
        assert (typeName != null) : "Type name was null.";
        IType type = null;
        if (typeName.indexOf(91) == -1 && typeName.indexOf(93) == -1 && typeName.indexOf(60) == -1 && typeName.indexOf(62) == -1) {
            type = ClassUtil.getType(typeName, project);
        }
        return type;
    }

    public static IType getType(String fullyQualifiedType, IProject project) {
        assert (fullyQualifiedType != null) : "Fully qualified type should not be null.";
        if (fullyQualifiedType.trim().length() == 0 || fullyQualifiedType.startsWith(".") || fullyQualifiedType.endsWith(".")) {
            return null;
        }
        int ltIndex = fullyQualifiedType.indexOf(60);
        int gtIndex = fullyQualifiedType.lastIndexOf(62);
        if (ltIndex != -1 && gtIndex != -1 && gtIndex > ltIndex) assert (false) : "Type should have type parameter info stripped before calling this method: " + fullyQualifiedType;
        assert (!ClassUtil.isArrayType(fullyQualifiedType)) : "Type should have array brackets stripped before calling: " + fullyQualifiedType;
        assert (project != null) : "Project should not be null.";
        if (!project.isAccessible()) {
            LoggingService.logDebug("oracle.eclipse.tools.common", "The project provided is not accessible: " + project);
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null || !javaProject.exists()) {
            LoggingService.logDebug("oracle.eclipse.tools.common", "The project provided was not a Java project: " + project);
            return null;
        }
        IType type = null;
        try {
            type = javaProject.findType(fullyQualifiedType);
            if (type != null && (!type.exists() || type.isAnonymous())) {
                type = null;
            }
        }
        catch (JavaModelException ce) {
            LoggingService.logFatal("oracle.eclipse.tools.common", (CoreException)((Object)ce));
        }
        return type;
    }

    public static boolean isAmbiguousType(String type, IProject project) {
        boolean result = false;
        String[] stringArray = AMBIGUOUS_TYPE_INTERFACES;
        int n = AMBIGUOUS_TYPE_INTERFACES.length;
        int n2 = 0;
        while (n2 < n) {
            String ambType = stringArray[n2];
            if (type.equals(ambType) || ClassUtil.isAssignableFrom(type, ambType, project)) {
                result = true;
                break;
            }
            ++n2;
        }
        return result;
    }

    public static boolean hierarchyReallyChanged(ITypeHierarchy typeHierarchy) {
        boolean changed = false;
        if (typeHierarchy.exists()) {
            IType rootType = typeHierarchy.getType();
            Object[] currentSuperTypes = typeHierarchy.getAllSupertypes(rootType);
            try {
                typeHierarchy.refresh(null);
                Object[] newSuperTypes = typeHierarchy.getAllSupertypes(rootType);
                changed = !Arrays.equals(currentSuperTypes, newSuperTypes);
            }
            catch (JavaModelException javaModelException) {
                return true;
            }
        } else {
            changed = true;
        }
        return changed;
    }

    static class MethodWrapper {
        private String _methodName;
        private boolean _public;
        private int _argCount;
        private boolean _returnTypeIsVoid;
        private boolean _returnTypeIsPrimitiveBoolean;
        private boolean _constructor;

        public MethodWrapper(IMethod method) {
            this._methodName = method.getElementName();
            try {
                this._public = Flags.isPublic((int)method.getFlags()) || method.getDeclaringType().isInterface();
                String returnType = Signature.toString((String)method.getReturnType());
                this._constructor = returnType == null;
                this._returnTypeIsVoid = ClassUtil.VOID.equals(returnType);
                this._returnTypeIsPrimitiveBoolean = ClassUtil.BOOLEAN.equals(returnType);
            }
            catch (JavaModelException jme) {
                LoggingService.logFatal("oracle.eclipse.tools.common", (CoreException)((Object)jme));
            }
            this._argCount = method.getNumberOfParameters();
        }

        public MethodWrapper(IMethodBinding method) {
            this._methodName = method.getName();
            this._argCount = method.getParameterTypes().length;
            this._public = Modifier.isPublic((int)method.getModifiers()) || method.getDeclaringClass().isInterface();
            ITypeBinding returnType = method.getReturnType();
            this._constructor = method.isConstructor();
            this._returnTypeIsVoid = returnType.getName().equals(ClassUtil.VOID);
            this._returnTypeIsPrimitiveBoolean = returnType.isPrimitive() && returnType.getName().equals(ClassUtil.BOOLEAN);
        }

        public MethodWrapper(MethodDeclaration method) {
            ASTNode parent = method.getParent();
            assert (parent instanceof TypeDeclaration) : "Parent was not a type declaration.";
            TypeDeclaration typeDecl = (TypeDeclaration)parent;
            this._methodName = method.getName().getIdentifier();
            this._public = Modifier.isPublic((int)method.getModifiers()) || typeDecl.isInterface();
            this._argCount = method.parameters().size();
            Type returnType = method.getReturnType2();
            this._constructor = returnType == null;
            this._returnTypeIsVoid = returnType != null && returnType.isPrimitiveType() && ((PrimitiveType)returnType).getPrimitiveTypeCode() == PrimitiveType.VOID;
            this._returnTypeIsPrimitiveBoolean = returnType != null && returnType.isPrimitiveType() && ((PrimitiveType)returnType).getPrimitiveTypeCode() == PrimitiveType.BOOLEAN;
        }

        public boolean isSetterMethod() {
            boolean isSetter = false;
            isSetter = this._methodName.length() > ClassUtil.SET_PREFIX.length() && this._methodName.startsWith(ClassUtil.SET_PREFIX) && this._public && this._argCount == 1;
            return isSetter;
        }

        public boolean isGetterMethod() {
            boolean isGetter = false;
            if (!this._constructor && !this._returnTypeIsVoid && this._public && this._argCount == 0) {
                if (this._returnTypeIsPrimitiveBoolean) {
                    if (this._methodName.startsWith(ClassUtil.IS_PREFIX)) {
                        isGetter = this._methodName.length() > ClassUtil.IS_PREFIX.length();
                    } else if (this._methodName.startsWith(ClassUtil.GET_PREFIX)) {
                        isGetter = this._methodName.length() > ClassUtil.GET_PREFIX.length();
                    }
                } else if (this._methodName.startsWith(ClassUtil.GET_PREFIX)) {
                    isGetter = this._methodName.length() > ClassUtil.GET_PREFIX.length();
                }
            }
            return isGetter;
        }

        public boolean isGetterOrSetterMethod() {
            return this.isGetterMethod() || this.isSetterMethod();
        }

        public String getPropertyName() {
            assert (this.isGetterOrSetterMethod()) : "Method name doesn't start with \"get\"/\"is\" or \"set\":" + this._methodName + ".";
            if (this._returnTypeIsPrimitiveBoolean && this._methodName.startsWith(ClassUtil.IS_PREFIX)) {
                return ClassUtil.decodePropertyName(this._methodName.substring(ClassUtil.IS_PREFIX.length()));
            }
            return ClassUtil.decodePropertyName(this._methodName.substring(ClassUtil.GET_PREFIX.length()));
        }
    }
}

