/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.fileio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipError;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import oracle.eclipse.tools.common.CommonToolsPlugin;
import oracle.eclipse.tools.common.util.fileio.EclipseFileUtil;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import oracle.eclipse.tools.common.util.resources.StaticStringResourceBundle;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

public final class ZipUtil {
    private ZipUtil() {
    }

    public static void zip(File dir, File target) throws IOException {
        if (target.exists()) {
            FileUtil.delete(target);
        }
        ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(target));
        try {
            ZipUtil.zipDir(target, zip, dir, "");
        }
        catch (Throwable throwable) {
            try {
                zip.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            zip.close();
        }
        catch (IOException iOException) {}
    }

    private static void zipDir(File target, ZipOutputStream zip, File dir, String path) throws IOException {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String cpath = String.valueOf(path) + f.getName();
            if (f.isDirectory()) {
                ZipUtil.zipDir(target, zip, f, String.valueOf(cpath) + "/");
            } else {
                ZipUtil.zipFile(target, zip, f, cpath);
            }
            ++n2;
        }
    }

    private static void zipFile(File target, ZipOutputStream zip, File file, String path) throws IOException {
        if (!file.equals(target)) {
            long flength;
            int bufsize;
            FileInputStream in;
            block12: {
                ZipEntry ze = new ZipEntry(path);
                ze.setTime(file.lastModified() + 1999L);
                ze.setMethod(8);
                zip.putNextEntry(ze);
                in = new FileInputStream(file);
                bufsize = 8192;
                flength = file.length();
                if (flength != 0L) break block12;
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                return;
            }
            try {
                if (flength < (long)bufsize) {
                    bufsize = (int)flength;
                }
                byte[] buffer = new byte[bufsize];
                int count = in.read(buffer);
                while (count != -1) {
                    zip.write(buffer, 0, count);
                    count = in.read(buffer);
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void unzip(File file, File destdir) throws IOException {
        ZipUtil.unzip(file, destdir, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void unzip(File file, File destdir, IProgressMonitor monitor) throws IOException {
        ZipFile zip = ZipUtil.open(file);
        try {
            Enumeration<? extends ZipEntry> entries = zip.entries();
            int totalWork = zip.size();
            monitor.beginTask(Resources.progressUnzipping, totalWork);
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                monitor.worked(1);
                if (entry.isDirectory()) continue;
                File f = new File(destdir, entry.getName());
                File dir = f.getParentFile();
                if (!dir.exists() && !dir.mkdirs()) {
                    String msg = "Could not create dir: " + dir.getPath();
                    throw new IOException(msg);
                }
                InputStream in = null;
                FileOutputStream out = null;
                try {
                    in = zip.getInputStream(entry);
                    out = new FileOutputStream(f);
                    byte[] bytes = new byte[1024];
                    int count = in.read(bytes);
                    while (count != -1) {
                        out.write(bytes, 0, count);
                        count = in.read(bytes);
                    }
                    out.flush();
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out == null) continue;
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Throwable throwable) {
            try {
                zip.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            zip.close();
        }
        catch (IOException iOException) {}
        monitor.done();
    }

    public static void unzipFlat(File file, File destdir, IProgressMonitor monitor) throws IOException {
        ZipFile zip = ZipUtil.open(file);
        try {
            Enumeration<? extends ZipEntry> entries = zip.entries();
            int totalWork = zip.size();
            monitor.beginTask(Resources.progressUnzipping, totalWork);
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                monitor.worked(1);
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                int n = name.lastIndexOf(47);
                if (n > 0) {
                    name = name.substring(n + 1);
                }
                File f = new File(destdir, name);
                InputStream in = null;
                FileOutputStream out = null;
                try {
                    in = zip.getInputStream(entry);
                    out = new FileOutputStream(f);
                    byte[] bytes = new byte[1024];
                    int count = in.read(bytes);
                    while (count != -1) {
                        out.write(bytes, 0, count);
                        count = in.read(bytes);
                    }
                    out.flush();
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out == null) continue;
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Throwable throwable) {
            try {
                zip.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            zip.close();
        }
        catch (IOException iOException) {}
        monitor.done();
    }

    public static void unzip(File file, IContainer dest, IProgressMonitor monitor) throws CoreException {
        ZipFile zip = null;
        try {
            try {
                zip = ZipUtil.open(file);
                Enumeration<? extends ZipEntry> entries = zip.entries();
                monitor.beginTask(Resources.progressUnzipping, zip.size());
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.isDirectory()) {
                        IFile f = dest.getFile((IPath)new Path(entry.getName()));
                        EclipseFileUtil.mkdirs(f.getParent().getLocation().toFile());
                        InputStream in = null;
                        try {
                            in = zip.getInputStream(entry);
                            if (f.exists()) {
                                f.setContents(in, 1, (IProgressMonitor)new NullProgressMonitor());
                            } else {
                                f.create(in, 1, (IProgressMonitor)new NullProgressMonitor());
                            }
                        }
                        catch (Throwable throwable) {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    monitor.worked(1);
                }
            }
            catch (IOException e) {
                throw new CoreException(CommonToolsPlugin.createErrorStatus(e));
            }
        }
        catch (Throwable throwable) {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
            monitor.done();
            throw throwable;
        }
        if (zip != null) {
            try {
                zip.close();
            }
            catch (IOException iOException) {}
        }
        monitor.done();
    }

    public static ZipFile open(File file) throws IOException {
        try {
            return new ZipFile(file);
        }
        catch (FileNotFoundException e) {
            FileNotFoundException fnfe = new FileNotFoundException(file.getAbsolutePath());
            fnfe.initCause(e);
            throw fnfe;
        }
    }

    public static void update(File archive, String path, InputStream content, IProgressMonitor monitor) throws IOException {
        monitor.beginTask("", 1000);
        try {
            try {
                File tempFolder = new File(String.valueOf(archive.getAbsolutePath()) + ".tmp");
                File backupFile = new File(String.valueOf(archive.getAbsolutePath()) + ".bak");
                ZipUtil.unzip(archive, tempFolder, (IProgressMonitor)new SubProgressMonitor(monitor, 400, 2));
                File fileToUpdate = new File(tempFolder, path);
                File parentFolder = fileToUpdate.getParentFile();
                EclipseFileUtil.mkdirs(parentFolder);
                EclipseFileUtil.writeFile(fileToUpdate, content);
                if (!archive.renameTo(backupFile)) {
                    throw new IOException();
                }
                try {
                    ZipUtil.zip(tempFolder, archive);
                }
                catch (IOException e) {
                    FileUtil.delete(tempFolder);
                    FileUtil.delete(archive);
                    backupFile.renameTo(archive);
                    throw e;
                }
                monitor.worked(400);
                FileUtil.delete(tempFolder);
                FileUtil.delete(backupFile);
                monitor.worked(200);
            }
            catch (CoreException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public static ZipEntry getZipEntry(ZipFile zip, String name) throws IOException {
        String lcasename = name.toLowerCase();
        try {
            Enumeration<? extends ZipEntry> itr = zip.entries();
            while (itr.hasMoreElements()) {
                ZipEntry zipentry = itr.nextElement();
                if (!zipentry.getName().toLowerCase().equals(lcasename)) continue;
                return zipentry;
            }
        }
        catch (ZipError e) {
            throw new IOException(e);
        }
        return null;
    }

    private static final class Resources
    extends StaticStringResourceBundle {
        public static String progressUnzipped;
        public static String progressUnzipping;

        static {
            Resources.initializeMessages(ZipUtil.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

