/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.fileio;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.eclipse.tools.common.util.fileio.ZipUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class ManifestUtil {
    public static final String MANIFEST_FILE_NAME = "MANIFEST.MF";
    public static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    public static final String ATTR_CLASSPATH = "Class-Path";
    public static final String ATTR_IMPLEMENTATION_VERSION = "Implementation-Version";

    private ManifestUtil() {
    }

    public static File findManifestFile(File baseDir) {
        return new File(baseDir, MANIFEST_PATH);
    }

    public static Map<String, String> readManifest(File location) throws IOException {
        if (location.isFile()) {
            Map<String, String> map;
            ZipFile zip = ZipUtil.open(location);
            try {
                map = ManifestUtil.readManifest(zip);
            }
            catch (Throwable throwable) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                zip.close();
            }
            catch (IOException iOException) {}
            return map;
        }
        File manifestFile = new File(location, MANIFEST_PATH);
        if (manifestFile.exists()) {
            Map<String, String> map;
            FileInputStream in = new FileInputStream(manifestFile);
            try {
                map = ManifestUtil.readManifest(new BufferedInputStream(in));
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {}
            return map;
        }
        return Collections.emptyMap();
    }

    public static Map<String, String> readManifest(ZipFile zip) throws IOException {
        ZipEntry zipentry = ZipUtil.getZipEntry(zip, MANIFEST_PATH);
        if (zipentry != null) {
            Map<String, String> map;
            InputStream in = zip.getInputStream(zipentry);
            try {
                map = ManifestUtil.readManifest(in);
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
            return map;
        }
        return Collections.emptyMap();
    }

    public static Map<String, String> readManifest(InputStream stream) throws IOException {
        HashMap<String, String> entries = new HashMap<String, String>();
        Manifest manifest = new Manifest();
        manifest.read(stream);
        for (Map.Entry<Object, Object> entry : manifest.getMainAttributes().entrySet()) {
            Attributes.Name name = (Attributes.Name)entry.getKey();
            entries.put(name.toString(), (String)entry.getValue());
        }
        return entries;
    }

    public static Manifest readRawManifest(File library) throws IOException {
        if (library.isFile()) {
            Manifest manifest;
            ZipFile zip = ZipUtil.open(library);
            try {
                manifest = ManifestUtil.readRawManifest(zip);
            }
            catch (Throwable throwable) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                zip.close();
            }
            catch (IOException iOException) {}
            return manifest;
        }
        File manifestFile = new File(library, MANIFEST_PATH);
        if (manifestFile.exists()) {
            Manifest manifest;
            FileInputStream in = new FileInputStream(manifestFile);
            try {
                manifest = ManifestUtil.readRawManifest(new BufferedInputStream(in));
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {}
            return manifest;
        }
        return null;
    }

    public static Manifest readRawManifest(ZipFile zip) throws IOException {
        ZipEntry zipentry = ZipUtil.getZipEntry(zip, MANIFEST_PATH);
        if (zipentry != null) {
            Manifest manifest;
            InputStream in = zip.getInputStream(zipentry);
            try {
                manifest = ManifestUtil.readRawManifest(in);
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
            return manifest;
        }
        return null;
    }

    public static Manifest readRawManifest(InputStream stream) throws IOException {
        Manifest manifest = new Manifest();
        manifest.read(stream);
        return manifest;
    }

    public static String readManifestEntry(File location, String key) throws IOException {
        Manifest manifest = ManifestUtil.readRawManifest(location);
        if (manifest != null) {
            return ManifestUtil.readManifestEntry(manifest, key);
        }
        return null;
    }

    public static String readManifestEntry(Manifest manifest, String key) {
        for (Map.Entry<Object, Object> entry : manifest.getMainAttributes().entrySet()) {
            String name = ((Attributes.Name)entry.getKey()).toString();
            if (!key.equals(name)) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    public static void setManifestEntry(File manifestFile, String entryKey, String entryValue) throws IOException {
        ManifestUtil.setManifestEntries(manifestFile, Collections.singletonMap(entryKey, entryValue));
    }

    public static void setManifestEntries(File manifestFile, Map<String, String> entries) throws IOException {
        Manifest manifest = new Manifest();
        if (manifestFile.exists()) {
            FileInputStream in = new FileInputStream(manifestFile);
            try {
                manifest.read(new BufferedInputStream(in));
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {}
        }
        Attributes mainAttributes = manifest.getMainAttributes();
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            mainAttributes.putValue(entry.getKey(), entry.getValue());
        }
        FileOutputStream out = new FileOutputStream(manifestFile);
        try {
            BufferedOutputStream bout = new BufferedOutputStream(out);
            manifest.write(bout);
            bout.flush();
        }
        catch (Throwable throwable) {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((OutputStream)out).close();
        }
        catch (IOException iOException) {}
    }

    public static List<File> readManifestClasspath(File archive) throws IOException {
        Manifest manifest = ManifestUtil.readRawManifest(archive);
        if (manifest != null) {
            return ManifestUtil.readManifestClasspath(manifest, archive.getParentFile());
        }
        return Collections.emptyList();
    }

    public static List<File> readManifestClasspath(Manifest manifest, File baseFolder) {
        String manifestClasspathEntry = ManifestUtil.readManifestEntry(manifest, ATTR_CLASSPATH);
        if (manifestClasspathEntry == null) {
            return Collections.emptyList();
        }
        ArrayList<File> manifestClasspath = new ArrayList<File>();
        String[] stringArray = manifestClasspathEntry.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            String trimmedEntry = entry.trim();
            if (trimmedEntry.length() > 0) {
                File f = new File(trimmedEntry);
                if (!f.isAbsolute()) {
                    f = new File(baseFolder, trimmedEntry);
                }
                manifestClasspath.add(f);
            }
            ++n2;
        }
        return manifestClasspath;
    }

    public static void writeManifestClasspath(Manifest manifest, File baseFolder, List<File> entries) {
        Path baseFolderPath = new Path(baseFolder.getAbsolutePath());
        StringBuilder buf = new StringBuilder();
        for (File f : entries) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            Path absolutePath = new Path(f.getAbsolutePath());
            IPath relativePath = absolutePath.makeRelativeTo((IPath)baseFolderPath);
            buf.append(relativePath.toPortableString());
        }
        manifest.getMainAttributes().putValue(ATTR_CLASSPATH, buf.toString());
    }

    public static byte[] toByteArray(Manifest manifest) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (manifest.getMainAttributes().getValue("Manifest-Version") == null) {
            manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
        }
        manifest.write(out);
        return out.toByteArray();
    }
}

