/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.fileio;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.eclipse.tools.common.util.fileio.EclipseFileUtil;
import oracle.eclipse.tools.common.util.resources.StaticStringResourceBundle;
import org.eclipse.core.runtime.CoreException;

public final class FileUtil {
    public static final boolean WINDOWS_PLATFORM = File.separatorChar == '\\';
    private static final char[] ILLEGAL_PATH_CHARACTERS = new char[]{'/', '\\', ':', '*', '?', '\"', '<', '>', '|'};
    private static Set<String> RESERVED_WINDOWS_FILE_NAMES = new HashSet<String>();

    static {
        RESERVED_WINDOWS_FILE_NAMES.add("CON");
        RESERVED_WINDOWS_FILE_NAMES.add("PRN");
        RESERVED_WINDOWS_FILE_NAMES.add("AUX");
        RESERVED_WINDOWS_FILE_NAMES.add("NUL");
        RESERVED_WINDOWS_FILE_NAMES.add("COM1");
        RESERVED_WINDOWS_FILE_NAMES.add("COM2");
        RESERVED_WINDOWS_FILE_NAMES.add("COM3");
        RESERVED_WINDOWS_FILE_NAMES.add("COM4");
        RESERVED_WINDOWS_FILE_NAMES.add("COM5");
        RESERVED_WINDOWS_FILE_NAMES.add("COM6");
        RESERVED_WINDOWS_FILE_NAMES.add("COM7");
        RESERVED_WINDOWS_FILE_NAMES.add("COM8");
        RESERVED_WINDOWS_FILE_NAMES.add("COM9");
        RESERVED_WINDOWS_FILE_NAMES.add("LPT1");
        RESERVED_WINDOWS_FILE_NAMES.add("LPT2");
        RESERVED_WINDOWS_FILE_NAMES.add("LPT3");
        RESERVED_WINDOWS_FILE_NAMES.add("LPT4");
        RESERVED_WINDOWS_FILE_NAMES.add("LPT5");
        RESERVED_WINDOWS_FILE_NAMES.add("LPT6");
        RESERVED_WINDOWS_FILE_NAMES.add("LPT7");
        RESERVED_WINDOWS_FILE_NAMES.add("LPT8");
        RESERVED_WINDOWS_FILE_NAMES.add("LPT9");
    }

    private FileUtil() {
    }

    public static File canonicalize(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (IOException iOException) {
            return f;
        }
    }

    public static String getExtension(File f) {
        String fname = f.getName();
        int lastdot = fname.lastIndexOf(46);
        if (lastdot == -1) {
            return "";
        }
        return fname.substring(lastdot + 1);
    }

    public static FileFilter getExtensionFilter(String ... extensions) {
        String[] lowerCaseExtensions = extensions;
        boolean copied = false;
        int i = 0;
        while (i < extensions.length) {
            String actualExtension = extensions[i];
            String lowerCaseExtension = actualExtension.toLowerCase();
            if (!lowerCaseExtension.equals(actualExtension)) {
                if (!copied) {
                    lowerCaseExtensions = new String[extensions.length];
                    System.arraycopy(extensions, 0, lowerCaseExtensions, 0, extensions.length);
                    copied = true;
                }
                lowerCaseExtensions[i] = lowerCaseExtension;
            }
            ++i;
        }
        final String[] lowerCaseExtensionsFinal = lowerCaseExtensions;
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                String ext = FileUtil.getExtension(f).toLowerCase();
                String[] stringArray = lowerCaseExtensionsFinal;
                int n = lowerCaseExtensionsFinal.length;
                int n2 = 0;
                while (n2 < n) {
                    String extension = stringArray[n2];
                    if (ext.equals(extension)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
    }

    public static FileFilter getFilesFilter(final File[] files) {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File x = fileArray[n2];
                    if (f.equals(x)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        };
    }

    public static String getNameWithoutExtension(File f) {
        String fname = f.getName();
        int lastdot = fname.lastIndexOf(46);
        if (lastdot == -1) {
            return fname;
        }
        return fname.substring(0, lastdot);
    }

    public static String getRelativePath(File path, File base) {
        String[] splitPath = path.getAbsolutePath().split("[/\\\\]");
        String[] splitBase = base.getAbsolutePath().split("[/\\\\]");
        int i = 0;
        while (i < splitPath.length && i < splitBase.length && splitPath[i].equals(splitBase[i])) {
            ++i;
        }
        if (i != splitBase.length) {
            throw new IllegalArgumentException("path not beneath base");
        }
        StringBuilder buf = new StringBuilder();
        while (i < splitPath.length) {
            if (buf.length() > 0) {
                buf.append('/');
            }
            buf.append(splitPath[i]);
            ++i;
        }
        return buf.toString();
    }

    public static void delete(File f) throws IOException {
        FileUtil.delete(f, false);
    }

    public static void delete(File f, boolean continueOnFailure) throws IOException {
        if (f.exists()) {
            if (f.isDirectory()) {
                File[] fileArray = f.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    FileUtil.delete(child, continueOnFailure);
                    ++n2;
                }
            }
            if (!f.delete() && !continueOnFailure) {
                String msg = "Could not delete " + f.getPath() + ".";
                throw new IOException(msg);
            }
        }
    }

    public static void copy(File source, File target) throws IOException {
        FileUtil.copy(source, target, null);
    }

    public static void copy(File source, File target, FileFilter filter) throws IOException {
        if (filter == null || filter.accept(source)) {
            if (source.isDirectory()) {
                if (!target.mkdirs()) {
                    throw new IOException();
                }
                File[] fileArray = source.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    FileUtil.copy(f, new File(target, f.getName()), filter);
                    ++n2;
                }
            } else if (!target.exists()) {
                FileInputStream in = null;
                FileOutputStream out = null;
                target.getParentFile().mkdirs();
                try {
                    in = new FileInputStream(source);
                    out = new FileOutputStream(target);
                    byte[] buf = new byte[1024];
                    int i = 0;
                    while ((i = in.read(buf)) != -1) {
                        out.write(buf, 0, i);
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static boolean containsTree(File source, File target, FileFilter filter) throws IOException {
        if (filter == null || filter.accept(source)) {
            if (source.isDirectory()) {
                File[] fileArray = source.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (!FileUtil.containsTree(f, new File(target, f.getName()), filter)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            return target.exists();
        }
        return true;
    }

    public static boolean isPathValid(String path) {
        return FileUtil.validatePath(path) == null;
    }

    public static String validatePath(String path) {
        char ch2;
        char ch1;
        String p = path;
        boolean removedDriveDesignator = false;
        if (WINDOWS_PLATFORM && p.length() >= 3) {
            ch1 = path.charAt(0);
            ch2 = path.charAt(1);
            char ch3 = path.charAt(2);
            if (Character.isLetter(ch1) && ch2 == ':' && (ch3 == '\\' || ch3 == '/')) {
                if (p.length() == 3) {
                    return null;
                }
                p = p.substring(3);
                removedDriveDesignator = true;
            }
        }
        if (!removedDriveDesignator && p.length() >= 2) {
            ch1 = path.charAt(0);
            ch2 = path.charAt(1);
            if (ch1 == '/' && ch2 == '/' || ch1 == '\\' && ch2 == '\\') {
                if (p.length() == 2) {
                    return Resources.bind(Resources.pathIsInvalid, path);
                }
                p = p.substring(2);
            }
        }
        StringTokenizer tokens = new StringTokenizer(p, "/\\");
        while (tokens.hasMoreTokens()) {
            String res = FileUtil.validatePathSegment(path, tokens.nextToken());
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private static String validatePathSegment(String path, String segment) {
        if (segment.length() == 0) {
            return Resources.bind(Resources.zeroLengthPathSegment, path);
        }
        int i = 0;
        int n = segment.length();
        while (i < n) {
            char x = segment.charAt(i);
            char[] cArray = ILLEGAL_PATH_CHARACTERS;
            int n2 = ILLEGAL_PATH_CHARACTERS.length;
            int n3 = 0;
            while (n3 < n2) {
                char y = cArray[n3];
                if (x == y) {
                    return Resources.bind(Resources.illegalPathCharacter, path, String.valueOf(y));
                }
                ++n3;
            }
            ++i;
        }
        if (WINDOWS_PLATFORM) {
            int dot = segment.indexOf(46);
            String fname = dot == -1 ? segment : segment.substring(0, dot);
            if (RESERVED_WINDOWS_FILE_NAMES.contains(fname = fname.toUpperCase())) {
                return Resources.bind(Resources.pathReservedOnWindows, path, fname);
            }
        }
        return null;
    }

    public static String readTextFile(File file) throws IOException {
        return FileUtil.readTextFile(file, System.getProperty("line.separator"));
    }

    public static String readTextFile(Reader reader) throws IOException {
        return FileUtil.readTextFile(reader, System.getProperty("line.separator"));
    }

    public static String readTextFile(InputStream is) throws IOException {
        return FileUtil.readTextFile(is, System.getProperty("line.separator"));
    }

    public static String readTextFile(File file, String lineSep) throws IOException {
        String string;
        FileInputStream stream = new FileInputStream(file);
        try {
            string = FileUtil.readTextFile(stream, lineSep);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStream)stream).close();
        }
        catch (IOException iOException) {}
        return string;
    }

    public static String readTextFile(Reader reader, String lineSep) throws IOException {
        StringBuffer buffer = new StringBuffer();
        try (BufferedReader br = new BufferedReader(reader);){
            String temp;
            while ((temp = br.readLine()) != null) {
                if (buffer.length() != 0) {
                    buffer.append(lineSep);
                }
                buffer.append(temp);
            }
        }
        return buffer.toString();
    }

    public static String readTextFile(InputStream is, String lineSep) throws IOException {
        return FileUtil.readTextFile(new InputStreamReader(is, StandardCharsets.UTF_8), lineSep);
    }

    public static void writeTextFile(File file, String data) throws IOException {
        FileUtil.writeFile(file, data.getBytes(StandardCharsets.UTF_8));
    }

    public static String readFile(InputStream input) throws IOException {
        InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
        BufferedReader bufferedReader = new BufferedReader(reader);
        char[] buffer = new char[32768];
        StringBuffer result = new StringBuffer();
        try {
            int count;
            while ((count = bufferedReader.read(buffer)) != -1) {
                result.append(buffer, 0, count);
            }
        }
        finally {
            buffer = null;
            bufferedReader.close();
            reader.close();
        }
        return result.toString();
    }

    public static byte[] readFile(File src) throws IOException {
        try (FileInputStream fin = new FileInputStream(src);){
            long fileLen = src.length();
            if (fileLen > Integer.MAX_VALUE) {
                throw new IOException(Resources.bind(Resources.filePathTooLong, fileLen));
            }
            byte[] bytes = new byte[(int)fileLen];
            fin.read(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    public static void writeFile(File dest, byte[] bytes) throws IOException {
        if (dest.exists() && !dest.canWrite()) {
            throw new IOException(Resources.fileReadOnly);
        }
        try {
            EclipseFileUtil.mkdirs(dest.getParentFile());
        }
        catch (CoreException e) {
            throw new IOException(e.getMessage(), e);
        }
        FileOutputStream fout = new FileOutputStream(dest.getPath());
        try {
            ((OutputStream)fout).write(bytes);
        }
        catch (Throwable throwable) {
            try {
                ((OutputStream)fout).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((OutputStream)fout).close();
        }
        catch (IOException iOException) {}
    }

    private static final class Resources
    extends StaticStringResourceBundle {
        public static String pathIsInvalid;
        public static String zeroLengthPathSegment;
        public static String illegalPathCharacter;
        public static String pathReservedOnWindows;
        public static String filePathTooLong;
        public static String fileReadOnly;

        static {
            Resources.initializeMessages(FileUtil.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

