/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.fileio;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.regex.Pattern;
import oracle.eclipse.tools.common.internal.OracleCommonToolsPlugin;
import oracle.eclipse.tools.common.util.ValidateEditUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class EclipseFileUtil {
    public static final boolean caseSensitive;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !EclipseFileUtil.class.desiredAssertionStatus();
        caseSensitive = "macosx".equals(Platform.getOS()) ? false : new File("a").compareTo(new File("A")) != 0;
    }

    public static void copyFromPlugin(String pluginId, IPath pathInPlugin, IFile destination) throws CoreException {
        EclipseFileUtil.copyFromPlugin(pluginId, pathInPlugin, destination.getLocation().toFile());
    }

    public static void copyFromPlugin(Bundle bundle, IPath pathInPlugin, IFile destination) throws CoreException {
        EclipseFileUtil.copyFromPlugin(bundle, pathInPlugin, destination.getLocation().toFile());
    }

    public static void copyFromPlugin(String pluginId, IPath pathInPlugin, File destination) throws CoreException {
        Bundle bundle = Platform.getBundle((String)pluginId);
        EclipseFileUtil.copyFromPlugin(bundle, pathInPlugin, destination);
    }

    public static void copyFromPlugin(Bundle bundle, IPath pathInPlugin, File destination) throws CoreException {
        InputStream contents = EclipseFileUtil.readFileFromPlugin(bundle, pathInPlugin);
        try {
            EclipseFileUtil.writeFile(destination, contents);
        }
        catch (Throwable throwable) {
            try {
                contents.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            contents.close();
        }
        catch (Exception exception) {}
    }

    public static InputStream readFileFromPlugin(Bundle bundle, IPath pathInPlugin) throws CoreException {
        try {
            return FileLocator.openStream((Bundle)bundle, (IPath)pathInPlugin, (boolean)false);
        }
        catch (IOException e) {
            throw new CoreException(OracleCommonToolsPlugin.createErrorStatus(e.getMessage(), e));
        }
    }

    public static File getFileFromPlugin(Plugin plugin, String pluginRelativePath) {
        File file;
        block2: {
            file = null;
            Bundle bundle = plugin.getBundle();
            try {
                file = EclipseFileUtil.getFileFromPlugin(bundle, pluginRelativePath);
            }
            catch (IOException e) {
                LoggingService.logException(plugin, (Throwable)e);
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e.getMessage());
            }
        }
        return file;
    }

    public static File getFileFromPlugin(Bundle bundle, String pluginRelativePath) throws IOException {
        URL iconDir = FileLocator.find((Bundle)bundle, (IPath)new Path(pluginRelativePath), null);
        if (!$assertionsDisabled && iconDir == null) {
            throw new AssertionError((Object)("Couldn't find path in plugin bundle: " + pluginRelativePath));
        }
        URL localURL = FileLocator.toFileURL((URL)iconDir);
        return new File(localURL.getPath());
    }

    public static void copyFileToProject(File from, IFile to) throws IOException, CoreException {
        EclipseFileUtil.copyFile(from, to.getLocation().toFile());
        to.getProject().refreshLocal(2, null);
    }

    public static void copyFile(File from, File to) throws IOException {
        if (!$assertionsDisabled && from == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && to == null) {
            throw new AssertionError();
        }
        if (!to.exists()) {
            File parentDir = to.getParentFile();
            if (!parentDir.exists() && !parentDir.mkdirs()) {
                throw new IOException();
            }
            to.createNewFile();
        }
        FileOutputStream out = null;
        try (FileInputStream in = null;){
            in = new FileInputStream(from);
            try {
                out = new FileOutputStream(to);
                try (FileChannel ic = in.getChannel();
                     FileChannel oc = out.getChannel();){
                    oc.transferFrom(ic, 0L, from.length());
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public static void copyFiles(File from, File to) throws IOException {
        EclipseFileUtil.copyFiles(from, to, null);
    }

    public static boolean copyFiles(File from, File to, String regexp) throws IOException {
        if (!$assertionsDisabled && from == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && to == null) {
            throw new AssertionError();
        }
        Pattern pattern = null;
        if (regexp != null) {
            pattern = Pattern.compile(regexp);
        }
        return EclipseFileUtil.copyFiles(from, to, pattern);
    }

    private static boolean copyFiles(File from, File to, Pattern regexp) throws IOException {
        if (from.isDirectory()) {
            if (!to.exists() && !to.mkdirs()) {
                throw new IOException();
            }
            if (!$assertionsDisabled && !to.isDirectory()) {
                throw new AssertionError();
            }
            File[] fromChildren = from.listFiles();
            boolean copiedOneChild = false;
            if (fromChildren != null) {
                File[] fileArray = fromChildren;
                int n = fromChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    File nextFrom = fileArray[n2];
                    File nextTo = new File(to, nextFrom.getName());
                    if (EclipseFileUtil.copyFiles(nextFrom, nextTo, regexp)) {
                        copiedOneChild = true;
                    }
                    ++n2;
                }
            }
            if (regexp != null && !copiedOneChild && !to.delete()) {
                throw new IOException();
            }
            return copiedOneChild;
        }
        if (regexp == null || regexp.matcher(from.getName()).matches()) {
            EclipseFileUtil.copyFile(from, to);
            return true;
        }
        return false;
    }

    public static boolean deleteFile(File file) throws IOException {
        File[] children;
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                EclipseFileUtil.deleteFile(child);
                ++n2;
            }
        }
        return file.delete();
    }

    public static boolean isContentType(IFile file, String contentTypeId) {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        ISchedulingRule rule = null;
        try {
            IContentType contentType;
            rule = ResourcesPlugin.getWorkspace().getRuleFactory().deleteRule((IResource)file);
            Platform.getJobManager().beginRule(rule, null);
            if (!file.exists()) {
                return false;
            }
            IContentDescription contentDesc = null;
            try {
                contentDesc = file.getContentDescription();
            }
            catch (CoreException coreException) {
                contentDesc = null;
            }
            if (contentDesc != null && (contentType = contentDesc.getContentType()) != null && contentType.getId().equals(contentTypeId)) {
                return true;
            }
        }
        finally {
            if (rule != null) {
                Platform.getJobManager().endRule(rule);
            }
        }
        return false;
    }

    public static IFile getWorkspaceFile(File f) {
        Path path;
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wsroot = ws.getRoot();
        IFile[] wsFiles = wsroot.findFilesForLocation((IPath)(path = new Path(f.getAbsolutePath())));
        if (wsFiles.length > 0) {
            return wsFiles[0];
        }
        return null;
    }

    public static IContainer getWorkspaceContainer(File f) {
        Path path;
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wsroot = ws.getRoot();
        IContainer[] wsContainers = wsroot.findContainersForLocation((IPath)(path = new Path(f.getAbsolutePath())));
        if (wsContainers.length > 0) {
            return wsContainers[0];
        }
        return null;
    }

    public static void mkdirs(File f) throws CoreException {
        IContainer wsContainer = EclipseFileUtil.getWorkspaceContainer(f);
        if (f.exists()) {
            if (f.isFile()) {
                String msg = NLS.bind((String)Resources.locationIsFile, (Object)f.getAbsolutePath());
                throw OracleCommonToolsPlugin.createCoreException(msg);
            }
            if (wsContainer != null) {
                wsContainer.refreshLocal(0, null);
            }
        } else {
            EclipseFileUtil.mkdirs(f.getParentFile());
            if (wsContainer != null) {
                IFolder iFolder = (IFolder)wsContainer;
                iFolder.create(true, true, null);
            } else {
                boolean isSuccessful = f.mkdir();
                if (!isSuccessful) {
                    String msg = NLS.bind((String)Resources.failedToCreateDirectory, (Object)f.getAbsolutePath());
                    throw OracleCommonToolsPlugin.createCoreException(msg);
                }
            }
        }
    }

    public static void writeFile(IFile f, String contents) throws CoreException {
        EclipseFileUtil.writeFile(f.getLocation().toFile(), contents);
    }

    public static void writeFile(IFile f, byte[] contents) throws CoreException {
        EclipseFileUtil.writeFile(f.getLocation().toFile(), contents);
    }

    public static void writeFile(IFile f, InputStream contents) throws CoreException {
        EclipseFileUtil.writeFile(f.getLocation().toFile(), contents);
    }

    public static void writeFile(File f, String contents) throws CoreException {
        EclipseFileUtil.writeFile(f, contents.getBytes(StandardCharsets.UTF_8));
    }

    public static void writeFile(File f, byte[] contents) throws CoreException {
        EclipseFileUtil.writeFile(f, (InputStream)new ByteArrayInputStream(contents));
    }

    public static void writeFile(File f, InputStream contents) throws CoreException {
        IFile wsfile;
        if (f.exists()) {
            if (f.isDirectory()) {
                String msg = NLS.bind((String)Resources.locationIsDirectory, (Object)f.getAbsolutePath());
                throw OracleCommonToolsPlugin.createCoreException(msg);
            }
        } else {
            EclipseFileUtil.mkdirs(f.getParentFile());
        }
        if ((wsfile = EclipseFileUtil.getWorkspaceFile(f)) != null) {
            if (!ValidateEditUtil.validateEdit(wsfile).isOK()) {
                return;
            }
            if (wsfile.exists()) {
                wsfile.setContents(contents, true, false, null);
            } else {
                wsfile.create(contents, true, null);
            }
        } else {
            if (f.exists() && !f.canWrite()) {
                String msg = NLS.bind((String)Resources.cannotWriteFile, (Object)f.getAbsolutePath());
                throw OracleCommonToolsPlugin.createCoreException(msg);
            }
            byte[] buffer = new byte[1024];
            FileOutputStream out = null;
            try {
                try {
                    int count;
                    out = new FileOutputStream(f);
                    while ((count = contents.read(buffer)) != -1) {
                        out.write(buffer, 0, count);
                    }
                    out.flush();
                }
                catch (IOException e) {
                    String msg = NLS.bind((String)Resources.failedWhileWriting, (Object)f.getAbsolutePath());
                    throw OracleCommonToolsPlugin.createCoreException(msg, e);
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static final Comparator<IFile> getByNameIFileComparator() {
        Comparator<IFile> comparator = new Comparator<IFile>(){

            @Override
            public int compare(IFile f1, IFile f2) {
                String p1 = f1.getFullPath().toPortableString();
                String p2 = f2.getFullPath().toPortableString();
                return p1.compareTo(p2);
            }
        };
        return comparator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean caseSensitiveDoesNotExist(IFile f) {
        if (f.exists()) {
            return false;
        }
        if (caseSensitive) return true;
        String fileName = f.getName();
        IContainer container = f.getParent();
        if (!container.exists()) return true;
        if (container.getType() == 4) {
            if (!((IProject)container).isOpen()) return true;
        }
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                IResource rsrc = iResourceArray[n2];
                if (1 == rsrc.getType() && fileName.equalsIgnoreCase(rsrc.getName())) {
                    return false;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static String computeRelativeReferencePath(IResource referencingResource, IResource referencedResource) {
        if (referencingResource == null || referencedResource == null) {
            return null;
        }
        IPath referencingPath = referencingResource.getFullPath();
        IPath referencedPath = referencedResource.getFullPath();
        if (referencingPath.getDevice() != null || referencedPath.getDevice() != null) {
            return null;
        }
        referencingPath = referencingPath.makeRelative();
        referencedPath = referencedPath.makeRelative();
        int referencingSegmentCount = 1;
        int referencedSegmentCount = 1;
        if (referencingResource instanceof IContainer) {
            referencingSegmentCount = 0;
        }
        if (referencedResource instanceof IContainer) {
            referencedSegmentCount = 0;
        }
        while (referencingPath.segmentCount() > referencingSegmentCount && referencedPath.segmentCount() > referencedSegmentCount && referencingPath.segment(0).equals(referencedPath.segment(0))) {
            referencingPath = referencingPath.removeFirstSegments(1);
            referencedPath = referencedPath.removeFirstSegments(1);
        }
        Object result = null;
        StringBuilder buf = new StringBuilder();
        String segment = null;
        do {
            segment = referencedPath.lastSegment();
            referencingPath = referencingPath.removeLastSegments(1);
            referencedPath = referencedPath.removeLastSegments(1);
            if (segment != null) {
                result = result == null ? new Path(segment) : new Path(segment).append((IPath)result);
            }
            if (referencingPath.equals((Object)referencedPath) || referencingPath.isEmpty()) continue;
            buf.append("../");
        } while (!referencingPath.equals((Object)referencedPath));
        if (result != null) {
            buf.append(result.makeRelative().toString());
        }
        return buf.toString();
    }

    public static IFile computeReferencedFile(IFile referencingFile, String relativeReferencePath) {
        IPath wsdlPath = referencingFile.getParent().getFullPath().append((IPath)new Path(relativeReferencePath));
        return ResourcesPlugin.getWorkspace().getRoot().getFile(wsdlPath);
    }

    private static final class Resources
    extends NLS {
        public static String failedWhileWriting;
        public static String cannotWriteFile;
        public static String failedToCreateDirectory;
        public static String locationIsDirectory;
        public static String locationIsFile;

        static {
            Resources.initializeMessages((String)EclipseFileUtil.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

