/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.classloader;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.util.jdt.ClasspathUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

public class ProjectInfo {
    private Map<File, Long> jarLastModified = new HashMap<File, Long>();
    private WeakReference<ClassLoader> parent;

    public ProjectInfo(IJavaProject project, ClassLoader parent) throws JavaModelException {
        this(project, parent, null);
    }

    public ProjectInfo(IJavaProject project, ClassLoader parent, JarFilter filter) throws JavaModelException {
        List<IPath> cp = ClasspathUtil.createClasspath(project);
        for (IPath path : cp) {
            File f = path.toFile();
            if (!f.isFile() || filter != null && !filter.test(f)) continue;
            this.jarLastModified.put(f, f.lastModified());
        }
        this.parent = new WeakReference<ClassLoader>(parent);
    }

    public boolean equals(Object other) {
        if (other instanceof ProjectInfo) {
            ClassLoader otherParentCL;
            ProjectInfo pj = (ProjectInfo)other;
            ClassLoader parentCL = (ClassLoader)this.parent.get();
            if (parentCL == null ^ (otherParentCL = (ClassLoader)pj.parent.get()) == null) {
                return false;
            }
            if (parentCL != null && !parentCL.equals(otherParentCL)) {
                return false;
            }
            if (this.jarLastModified.size() != pj.jarLastModified.size()) {
                return false;
            }
            for (Map.Entry<File, Long> entry : this.jarLastModified.entrySet()) {
                File key = entry.getKey();
                Long pjValue = pj.jarLastModified.get(key);
                if (pjValue != null && pjValue.equals(entry.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        for (Map.Entry<File, Long> entry : this.jarLastModified.entrySet()) {
            hash += entry.getKey().hashCode() + entry.getValue().hashCode();
        }
        ClassLoader parentCL = (ClassLoader)this.parent.get();
        if (parentCL != null) {
            hash += parentCL.hashCode();
        }
        return hash;
    }

    public Set<File> getJarFiles() {
        return this.jarLastModified.keySet();
    }

    public static interface JarFilter {
        public boolean test(File var1);
    }
}

