/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.classloader;

import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarURLConnectionWithoutResourceNotFoundLeak
extends JarURLConnection {
    private JarEntry jarEntry;
    private JarFile jarFile;

    public JarURLConnectionWithoutResourceNotFoundLeak(URL url) throws MalformedURLException, IOException {
        super(url);
    }

    @Override
    public void connect() throws IOException {
        if (this.jarFile != null) {
            return;
        }
        String jarFilePath = this.getJarFileURL().getFile();
        if (jarFilePath.contains("%") || jarFilePath.contains("+")) {
            try {
                jarFilePath = URLDecoder.decode(jarFilePath, "UTF-8");
            }
            catch (Exception exception) {}
        }
        this.jarFile = new JarFile(jarFilePath);
        this.jarEntry = this.jarFile.getJarEntry(this.getEntryName());
        if (this.jarEntry == null) {
            this.jarFile.close();
            throw new FileNotFoundException("JAR entry " + this.getEntryName() + " not found in " + this.jarFile.getName());
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        if (this.jarEntry == null) {
            throw new FileNotFoundException("JAR entry " + this.getEntryName() + " not found in " + this.jarFile.getName());
        }
        return new JarInputStream(this.jarFile.getInputStream(this.jarEntry));
    }

    @Override
    public JarFile getJarFile() throws IOException {
        return this.jarFile;
    }

    class JarInputStream
    extends FilterInputStream {
        public JarInputStream(InputStream src) {
            super(src);
        }

        @Override
        public void close() throws IOException {
            super.close();
            JarURLConnectionWithoutResourceNotFoundLeak.this.jarFile.close();
        }
    }
}

