/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.common.util.ast.EditFailedException;
import oracle.eclipse.tools.common.util.ast.IBodyDeclarationInserter;
import oracle.eclipse.tools.common.util.ast.ReaderUtil;
import oracle.eclipse.tools.common.util.ast.WriterContext;
import oracle.eclipse.tools.common.util.jdt.ClassUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.BindingKey;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class WriterUtil {
    private static final String FQ_NAME_PROP = "fqName";
    public static final String VALUE_ATTR_NAME = "value";

    public static NormalAnnotation ensureNormalAnnotation(BodyDeclaration parent, String name, WriterContext ctx) {
        Annotation ann = ReaderUtil.findAnnotationMatch(parent, name);
        if (ann instanceof NormalAnnotation) {
            return (NormalAnnotation)ann;
        }
        if (ann != null) {
            return WriterUtil.ensureNormalAnnotation(ann, ctx);
        }
        return WriterUtil.addAnnotation(parent, name, null, ctx);
    }

    public static NormalAnnotation ensureNormalAnnotation(Annotation annotation, WriterContext ctx) {
        Expression value;
        ITypeBinding typeBinding;
        IAnnotationBinding resolvedAnnotation;
        assert (annotation != null);
        if (annotation instanceof NormalAnnotation) {
            return (NormalAnnotation)annotation;
        }
        AST ast = annotation.getAST();
        NormalAnnotation normalAnn = ast.newNormalAnnotation();
        normalAnn.setTypeName(ast.newName(annotation.getTypeName().getFullyQualifiedName()));
        String fqName = (String)annotation.getProperty(FQ_NAME_PROP);
        if (fqName == null && (resolvedAnnotation = annotation.resolveAnnotationBinding()) != null && (typeBinding = resolvedAnnotation.getAnnotationType()) != null) {
            fqName = typeBinding.getQualifiedName();
        }
        normalAnn.setProperty(FQ_NAME_PROP, (Object)fqName);
        ctx.getASTRewrite().replace((ASTNode)annotation, (ASTNode)normalAnn, null);
        if (annotation instanceof SingleMemberAnnotation && (value = ((SingleMemberAnnotation)annotation).getValue()) != null) {
            MemberValuePair mvp = ast.newMemberValuePair();
            mvp.setName(ast.newSimpleName(VALUE_ATTR_NAME));
            ASTNode newValue = ctx.getASTRewrite().createCopyTarget((ASTNode)value);
            mvp.setValue((Expression)newValue);
            WriterUtil.addChildToAnnotation(normalAnn, (ASTNode)mvp, ctx);
        }
        return normalAnn;
    }

    public static NormalAnnotation addAnnotation(BodyDeclaration parent, String name, Map<String, String> attrs, WriterContext ctx) {
        assert (parent != null);
        return WriterUtil.addAnnotation((ASTNode)parent, name, attrs, parent.getModifiersProperty(), ctx);
    }

    public static NormalAnnotation addAnnotation(SingleVariableDeclaration parent, String name, Map<String, String> attrs, WriterContext ctx) {
        return WriterUtil.addAnnotation((ASTNode)parent, name, attrs, SingleVariableDeclaration.MODIFIERS2_PROPERTY, ctx);
    }

    static NormalAnnotation addAnnotation(ASTNode parent, String name, Map<String, String> attrs, ChildListPropertyDescriptor property, WriterContext ctx) {
        assert (parent != null);
        assert (name != null);
        WriterUtil.ensureImport(parent, name, ctx);
        NormalAnnotation annotation = WriterUtil.createAnnotation(name, attrs, ctx);
        ListRewrite modifiersRewrite = ctx.getASTRewrite().getListRewrite(parent, property);
        modifiersRewrite.insertFirst((ASTNode)annotation, null);
        return annotation;
    }

    public static MarkerAnnotation addMarkerAnnotation(BodyDeclaration parent, String name, WriterContext ctx) {
        assert (parent != null);
        return WriterUtil.addMarkerAnnotation((ASTNode)parent, name, parent.getModifiersProperty(), ctx);
    }

    public static MarkerAnnotation addMarkerAnnotation(SingleVariableDeclaration parent, String name, WriterContext ctx) {
        return WriterUtil.addMarkerAnnotation((ASTNode)parent, name, SingleVariableDeclaration.MODIFIERS2_PROPERTY, ctx);
    }

    static MarkerAnnotation addMarkerAnnotation(ASTNode parent, String name, ChildListPropertyDescriptor property, WriterContext ctx) {
        assert (parent != null);
        assert (name != null);
        WriterUtil.ensureImport(parent, name, ctx);
        AST ast = ctx.getASTRewrite().getAST();
        MarkerAnnotation annotation = ast.newMarkerAnnotation();
        String shortName = WriterUtil.getShortTypeName(name, ctx);
        annotation.setTypeName(ast.newName(shortName));
        annotation.setProperty(FQ_NAME_PROP, (Object)name);
        ListRewrite modifiersRewrite = ctx.getASTRewrite().getListRewrite(parent, property);
        modifiersRewrite.insertFirst((ASTNode)annotation, null);
        return annotation;
    }

    static SingleMemberAnnotation createSingleMemberAnnotation(String annotationName, Map<String, String> attrs, WriterContext ctx) {
        AST ast = ctx.getASTRewrite().getAST();
        SingleMemberAnnotation annotation = ast.newSingleMemberAnnotation();
        String shortName = WriterUtil.getShortTypeName(annotationName, ctx);
        annotation.setTypeName(ast.newName(shortName));
        annotation.setProperty(FQ_NAME_PROP, (Object)annotationName);
        WriterUtil.setAnnotationAttributes((Annotation)annotation, attrs, ctx);
        return annotation;
    }

    public static Annotation appendAnnotation(BodyDeclaration parent, String name, Map<String, String> attrs, WriterContext ctx) {
        assert (parent != null);
        assert (name != null);
        WriterUtil.ensureImport((ASTNode)parent, name, ctx);
        Object annotation = null;
        annotation = attrs != null && attrs.containsKey(VALUE_ATTR_NAME) && attrs.keySet().size() == 1 ? WriterUtil.createSingleMemberAnnotation(name, attrs, ctx) : WriterUtil.createAnnotation(name, attrs, ctx);
        ListRewrite modifiersRewrite = ctx.getASTRewrite().getListRewrite((ASTNode)parent, parent.getModifiersProperty());
        List modifiersList = parent.modifiers();
        if (modifiersList == null) {
            modifiersRewrite.insertLast((ASTNode)annotation, null);
        } else {
            Modifier firstModifier = null;
            for (IExtendedModifier modifier : modifiersList) {
                if (!modifier.isModifier()) continue;
                firstModifier = (Modifier)modifier;
                break;
            }
            if (firstModifier != null) {
                modifiersRewrite.insertBefore((ASTNode)annotation, firstModifier, null);
            } else {
                modifiersRewrite.insertLast((ASTNode)annotation, null);
            }
        }
        return annotation;
    }

    public static NormalAnnotation addChildAnnotation(Annotation parent, String attrName, String annotationName, Map<String, String> attrs, WriterContext ctx) {
        assert (parent != null);
        NormalAnnotation normalParent = WriterUtil.ensureNormalAnnotation(parent, ctx);
        WriterUtil.ensureImport((ASTNode)parent, annotationName, ctx);
        AST ast = normalParent.getAST();
        NormalAnnotation annotation = WriterUtil.createAnnotation(annotationName, attrs, ctx);
        if (attrName != null) {
            MemberValuePair mvp = ast.newMemberValuePair();
            mvp.setName(ast.newSimpleName(attrName));
            mvp.setValue((Expression)annotation);
            WriterUtil.addChildToAnnotation(normalParent, (ASTNode)mvp, ctx);
        } else {
            WriterUtil.addChildToAnnotation(normalParent, (ASTNode)annotation, ctx);
        }
        return annotation;
    }

    static NormalAnnotation createAnnotation(String annotationName, Map<String, String> attrs, WriterContext ctx) {
        AST ast = ctx.getASTRewrite().getAST();
        NormalAnnotation annotation = ast.newNormalAnnotation();
        String shortName = WriterUtil.getShortTypeName(annotationName, ctx);
        annotation.setTypeName(ast.newName(shortName));
        annotation.setProperty(FQ_NAME_PROP, (Object)annotationName);
        WriterUtil.setAnnotationAttributes((Annotation)annotation, attrs, ctx);
        return annotation;
    }

    public static void setAnnotationAttributes(Annotation annotation, Map<String, String> attrs, WriterContext ctx) {
        assert (ctx != null);
        assert (annotation != null);
        if (attrs != null) {
            for (Map.Entry<String, String> entry : attrs.entrySet()) {
                annotation = WriterUtil.setAnnotationAttribute(annotation, entry.getKey(), entry.getValue(), ctx);
            }
        } else if (annotation instanceof NormalAnnotation) {
            ListRewrite valuesRewrite = ctx.getASTRewrite().getListRewrite((ASTNode)annotation, NormalAnnotation.VALUES_PROPERTY);
            List values = valuesRewrite.getRewrittenList();
            int i = 0;
            while (i < values.size()) {
                valuesRewrite.remove((ASTNode)values.get(i), null);
                ++i;
            }
        } else if (annotation instanceof SingleMemberAnnotation) {
            ctx.getASTRewrite().set((ASTNode)annotation, (StructuralPropertyDescriptor)SingleMemberAnnotation.VALUE_PROPERTY, null, null);
        }
    }

    public static NormalAnnotation addAnnotationArrayMember(Annotation parent, String arrayName, String annotationName, Map<String, String> attrs, WriterContext ctx) throws EditFailedException {
        assert (parent != null);
        WriterUtil.ensureImport((ASTNode)parent, annotationName, ctx);
        NormalAnnotation normalParent = WriterUtil.ensureNormalAnnotation(parent, ctx);
        AST ast = normalParent.getAST();
        ListRewrite parentValuesRewrite = ctx.getASTRewrite().getListRewrite((ASTNode)normalParent, NormalAnnotation.VALUES_PROPERTY);
        Expression fwdExpr = ReaderUtil.getExpression(parentValuesRewrite.getRewrittenList(), arrayName);
        ArrayInitializer ai = null;
        if (fwdExpr == null) {
            MemberValuePair mvp = ast.newMemberValuePair();
            mvp.setName(ast.newSimpleName(arrayName));
            ai = ast.newArrayInitializer();
            mvp.setValue((Expression)ai);
            parentValuesRewrite.insertLast((ASTNode)mvp, null);
        } else if (fwdExpr instanceof ArrayInitializer) {
            ai = (ArrayInitializer)fwdExpr;
        } else {
            MemberValuePair mvp2;
            List mvps = parentValuesRewrite.getRewrittenList();
            MemberValuePair oldMvp = null;
            int index = 0;
            for (MemberValuePair mvp2 : mvps) {
                if (mvp2.getName().getIdentifier().equals(arrayName)) {
                    oldMvp = mvp2;
                    break;
                }
                ++index;
            }
            parentValuesRewrite.remove(oldMvp, null);
            mvp2 = ast.newMemberValuePair();
            mvp2.setName(ast.newSimpleName(arrayName));
            ai = ast.newArrayInitializer();
            mvp2.setValue((Expression)ai);
            parentValuesRewrite.insertAt((ASTNode)mvp2, index, null);
            ListRewrite aiRewrite = ctx.getASTRewrite().getListRewrite((ASTNode)ai, ArrayInitializer.EXPRESSIONS_PROPERTY);
            aiRewrite.insertFirst(ctx.getASTRewrite().createCopyTarget((ASTNode)fwdExpr), null);
        }
        NormalAnnotation annotation = WriterUtil.createAnnotation(annotationName, attrs, ctx);
        ListRewrite arrayListRewrite = ctx.getASTRewrite().getListRewrite((ASTNode)ai, ArrayInitializer.EXPRESSIONS_PROPERTY);
        arrayListRewrite.insertLast((ASTNode)annotation, null);
        return annotation;
    }

    public static void addExpression(Annotation parent, String attrName, String value, WriterContext ctx) {
        assert (ctx != null);
        AST ast = parent.getAST();
        ITypeBinding type = WriterUtil.getAttributeTypeBinding(parent, attrName, ctx);
        if (type != null) {
            if (String.class.getName().equals(type.getQualifiedName())) {
                IVariableBinding valueType = WriterUtil.getVariableBinding(value, ctx.getICompilationUnit().getJavaProject());
                if (valueType != null) {
                    type = valueType.getDeclaringClass();
                    WriterUtil.ensureImport(type.getQualifiedName(), ctx);
                    value = valueType.getName();
                }
            } else {
                WriterUtil.ensureImport(type.getQualifiedName(), ctx);
            }
        }
        Expression expr = WriterUtil.createExpression(ast, value, type, ctx);
        assert (expr != null);
        if (parent instanceof SingleMemberAnnotation && attrName.equals(VALUE_ATTR_NAME)) {
            ctx.getASTRewrite().set((ASTNode)parent, (StructuralPropertyDescriptor)SingleMemberAnnotation.VALUE_PROPERTY, (Object)expr, null);
        } else {
            NormalAnnotation normalParent = WriterUtil.ensureNormalAnnotation(parent, ctx);
            MemberValuePair mvp = ast.newMemberValuePair();
            SimpleName sn = ast.newSimpleName(attrName);
            mvp.setName(sn);
            mvp.setValue(expr);
            WriterUtil.addChildToAnnotation(normalParent, (ASTNode)mvp, ctx);
        }
    }

    public static Annotation setAnnotationAttribute(Annotation annotation, String attrName, Object value, WriterContext ctx) {
        assert (annotation != null);
        assert (attrName != null);
        if (annotation instanceof SingleMemberAnnotation && attrName.equals(VALUE_ATTR_NAME)) {
            if (value != null) {
                WriterUtil.addExpression(annotation, VALUE_ATTR_NAME, value.toString(), ctx);
            } else {
                AST ast = annotation.getAST();
                NormalAnnotation newAnno = ast.newNormalAnnotation();
                Name newName = ast.newName(((SingleMemberAnnotation)annotation).getTypeName().getFullyQualifiedName());
                newAnno.setTypeName(newName);
                ctx.getASTRewrite().replace((ASTNode)annotation, (ASTNode)newAnno, null);
            }
            return annotation;
        }
        NormalAnnotation normalAnnotation = WriterUtil.ensureNormalAnnotation(annotation, ctx);
        MemberValuePair mvp = WriterUtil.getMemberValuePair(normalAnnotation, attrName, ctx);
        if (value != null) {
            if (mvp == null) {
                WriterUtil.addExpression((Annotation)normalAnnotation, attrName, value.toString(), ctx);
            } else {
                IVariableBinding valueType;
                ITypeBinding attrType = WriterUtil.getAttributeTypeBinding(annotation, attrName, ctx);
                if (String.class.getName().equals(attrType.getQualifiedName()) && (valueType = WriterUtil.getVariableBinding((String)value, ctx.getICompilationUnit().getJavaProject())) != null) {
                    attrType = valueType.getDeclaringClass();
                    WriterUtil.ensureImport(attrType.getQualifiedName(), ctx);
                    value = valueType.getName();
                }
                WriterUtil.setExpressionValue(mvp, value.toString(), attrType, ctx);
            }
        } else if (mvp != null) {
            ListRewrite valuesRewrite = ctx.getASTRewrite().getListRewrite((ASTNode)normalAnnotation, NormalAnnotation.VALUES_PROPERTY);
            valuesRewrite.remove((ASTNode)mvp, null);
        }
        return normalAnnotation;
    }

    static void setExpressionValue(MemberValuePair mvp, String value, ITypeBinding type, WriterContext ctx) {
        AST ast = mvp.getAST();
        Expression expr = WriterUtil.createExpression(ast, value, type, ctx);
        ctx.getASTRewrite().set((ASTNode)mvp, (StructuralPropertyDescriptor)MemberValuePair.VALUE_PROPERTY, (Object)expr, null);
    }

    public static Annotation setAttributeArray(Annotation annotation, String attrName, List values, WriterContext ctx) {
        assert (annotation != null);
        assert (attrName != null);
        ArrayInitializer ai = null;
        AST ast = annotation.getAST();
        if (annotation instanceof SingleMemberAnnotation && attrName.equals(VALUE_ATTR_NAME)) {
            if (values == null || values.size() == 0) {
                ctx.getASTRewrite().set((ASTNode)annotation, (StructuralPropertyDescriptor)SingleMemberAnnotation.VALUE_PROPERTY, null, null);
                return annotation;
            }
            ai = ast.newArrayInitializer();
            ctx.getASTRewrite().set((ASTNode)annotation, (StructuralPropertyDescriptor)SingleMemberAnnotation.VALUE_PROPERTY, (Object)ai, null);
        } else {
            annotation = WriterUtil.ensureNormalAnnotation(annotation, ctx);
            MemberValuePair mvp = WriterUtil.getMemberValuePair((NormalAnnotation)annotation, attrName, ctx);
            if (values == null || values.size() == 0) {
                if (mvp != null) {
                    ListRewrite valuesRewrite = ctx.getASTRewrite().getListRewrite((ASTNode)annotation, NormalAnnotation.VALUES_PROPERTY);
                    valuesRewrite.remove((ASTNode)mvp, null);
                }
                return annotation;
            }
            if (mvp == null) {
                mvp = ast.newMemberValuePair();
                SimpleName sn = ast.newSimpleName(attrName);
                mvp.setName(sn);
                ai = ast.newArrayInitializer();
                mvp.setValue((Expression)ai);
                WriterUtil.addChildToAnnotation((NormalAnnotation)annotation, (ASTNode)mvp, ctx);
            } else {
                Expression expr = mvp.getValue();
                if (expr instanceof ArrayInitializer) {
                    ai = (ArrayInitializer)expr;
                } else {
                    ai = ast.newArrayInitializer();
                    ctx.getASTRewrite().set((ASTNode)mvp, (StructuralPropertyDescriptor)MemberValuePair.VALUE_PROPERTY, (Object)ai, null);
                }
            }
        }
        assert (ai != null);
        ListRewrite exprRewrite = ctx.getASTRewrite().getListRewrite((ASTNode)ai, ArrayInitializer.EXPRESSIONS_PROPERTY);
        List currentValues = exprRewrite.getRewrittenList();
        int i = 0;
        while (i < currentValues.size()) {
            exprRewrite.remove((ASTNode)currentValues.get(i), null);
            ++i;
        }
        ITypeBinding attributeType = WriterUtil.getAttributeTypeBinding(annotation, attrName, ctx);
        ITypeBinding type = attributeType.getElementType();
        for (Object value : values) {
            assert (value != null);
            Expression expr = WriterUtil.createExpression(ast, value.toString(), type, ctx);
            exprRewrite.insertLast((ASTNode)expr, null);
        }
        return annotation;
    }

    public static void removeElement(ASTNode node, WriterContext ctx) {
        ASTNode parent = node.getParent();
        if (node instanceof Annotation && parent instanceof ArrayInitializer && parent.getParent() instanceof MemberValuePair && ((ArrayInitializer)parent).expressions().size() == 1) {
            ASTNode nodeToDelete = parent.getParent();
            ASTNode nodeToDeleteParent = nodeToDelete.getParent();
            assert (nodeToDeleteParent instanceof NormalAnnotation) : "Expected annotation array to be in a NormalAnnotation";
            ListRewrite valuesRewrite = ctx.getASTRewrite().getListRewrite(nodeToDeleteParent, NormalAnnotation.VALUES_PROPERTY);
            valuesRewrite.remove(nodeToDelete, null);
        } else if (node instanceof Annotation && parent instanceof MemberValuePair) {
            ASTNode nodeToDeleteParent = parent.getParent();
            assert (nodeToDeleteParent instanceof NormalAnnotation) : "Expected annotation to be in a NormalAnnotation";
            ListRewrite valuesRewrite = ctx.getASTRewrite().getListRewrite(nodeToDeleteParent, NormalAnnotation.VALUES_PROPERTY);
            valuesRewrite.remove(parent, null);
        } else {
            StructuralPropertyDescriptor desc = node.getLocationInParent();
            assert (desc instanceof ChildListPropertyDescriptor) : "Currently only handling removing children from a list. File a bug if this assert fires.";
            ListRewrite childRewrite = ctx.getASTRewrite().getListRewrite(parent, (ChildListPropertyDescriptor)desc);
            childRewrite.remove(node, null);
        }
    }

    static MemberValuePair getMemberValuePair(NormalAnnotation anno, String name, WriterContext ctx) {
        ListRewrite exprRewrite = ctx.getASTRewrite().getListRewrite((ASTNode)anno, NormalAnnotation.VALUES_PROPERTY);
        List exprs = exprRewrite.getRewrittenList();
        for (MemberValuePair pair : exprs) {
            if (!pair.getName().getIdentifier().equals(name)) continue;
            return pair;
        }
        return null;
    }

    private static Expression createExpression(AST ast, String value, ITypeBinding type, WriterContext ctx) {
        String expType;
        BooleanLiteral expr = null;
        String string = expType = type == null ? null : type.getQualifiedName();
        if (expType == null) {
            expType = String.class.getName();
        }
        if (Boolean.class.getName().equals(expType) || Boolean.TYPE.getName().equals(expType)) {
            expr = ast.newBooleanLiteral(Boolean.valueOf(value).booleanValue());
        } else if (Integer.class.getName().equals(expType) || Integer.TYPE.getName().equals(expType)) {
            expr = ast.newNumberLiteral(value);
        } else if (Long.class.getName().equals(expType) || Long.TYPE.getName().equals(expType)) {
            expr = ast.newNumberLiteral(value);
        } else if (Float.class.getName().equals(expType) || Float.TYPE.getName().equals(expType)) {
            expr = ast.newNumberLiteral(String.valueOf(value) + "f");
        } else if (Byte.class.getName().equals(expType) || Byte.TYPE.getName().equals(expType)) {
            expr = ast.newNumberLiteral(value);
        } else if (Short.class.getName().equals(expType) || Short.TYPE.getName().equals(expType)) {
            expr = ast.newNumberLiteral(value);
        } else if (Character.class.getName().equals(expType) || Character.TYPE.getName().equals(expType)) {
            if (value != null && value.length() == 1) {
                char charValue = value.charAt(0);
                expr = ast.newCharacterLiteral();
                ((CharacterLiteral)expr).setCharValue(charValue);
            }
        } else if (Double.class.getName().equals(expType) || Double.TYPE.getName().equals(expType)) {
            expr = ast.newNumberLiteral(value);
        } else if (type != null && type.isEnum()) {
            if (value.equals("null")) {
                expr = ast.newNullLiteral();
            } else {
                String enumName = WriterUtil.getShortTypeName(type.getQualifiedName(), ctx);
                expr = ast.newQualifiedName(ast.newName(enumName), ast.newSimpleName(value));
            }
        } else if (expType.startsWith(Class.class.getName())) {
            if (value.endsWith(".class") && value.length() > 6) {
                value = value.substring(0, value.length() - 6);
            }
            ITypeBinding typeBinding = WriterUtil.getTypeBinding(value, ctx.getICompilationUnit().getJavaProject());
            Object t = null;
            t = typeBinding != null ? WriterUtil.createTypeNode(ast, typeBinding) : ast.newSimpleType(ast.newName(value));
            expr = ast.newTypeLiteral();
            ((TypeLiteral)expr).setType(t);
        } else if (type != null && !String.class.getName().equals(expType) && (type.isClass() || type.isInterface())) {
            String constName = WriterUtil.getShortTypeName(type.getQualifiedName(), ctx);
            expr = ast.newQualifiedName(ast.newName(constName), ast.newSimpleName(value));
        } else if (expr == null) {
            expr = ast.newStringLiteral();
            ((StringLiteral)expr).setLiteralValue(value);
        }
        assert (expr != null) : "Couldn't create an appropriate expression for value: " + value + ", type: " + expType;
        return expr;
    }

    private static Type createTypeNode(AST ast, ITypeBinding typeBinding) {
        assert (typeBinding != null);
        SimpleType result = null;
        if (typeBinding.isArray()) {
            ITypeBinding componentTypeBinding = typeBinding.getElementType();
            String componentType = componentTypeBinding.getQualifiedName();
            int dim = typeBinding.getDimensions();
            SimpleType simpleType = ast.newSimpleType(ast.newName(componentType));
            result = ast.newArrayType((Type)simpleType, dim);
        } else if (typeBinding.isPrimitive()) {
            PrimitiveType.Code code = PrimitiveType.toCode((String)typeBinding.getQualifiedName());
            result = ast.newPrimitiveType(code);
        } else {
            result = ast.newSimpleType(ast.newName(typeBinding.getQualifiedName()));
        }
        return result;
    }

    public static boolean ensureImport(String clazz, WriterContext ctx) {
        assert (clazz != null);
        CompilationUnit cu = ctx.getCompilationUnit();
        if (cu == null) {
            return false;
        }
        return WriterUtil.ensureImport(cu, clazz, ctx.getASTRewrite(), ctx.getICompilationUnit().getJavaProject());
    }

    public static boolean ensureImport(ASTNode node, String clazz, WriterContext ctx) {
        assert (clazz != null);
        ASTNode root = node.getRoot();
        if (!(root instanceof CompilationUnit)) {
            return false;
        }
        CompilationUnit cu = (CompilationUnit)root;
        return WriterUtil.ensureImport(cu, clazz, ctx.getASTRewrite(), ctx.getICompilationUnit().getJavaProject());
    }

    public static boolean ensureImport(CompilationUnit cu, String clazz, ASTRewrite astRewrite, IJavaProject project) {
        ListRewrite importsRewrite = astRewrite.getListRewrite((ASTNode)cu, CompilationUnit.IMPORTS_PROPERTY);
        List imports = importsRewrite.getRewrittenList();
        ITypeBinding binding = WriterUtil.getTypeBinding(clazz, project);
        String preferredImport = binding == null ? clazz : WriterUtil.getImport(binding);
        String pkg = null;
        if (binding != null) {
            assert (!binding.isParameterizedType()) : "This method does not support parameterized types";
            IPackageBinding pkgBinding = binding.getPackage();
            if (pkgBinding == null) {
                return false;
            }
            pkg = pkgBinding.getName();
            if (pkg != null) {
                if (pkg.equals("java.lang")) {
                    return false;
                }
                PackageDeclaration currentPkg = cu.getPackage();
                if (currentPkg != null && currentPkg.getName().getFullyQualifiedName().equals(pkg)) {
                    return false;
                }
            }
        }
        boolean found = false;
        int i = 0;
        while (i < imports.size() && !found) {
            ImportDeclaration decl = (ImportDeclaration)imports.get(i);
            String name = decl.getName().getFullyQualifiedName();
            found = name.equals(clazz) || name.equals(preferredImport) || pkg != null && name.equals(pkg);
            ++i;
        }
        if (!found) {
            ImportDeclaration decl = cu.getAST().newImportDeclaration();
            decl.setName(cu.getAST().newName(preferredImport));
            importsRewrite.insertLast((ASTNode)decl, null);
            return true;
        }
        return false;
    }

    private static final String getImport(ITypeBinding typeBinding) {
        if (typeBinding.isMember()) {
            return WriterUtil.getImport(typeBinding.getDeclaringClass());
        }
        return typeBinding.getQualifiedName();
    }

    static final void addChildToAnnotation(NormalAnnotation parent, ASTNode child, WriterContext ctx) {
        ListRewrite valuesRewrite = ctx.getASTRewrite().getListRewrite((ASTNode)parent, NormalAnnotation.VALUES_PROPERTY);
        valuesRewrite.insertLast(child, null);
    }

    public static ITypeBinding getTypeBinding(String typeName, IJavaProject javaProject) {
        String[] keys = WriterUtil.createBindingKeyList(typeName);
        class BindingRequestor
        extends ASTRequestor {
            private ITypeBinding _result = null;

            BindingRequestor() {
            }

            public void acceptBinding(String bindingKey, IBinding binding) {
                if (this._result == null && binding != null && binding.getKind() == 2) {
                    this._result = (ITypeBinding)binding;
                }
            }
        }
        BindingRequestor requestor = new BindingRequestor();
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setProject(javaProject);
        parser.createASTs(new ICompilationUnit[0], keys, (ASTRequestor)requestor, null);
        return requestor._result;
    }

    public static IVariableBinding getVariableBinding(String typeName, IJavaProject javaProject) {
        ITypeBinding typeBinding;
        StringTokenizer t = new StringTokenizer(typeName, ".", true);
        int balance = 0;
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            if (s.indexOf(46) >= 0) {
                if (s.length() > 1) {
                    return null;
                }
                if (--balance >= 0) continue;
                return null;
            }
            ++balance;
        }
        if (balance != 1) {
            return null;
        }
        int i = typeName.lastIndexOf(46);
        if (i == -1) {
            return null;
        }
        String typeVariableName = typeName.substring(i + 1, typeName.length());
        String declaringType = typeName.substring(0, i);
        String className = ClassUtil.getClassName(declaringType);
        if (className != null && !className.isEmpty() && (typeBinding = WriterUtil.getTypeBinding(declaringType, javaProject)) != null) {
            IVariableBinding[] vBindingArray;
            IVariableBinding[] iVariableBindingArray = vBindingArray = typeBinding.getDeclaredFields();
            int n = vBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVariableBinding vBinding = iVariableBindingArray[n2];
                if (vBinding.getName().equals(typeVariableName)) {
                    return vBinding;
                }
                ++n2;
            }
        }
        return null;
    }

    private static String[] createBindingKeyList(String name) {
        ArrayList<String> list = new ArrayList<String>();
        do {
            list.add(BindingKey.createTypeBindingKey((String)name));
        } while ((name = WriterUtil.translateInnerClassName(name)) != null);
        String[] results = new String[list.size()];
        return list.toArray(results);
    }

    private static String translateInnerClassName(String name) {
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return null;
        }
        StringBuilder sb = new StringBuilder(name.substring(0, i));
        sb.append('$');
        sb.append(name.substring(i + 1, name.length()));
        return sb.toString();
    }

    public static ITypeBinding getAttributeTypeBinding(Annotation annotation, String attr, WriterContext ctx) {
        IAnnotationBinding resolvedAnnotation = annotation.resolveAnnotationBinding();
        ITypeBinding typeBinding = null;
        if (resolvedAnnotation != null) {
            typeBinding = resolvedAnnotation.getAnnotationType();
        } else if (ctx != null) {
            String fqName;
            IJavaProject javaProject = ctx.getICompilationUnit().getJavaProject();
            typeBinding = WriterUtil.getTypeBinding(annotation.getTypeName().getFullyQualifiedName(), javaProject);
            if (typeBinding == null && (fqName = (String)annotation.getProperty(FQ_NAME_PROP)) != null) {
                typeBinding = WriterUtil.getTypeBinding(fqName, javaProject);
            }
        }
        if (typeBinding != null) {
            IMethodBinding[] methods;
            IMethodBinding[] iMethodBindingArray = methods = typeBinding.getDeclaredMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding method = iMethodBindingArray[n2];
                if (attr.equals(method.getName())) {
                    return method.getReturnType();
                }
                ++n2;
            }
        }
        return null;
    }

    public static String getShortTypeName(String type, WriterContext ctx) {
        assert (ctx != null);
        return WriterUtil.getShortTypeName(type, ctx.getICompilationUnit().getJavaProject());
    }

    public static String getShortTypeName(String type, IJavaProject project) {
        assert (project != null);
        if (type.indexOf(46) < 0) {
            return type;
        }
        ITypeBinding typeBinding = WriterUtil.getTypeBinding(type, project);
        if (typeBinding == null) {
            return type;
        }
        if (typeBinding.isMember()) {
            ITypeBinding declaringClass = typeBinding.getDeclaringClass();
            return String.valueOf(WriterUtil.getShortTypeName(declaringClass.getQualifiedName(), project)) + '.' + typeBinding.getName();
        }
        return typeBinding.getName();
    }

    public static String formatBodyDeclaration(String bodyDeclaration, WriterContext ctx) throws BadLocationException {
        IJavaProject javaProject = ctx.getICompilationUnit().getJavaProject();
        CodeFormatter formatter = ToolFactory.createCodeFormatter((Map)javaProject.getOptions(true));
        TextEdit formatEdit = formatter.format(4, bodyDeclaration, 0, bodyDeclaration.length(), 0, null);
        if (formatEdit != null) {
            Document genDoc = new Document(bodyDeclaration);
            formatEdit.apply((IDocument)genDoc);
            bodyDeclaration = genDoc.get();
        }
        return bodyDeclaration;
    }

    public static ITrackedNodePosition insertDeclaration(TypeDeclaration astType, String decl, int declType, IBodyDeclarationInserter inserter, WriterContext writerContext) throws BadLocationException, CoreException {
        String str = WriterUtil.formatBodyDeclaration(decl, writerContext);
        ASTRewrite rewrite = writerContext.getASTRewrite();
        ASTNode node = rewrite.createStringPlaceholder(str, declType);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)astType, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
        ITrackedNodePosition position = rewrite.track(node);
        if (inserter == null) {
            inserter = new IBodyDeclarationInserter.DefaultNodeInserter();
        }
        inserter.insert(listRewrite, node);
        return position;
    }

    public static ITrackedNodePosition insertDeclaration(TypeDeclaration astType, ASTNode node, IBodyDeclarationInserter inserter, WriterContext writerContext) throws BadLocationException, CoreException {
        ASTRewrite rewrite = writerContext.getASTRewrite();
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)astType, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
        ITrackedNodePosition position = rewrite.track(node);
        if (inserter == null) {
            inserter = new IBodyDeclarationInserter.DefaultNodeInserter();
        }
        inserter.insert(listRewrite, node);
        return position;
    }

    public static ITrackedNodePosition insertField(TypeDeclaration astType, String field, WriterContext ctx) throws BadLocationException, CoreException {
        return WriterUtil.insertDeclaration(astType, field, 23, new IBodyDeclarationInserter.FieldInserter(), ctx);
    }

    public static ITrackedNodePosition insertMethod(TypeDeclaration astType, String method, WriterContext ctx) throws BadLocationException, CoreException {
        return WriterUtil.insertDeclaration(astType, method, 31, new IBodyDeclarationInserter.MethodInserter(), ctx);
    }

    public static ITrackedNodePosition insertType(TypeDeclaration astType, String innerType, WriterContext ctx) throws BadLocationException, CoreException {
        return WriterUtil.insertDeclaration(astType, innerType, 55, new IBodyDeclarationInserter.DefaultNodeInserter(), ctx);
    }

    public static void ensureFieldPresent(TypeDeclaration type, String identifier, String variableDeclaration, WriterContext ctx) throws BadLocationException, CoreException {
        assert (identifier != null);
        assert (variableDeclaration != null);
        assert (type != null);
        assert (ctx != null);
        if (!ReaderUtil.isFieldDeclared(identifier, type.resolveBinding())) {
            WriterUtil.insertField(type, variableDeclaration, ctx);
        }
    }

    public static void ensureInterfaceImplemented(TypeDeclaration type, String interfaceName, WriterContext ctx) {
        assert (type != null);
        assert (interfaceName != null);
        assert (ctx != null);
        if (!ReaderUtil.isInterfaceImplemented(interfaceName, type.resolveBinding())) {
            WriterUtil.ensureImport((ASTNode)type, interfaceName, ctx);
            AST ast = type.getAST();
            SimpleType simpleType = ast.newSimpleType(ast.newName(StringUtil.stripPackage(interfaceName)));
            ListRewrite listRewrite = ctx.getASTRewrite().getListRewrite((ASTNode)type, TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY);
            listRewrite.insertLast((ASTNode)simpleType, null);
        }
    }
}

