/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.ast;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;

public class OrderedAttributeMap
extends TreeMap<String, String> {
    private static final long serialVersionUID = 3303194122474943171L;

    public OrderedAttributeMap(String[] preferredOrder) {
        super(new AttributeComparator(preferredOrder));
    }

    private static class AttributeComparator
    implements Comparator<String> {
        private List<String> _order;

        private AttributeComparator(String[] preferredOrder) {
            assert (preferredOrder != null);
            this._order = new ArrayList<String>(preferredOrder.length);
            String[] stringArray = preferredOrder;
            int n = preferredOrder.length;
            int n2 = 0;
            while (n2 < n) {
                String attr = stringArray[n2];
                this._order.add(attr);
                ++n2;
            }
        }

        private void ensure(String attr) {
            if (!this._order.contains(attr)) {
                this._order.add(attr);
            }
        }

        @Override
        public int compare(String o1, String o2) {
            this.ensure(o1);
            this.ensure(o2);
            int i1 = this._order.indexOf(o1);
            int i2 = this._order.indexOf(o2);
            if (i1 < i2) {
                return -1;
            }
            if (i2 < i1) {
                return 1;
            }
            return 0;
        }
    }
}

