/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.ast;

import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;

public class JDTUtil {
    public static Annotation getAnnotation(String annotationType, BodyDeclaration declaration) {
        List modifiers = declaration.modifiers();
        for (IExtendedModifier modifier : modifiers) {
            if (!modifier.isAnnotation()) continue;
            IAnnotationBinding annotation = ((Annotation)modifier).resolveAnnotationBinding();
            assert (annotation != null) : "Annotation was not resolved. Can this happen in normal opperation?";
            String qualifiedName = annotation.getAnnotationType().getQualifiedName();
            if (!qualifiedName.equals(annotationType)) continue;
            return (Annotation)modifier;
        }
        return null;
    }

    public static IAnnotationBinding getAnnotationBinding(String annotationType, BodyDeclaration declaration) {
        List modifiers = declaration.modifiers();
        for (IExtendedModifier modifier : modifiers) {
            if (!modifier.isAnnotation()) continue;
            IAnnotationBinding annotation = ((Annotation)modifier).resolveAnnotationBinding();
            assert (annotation != null) : "Annotation was not resolved. Can this happen in normal opperation?";
            String qualifiedName = annotation.getAnnotationType().getQualifiedName();
            if (!qualifiedName.equals(annotationType)) continue;
            return annotation;
        }
        return null;
    }

    public static Annotation getAnnotation(String annotationType, SingleVariableDeclaration declaration) {
        List modifiers = declaration.modifiers();
        for (IExtendedModifier modifier : modifiers) {
            if (!modifier.isAnnotation()) continue;
            IAnnotationBinding annotation = ((Annotation)modifier).resolveAnnotationBinding();
            assert (annotation != null) : "Annotation was not resolved. Can this happen in normal opperation?";
            String qualifiedName = annotation.getAnnotationType().getQualifiedName();
            if (!qualifiedName.equals(annotationType)) continue;
            return (Annotation)modifier;
        }
        return null;
    }

    public static IAnnotationBinding getAnnotationBinding(String annotationType, SingleVariableDeclaration declaration) {
        List modifiers = declaration.modifiers();
        for (IExtendedModifier modifier : modifiers) {
            if (!modifier.isAnnotation()) continue;
            IAnnotationBinding annotation = ((Annotation)modifier).resolveAnnotationBinding();
            assert (annotation != null) : "Annotation was not resolved. Can this happen in normal opperation?";
            String qualifiedName = annotation.getAnnotationType().getQualifiedName();
            if (!qualifiedName.equals(annotationType)) continue;
            return annotation;
        }
        return null;
    }

    public static Modifier getModifier(int expectedFlagValue, BodyDeclaration declaration) {
        List modifiers = declaration.modifiers();
        for (IExtendedModifier modifier : modifiers) {
            if (!modifier.isModifier()) continue;
            Modifier.ModifierKeyword modifierKeyword = ((Modifier)modifier).getKeyword();
            assert (modifierKeyword != null) : "ModifierKeyword was not resolved. Can this happen in normal operation?";
            if (expectedFlagValue != modifierKeyword.toFlagValue()) continue;
            return (Modifier)modifier;
        }
        return null;
    }

    public static String getFullyQualifiedTypeForMangledType(String type, IType declaringType) throws JavaModelException {
        type = Signature.toString((String)type);
        return JDTUtil.getFullyQualifiedTypeForType(type, declaringType);
    }

    public static String getFullyQualifiedTypeForType(String type, IType declaringType) throws JavaModelException {
        String[][] resolvedTypes = declaringType.resolveType(type);
        assert (resolvedTypes.length == 1) : "The type cannot be unambigiously resolved. Need to handle this case";
        String[] resolvedType = resolvedTypes[0];
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < resolvedType.length - 1) {
            buffer.append(resolvedType[i]);
            buffer.append('.');
            ++i;
        }
        buffer.append(resolvedType[resolvedType.length - 1]);
        return buffer.toString();
    }
}

