/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.ast;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.common.util.jdt.JavaUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;

public abstract class ElementNamingHelper {
    IJavaProject _javaProject;

    public static ElementNamingHelper create(IType type) {
        assert (type != null);
        return new ITypeElementNamingHelper(type);
    }

    private ElementNamingHelper(IJavaProject javaProject) {
        this._javaProject = javaProject;
    }

    public String getFieldName(String baseName) {
        return this.getFieldName(baseName, new HashSet<String>());
    }

    public String getFieldName(String baseName, Collection<String> excluded) {
        Map options = this._javaProject.getOptions(true);
        String prefix = this.getFirstValue((String)options.get("org.eclipse.jdt.core.codeComplete.fieldPrefixes"));
        String suffix = this.getFirstValue((String)options.get("org.eclipse.jdt.core.codeComplete.fieldSuffixes"));
        excluded.addAll(this.getExistingFieldNames());
        String name = null;
        int i = 0;
        while (excluded.contains(name = this.generateName(baseName, i++, prefix, suffix)) || !JavaUtil.isIdentifier(name)) {
        }
        return name;
    }

    protected abstract Set<String> getExistingFieldNames();

    private String generateName(String base, int count, String prefix, String suffix) {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        sb.append(base);
        if (count > 0) {
            sb.append(count);
        }
        if (suffix != null) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    private String getFirstValue(String stringValue) {
        String first = null;
        if (!StringUtil.isEmpty(stringValue)) {
            char[][] prefixesArray = CharOperation.splitAndTrimOn((char)',', (char[])stringValue.toCharArray());
            first = new String(prefixesArray[0]);
        }
        return first;
    }

    /* synthetic */ ElementNamingHelper(IJavaProject iJavaProject, ElementNamingHelper elementNamingHelper) {
        this(iJavaProject);
    }

    private static class ITypeElementNamingHelper
    extends ElementNamingHelper {
        private IType _type;

        private ITypeElementNamingHelper(IType type) {
            super(type.getJavaProject(), null);
            this._type = type;
        }

        @Override
        protected Set<String> getExistingFieldNames() {
            HashSet<String> existingFieldNames = new HashSet<String>();
            try {
                IField[] fields;
                IField[] iFieldArray = fields = this._type.getFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    IField field = iFieldArray[n2];
                    existingFieldNames.add(field.getElementName());
                    ++n2;
                }
            }
            catch (JavaModelException jme) {
                LoggingService.logFatal("oracle.eclipse.tools.common", (CoreException)((Object)jme));
            }
            return existingFieldNames;
        }
    }
}

