/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util.ast;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.ast.IEditListener;
import oracle.eclipse.tools.common.util.ast.ReaderUtil;
import oracle.eclipse.tools.common.util.ast.WriterContext;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditProcessor;

public class EditUtil {
    private static List<IEditListener> _listeners = new ArrayList<IEditListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGlobalEditListener(IEditListener listener) {
        assert (listener != null);
        List<IEditListener> list = _listeners;
        synchronized (list) {
            if (!_listeners.contains(listener)) {
                _listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeGlobalEditListener(IEditListener listener) {
        List<IEditListener> list = _listeners;
        synchronized (list) {
            _listeners.remove(listener);
        }
    }

    public static WriterContext startEdit(ICompilationUnit icu) throws CoreException {
        assert (icu != null) : "Must provide an ICompilationUnit";
        EditUtil.notifyListenersOfStartEdit(icu);
        boolean commit = false;
        if (!icu.isWorkingCopy()) {
            commit = true;
            icu = icu.getWorkingCopy(null);
        }
        CompilationUnit cu = ReaderUtil.parse(icu, true);
        ASTRewrite astRewrite = ASTRewrite.create((AST)cu.getAST());
        return new WriterContext(icu, astRewrite, cu, commit);
    }

    public static WriterContext startEdit(ICompilationUnit icu, ASTNode node) throws CoreException {
        ASTNode root;
        assert (icu != null) : "Must provide an ICompilationUnit";
        assert (node != null) : "Must provide an ASTNode";
        assert (node.getAST() != null) : "Must provide an ASTNode that already belongs to an AST";
        assert (node.getRoot() instanceof CompilationUnit) : "Must provide an ASTNode that belongs to an AST rooted in a CompilationUnit";
        EditUtil.notifyListenersOfStartEdit(icu);
        boolean commit = false;
        if (!icu.isWorkingCopy()) {
            commit = true;
            icu = icu.getWorkingCopy(null);
        }
        CompilationUnit cu = (root = node.getRoot()) instanceof CompilationUnit ? (CompilationUnit)root : null;
        ASTRewrite astRewrite = ASTRewrite.create((AST)node.getAST());
        return new WriterContext(icu, astRewrite, cu, commit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyListenersOfStartEdit(ICompilationUnit icu) {
        ArrayList<IEditListener> listenersCopy = null;
        List<IEditListener> list = _listeners;
        synchronized (list) {
            listenersCopy = new ArrayList<IEditListener>(_listeners);
        }
        for (IEditListener listener : listenersCopy) {
            try {
                listener.editStarted(icu);
            }
            catch (Throwable t) {
                EditUtil.removeGlobalEditListener(listener);
                LoggingService.logError("oracle.eclipse.tools.common", "removing bad IEditListener: " + t.getLocalizedMessage());
                LoggingService.logException("oracle.eclipse.tools.common", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyListenersOfEndEdit(ICompilationUnit icu) {
        ArrayList<IEditListener> listenersCopy = null;
        List<IEditListener> list = _listeners;
        synchronized (list) {
            listenersCopy = new ArrayList<IEditListener>(_listeners);
        }
        for (IEditListener listener : listenersCopy) {
            try {
                listener.editEnded(icu);
            }
            catch (Throwable t) {
                EditUtil.removeGlobalEditListener(listener);
                LoggingService.logError("oracle.eclipse.tools.common", "removing bad IEditListener: " + t.getLocalizedMessage());
                LoggingService.logException("oracle.eclipse.tools.common", t);
            }
        }
    }

    public static ITextFileBuffer acquire(ICompilationUnit unit) throws CoreException {
        IResource resource = unit.getResource();
        assert (resource != null) : "Expected a non-null resource for an ICompilationUnit";
        assert (resource.getType() == 1) : "Expected an IFile resource for an ICompilationUnit";
        IPath path = resource.getFullPath();
        FileBuffers.getTextFileBufferManager().connect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        return FileBuffers.getTextFileBufferManager().getTextFileBuffer(path, LocationKind.IFILE);
    }

    public static void endEdit(WriterContext ctx) throws BadLocationException, JavaModelException, CoreException {
        assert (ctx != null) : "Must provide a WriterContext";
        ITextFileBuffer buffer = null;
        IResource resource = ctx.getICompilationUnit().getResource();
        IPath path = resource.getFullPath();
        DocumentRewriteSession session = null;
        IDocument doc = null;
        ISchedulingRule rule = null;
        try {
            assert (resource.getType() == 1) : "Expected an IFile resource for an ICompilationUnit";
            FileBuffers.getTextFileBufferManager().connect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(path, LocationKind.IFILE);
            rule = buffer.computeCommitRule();
            Job.getJobManager().beginRule(rule, (IProgressMonitor)new NullProgressMonitor());
            doc = buffer.getDocument();
            TextEdit edits = ctx.getASTRewrite().rewriteAST(doc, null);
            if (doc instanceof IDocumentExtension4 && ((IDocumentExtension4)doc).getActiveRewriteSession() == null) {
                session = ((IDocumentExtension4)doc).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
            }
            TextEditProcessor proc = new TextEditProcessor(doc, edits, 3);
            proc.performEdits();
            if (ctx.shouldCommit()) {
                buffer.commit(null, false);
                ctx.getICompilationUnit().discardWorkingCopy();
            }
        }
        catch (Throwable throwable) {
            if (session != null) {
                ((IDocumentExtension4)doc).stopRewriteSession(session);
            }
            FileBuffers.getTextFileBufferManager().disconnect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            if (rule != null) {
                Job.getJobManager().endRule(rule);
            }
            EditUtil.notifyListenersOfEndEdit(ctx.getICompilationUnit());
            throw throwable;
        }
        if (session != null) {
            ((IDocumentExtension4)doc).stopRewriteSession(session);
        }
        FileBuffers.getTextFileBufferManager().disconnect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        if (rule != null) {
            Job.getJobManager().endRule(rule);
        }
        EditUtil.notifyListenersOfEndEdit(ctx.getICompilationUnit());
    }
}

