/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.util.DomUtil;
import org.w3c.dom.Element;

public final class TreeNode {
    private static final String NL = System.getProperty("line.separator");
    private String name;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Map<String, Object> attributesReadOnly = Collections.unmodifiableMap(this.attributes);
    private final List<TreeNode> children = new ArrayList<TreeNode>();
    private final List<TreeNode> childrenReadOnly = Collections.unmodifiableList(this.children);

    public TreeNode() {
    }

    public TreeNode(String name) {
        this.name = name;
    }

    public TreeNode(String name, TreeNode parent) {
        this.name = name;
        parent.addChildNode(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Object> getAttributes() {
        return this.attributesReadOnly;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public List<TreeNode> getChildNodes() {
        return this.childrenReadOnly;
    }

    public List<TreeNode> getChildNodes(String name) {
        ArrayList<TreeNode> res = new ArrayList<TreeNode>();
        for (TreeNode node : this.children) {
            if (!node.getName().equals(name)) continue;
            res.add(node);
        }
        return res;
    }

    public TreeNode getChildNode(String name) {
        for (TreeNode node : this.children) {
            if (!node.getName().equals(name)) continue;
            return node;
        }
        return null;
    }

    public void addChildNode(TreeNode node) {
        this.children.add(node);
    }

    public void removeChildNode(TreeNode node) {
        this.children.remove(node);
    }

    public void read(Reader r) throws IOException {
        this.read(DomUtil.root(r));
    }

    private void read(Element el) {
        this.name = el.getAttribute("name");
        for (Element x : DomUtil.elements(el, "attribute")) {
            String name = x.getAttribute("name");
            String value = x.getAttribute("value");
            this.attributes.put(name, value);
        }
        for (Element x : DomUtil.elements(el, "node")) {
            TreeNode node = new TreeNode();
            node.read(x);
            this.children.add(node);
        }
    }

    public void write(Writer w) throws IOException {
        w.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        w.write(NL);
        this.write(w, "");
    }

    private void write(Writer w, String indent) throws IOException {
        w.write(indent);
        w.write("<node name=\"");
        w.write(this.name);
        w.write("\">");
        w.write(NL);
        String subindent = String.valueOf(indent) + "  ";
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            w.write(subindent);
            w.write("<attribute name=\"");
            w.write(entry.getKey());
            w.write("\" value=\"");
            w.write(entry.getValue().toString());
            w.write("\"/>");
            w.write(NL);
        }
        for (TreeNode child : this.children) {
            child.write(w, subindent);
        }
        w.write(indent);
        w.write("</node>");
        w.write(NL);
    }
}

