/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import oracle.eclipse.tools.common.wtp.java.core.internal.CommonWtpJavaExtensionsPlugin;

public class StringEncrypter {
    private static StringEncrypter instance = null;
    private Cipher ecipher;
    private Cipher dcipher;

    StringEncrypter(SecretKey key, String algorithm) {
        try {
            this.ecipher = Cipher.getInstance(algorithm);
            this.dcipher = Cipher.getInstance(algorithm);
            this.ecipher.init(1, key);
            this.dcipher.init(2, key);
        }
        catch (NoSuchPaddingException e) {
            CommonWtpJavaExtensionsPlugin.logException(e);
        }
        catch (NoSuchAlgorithmException e) {
            CommonWtpJavaExtensionsPlugin.logException(e);
        }
        catch (InvalidKeyException e) {
            CommonWtpJavaExtensionsPlugin.logException(e);
        }
    }

    StringEncrypter(String passPhrase) {
        byte[] salt = new byte[]{-87, -101, -56, 50, 86, 52, -29, 3};
        int iterationCount = 19;
        try {
            PBEKeySpec keySpec = new PBEKeySpec(passPhrase.toCharArray(), salt, iterationCount);
            SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
            this.ecipher = Cipher.getInstance(key.getAlgorithm());
            this.dcipher = Cipher.getInstance(key.getAlgorithm());
            PBEParameterSpec paramSpec = new PBEParameterSpec(salt, iterationCount);
            this.ecipher.init(1, (Key)key, paramSpec);
            this.dcipher.init(2, (Key)key, paramSpec);
        }
        catch (InvalidAlgorithmParameterException e) {
            CommonWtpJavaExtensionsPlugin.logException(e);
        }
        catch (InvalidKeySpecException e) {
            CommonWtpJavaExtensionsPlugin.logException(e);
        }
        catch (NoSuchPaddingException e) {
            CommonWtpJavaExtensionsPlugin.logException(e);
        }
        catch (NoSuchAlgorithmException e) {
            CommonWtpJavaExtensionsPlugin.logException(e);
        }
        catch (InvalidKeyException e) {
            CommonWtpJavaExtensionsPlugin.logException(e);
        }
    }

    public static StringEncrypter getInstance() {
        if (instance == null) {
            instance = new StringEncrypter("kAWudr5swuwuRU4Eje9a");
        }
        return instance;
    }

    private String asHex(byte[] buf) {
        StringBuffer strbuf = new StringBuffer(buf.length * 2);
        int i = 0;
        while (i < buf.length) {
            if ((buf[i] & 0xFF) < 16) {
                strbuf.append("0");
            }
            strbuf.append(Long.toString(buf[i] & 0xFF, 16));
            ++i;
        }
        return strbuf.toString();
    }

    private byte[] fromHex(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        int i = 0;
        while (i < len) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            i += 2;
        }
        return data;
    }

    public String encrypt(String str) {
        try {
            byte[] utf8 = str.getBytes("UTF8");
            byte[] enc = this.ecipher.doFinal(utf8);
            return this.asHex(enc);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String decrypt(String str) {
        try {
            byte[] dec = this.fromHex(str);
            byte[] utf8 = this.dcipher.doFinal(dec);
            return new String(utf8, "UTF8");
        }
        catch (Exception exception) {
            return null;
        }
    }
}

