/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.jdt.JavaProjectUtil;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;

public class ProjectUtil {
    public static final String DOT_PROJECT_FILE = ".project";

    public static void replaceNature(IProject project, String oldNatureId, String newNatureId) throws CoreException {
        IProjectDescription pdesc = project.getDescription();
        String[] oldNatureIds = pdesc.getNatureIds();
        String[] newNatureIds = null;
        int i = 0;
        while (i < oldNatureIds.length) {
            String natureId = oldNatureIds[i];
            if (natureId.equals(oldNatureId)) {
                if (newNatureIds == null) {
                    newNatureIds = new String[oldNatureIds.length];
                    System.arraycopy(oldNatureIds, 0, newNatureIds, 0, oldNatureIds.length);
                }
                newNatureIds[i] = newNatureId;
            }
            ++i;
        }
        if (newNatureIds != null) {
            pdesc.setNatureIds(newNatureIds);
            project.setDescription(pdesc, null);
        }
    }

    public static void addNature(IProject proj, String natureId) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        boolean addNature = true;
        int i = 0;
        while (i < prevNatures.length) {
            String nature = prevNatures[i];
            if (nature.equals(natureId)) {
                addNature = false;
                break;
            }
            ++i;
        }
        if (addNature) {
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 1, prevNatures.length);
            newNatures[0] = natureId;
            description.setNatureIds(newNatures);
            proj.setDescription(description, 1, null);
        }
    }

    public static void removeNature(IProject project, String oldNatureId) throws CoreException {
        IProjectDescription pdesc = project.getDescription();
        String[] oldNatureIds = pdesc.getNatureIds();
        String[] newNatureIds = null;
        int i = 0;
        while (i < oldNatureIds.length) {
            String natureId = oldNatureIds[i];
            if (natureId.equals(oldNatureId) && newNatureIds == null) {
                newNatureIds = new String[oldNatureIds.length - 1];
                System.arraycopy(oldNatureIds, 0, newNatureIds, 0, i);
                if (i >= oldNatureIds.length - 1) break;
                System.arraycopy(oldNatureIds, i + 1, newNatureIds, i, oldNatureIds.length - i - 1);
                break;
            }
            ++i;
        }
        if (newNatureIds != null) {
            pdesc.setNatureIds(newNatureIds);
            project.setDescription(pdesc, null);
        }
    }

    public static boolean hasBuilder(IProject project, String builderId) throws CoreException {
        ICommand[] existingBuildSpec;
        IProjectDescription pdesc = project.getDescription();
        ICommand[] iCommandArray = existingBuildSpec = pdesc.getBuildSpec();
        int n = existingBuildSpec.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand cmd = iCommandArray[n2];
            String bid = cmd.getBuilderName();
            if (bid != null && bid.equals(builderId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void addBuilder(IProject project, String builderId) throws CoreException {
        ICommand[] existingBuildSpec;
        IProjectDescription pdesc = project.getDescription();
        ICommand[] iCommandArray = existingBuildSpec = pdesc.getBuildSpec();
        int n = existingBuildSpec.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand cmd = iCommandArray[n2];
            if (cmd.getBuilderName().equals(builderId)) {
                return;
            }
            ++n2;
        }
        ICommand[] newBuildSpec = new ICommand[existingBuildSpec.length + 1];
        System.arraycopy(existingBuildSpec, 0, newBuildSpec, 0, existingBuildSpec.length);
        ICommand newCommand = pdesc.newCommand();
        newCommand.setBuilderName(builderId);
        newBuildSpec[newBuildSpec.length - 1] = newCommand;
        pdesc.setBuildSpec(newBuildSpec);
        project.setDescription(pdesc, null);
    }

    public static void removeBuilder(IProject project, String builderId) throws CoreException {
        IProjectDescription pdesc = project.getDescription();
        ArrayList<ICommand> newBuildSpec = new ArrayList<ICommand>();
        ICommand[] iCommandArray = pdesc.getBuildSpec();
        int n = iCommandArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand cmd = iCommandArray[n2];
            String bid = cmd.getBuilderName();
            if (bid == null || !bid.equals(builderId)) {
                newBuildSpec.add(cmd);
            }
            ++n2;
        }
        ICommand[] newBuildSpecArray = newBuildSpec.toArray(new ICommand[newBuildSpec.size()]);
        pdesc.setBuildSpec(newBuildSpecArray);
        project.setDescription(pdesc, null);
    }

    public static void runBuilder(IProject project, String builderId, IProgressMonitor monitor) throws CoreException {
        ICommand builder = ProjectUtil.getCommand(project, builderId);
        if (builder != null) {
            project.build(10, builderId, builder.getArguments(), monitor);
        }
    }

    public static void scheduleIncrementalBuild(Set<IProject> projects) {
        ProjectUtil.scheduleBuild(projects, 10);
    }

    public static void scheduleFullBuild(Set<IProject> projects) {
        ProjectUtil.scheduleBuild(projects, 6);
    }

    public static void scheduleCleanBuild(Set<IProject> projects) {
        ProjectUtil.scheduleBuild(projects, 15);
    }

    public static void scheduleBuild(final Set<IProject> projects, final int buildKind) {
        final IWorkspace ws = ResourcesPlugin.getWorkspace();
        WorkspaceJob job = new WorkspaceJob(Resources.buildJobName){

            public boolean belongsTo(Object family) {
                return family.equals(ResourcesPlugin.FAMILY_MANUAL_BUILD);
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                MultiStatus errors = null;
                monitor.beginTask("", projects.size() * 1000);
                try {
                    IProject[] pjarray = projects.toArray(new IProject[projects.size()]);
                    IWorkspace.ProjectOrder order = ws.computeProjectOrder(pjarray);
                    IProject[] iProjectArray = order.projects;
                    int n = order.projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject project = iProjectArray[n2];
                        try {
                            project.build(buildKind, ProgressMonitorUtil.submon(monitor, 1000));
                        }
                        catch (CoreException e) {
                            errors = this.recordError(errors, e);
                        }
                        ++n2;
                    }
                }
                finally {
                    monitor.done();
                }
                return errors == null ? Status.OK_STATUS : errors;
            }

            private MultiStatus recordError(MultiStatus errors, CoreException error) {
                if (errors == null) {
                    errors = new MultiStatus("oracle.eclipse.tools.common", 4, Resources.buildFailed, null);
                }
                errors.merge(error.getStatus());
                return errors;
            }
        };
        job.setRule(ws.getRuleFactory().buildRule());
        job.schedule();
    }

    private static ICommand getCommand(IProject project, String builderId) throws CoreException {
        IProjectDescription description = project.getDescription();
        if (description == null) {
            return null;
        }
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderId)) {
                return commands[i];
            }
            ++i;
        }
        return null;
    }

    public static List<Node<IProject>> getProjectReferenceGraph() throws CoreException, CircularReferencesException {
        HashMap projectReferences = new HashMap();
        IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = wsroot.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                HashSet<IProject> references = new HashSet<IProject>();
                projectReferences.put(project, references);
                IProject[] iProjectArray2 = project.getDescription().getReferencedProjects();
                int n3 = iProjectArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProject refpj = iProjectArray2[n4];
                    if (refpj.isAccessible()) {
                        references.add(refpj);
                    }
                    ++n4;
                }
                if (JavaProjectUtil.isJavaProject(project)) {
                    IJavaProject jproj = JavaCore.create((IProject)project);
                    IClasspathEntry[] iClasspathEntryArray = jproj.getResolvedClasspath(true);
                    int n5 = iClasspathEntryArray.length;
                    n3 = 0;
                    while (n3 < n5) {
                        String refpjname;
                        IProject refpj;
                        IClasspathEntry cpe = iClasspathEntryArray[n3];
                        if (cpe.getEntryKind() == 2 && (refpj = wsroot.getProject(refpjname = cpe.getPath().segment(0))).isAccessible()) {
                            references.add(refpj);
                        }
                        ++n3;
                    }
                }
            }
            ++n2;
        }
        ArrayList<Node<IProject>> graph = new ArrayList<Node<IProject>>();
        while (!projectReferences.isEmpty()) {
            ArrayList<IProject> toRemove = new ArrayList<IProject>();
            for (Map.Entry entry : projectReferences.entrySet()) {
                IProject project = (IProject)entry.getKey();
                ArrayList refnodes = new ArrayList();
                boolean foundAll = true;
                for (IProject refpj : (Set)entry.getValue()) {
                    Node<IProject> refpjnode = ProjectUtil.findProjectInGraph(graph, refpj);
                    if (refpjnode == null) {
                        foundAll = false;
                        break;
                    }
                    refnodes.add(refpjnode);
                }
                if (!foundAll) continue;
                Node<Object> pjnode = new Node<Object>();
                pjnode.setElement(project);
                pjnode.setChildren(refnodes);
                graph.removeAll(refnodes);
                graph.add(pjnode);
                toRemove.add(project);
            }
            if (toRemove.isEmpty()) {
                throw new CircularReferencesException();
            }
            for (IProject iProject : toRemove) {
                projectReferences.remove(iProject);
            }
        }
        return graph;
    }

    private static Node<IProject> findProjectInGraph(List<Node<IProject>> graph, IProject project) {
        for (Node<IProject> node : graph) {
            if (node.getElement().equals((Object)project)) {
                return node;
            }
            Node<IProject> res = ProjectUtil.findProjectInGraph(node.getChildren(), project);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public static final class CircularReferencesException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static class Node<T> {
        private T element = null;
        private List<Node<T>> children = new ArrayList<Node<T>>();
        private List<Node<T>> childrenReadOnly = Collections.unmodifiableList(this.children);

        public synchronized T getElement() {
            return this.element;
        }

        public synchronized void setElement(T element) {
            this.element = element;
        }

        public synchronized boolean hasChildren() {
            return !this.children.isEmpty();
        }

        public synchronized Collection<Node<T>> getAllChildren() {
            ArrayList<Node<T>> results = new ArrayList<Node<T>>();
            this.getAllChildren(results);
            return results;
        }

        private synchronized void getAllChildren(List<Node<T>> results) {
            for (Node<T> node : this.children) {
                results.add(node);
                super.getAllChildren(results);
            }
        }

        public synchronized List<Node<T>> getChildren() {
            return this.childrenReadOnly;
        }

        public synchronized void setChildren(List<Node<T>> children) {
            this.children.clear();
            this.children.addAll(children);
        }

        public synchronized Node<T> getChild(int index) {
            return this.children.get(index);
        }

        public synchronized void setChild(int index, Node<T> node) {
            this.children.set(index, node);
        }

        public synchronized void addChild(Node<T> child) {
            this.children.add(child);
        }

        public synchronized void removeChild(Node<T> child) {
            this.children.remove(child);
        }

        public synchronized Node<T> convertDagToTree() {
            HashSet<Node<T>> markedNodes = new HashSet<Node<T>>();
            return this.convertDagToTree(markedNodes);
        }

        private synchronized Node<T> convertDagToTree(Set<Node<T>> markedNodes) {
            Node<T> node = this;
            if (markedNodes.contains(this)) {
                node = new Node<T>();
                node.setElement(this.element);
                node.setChildren(this.children);
            }
            markedNodes.add(node);
            int i = 0;
            int n = node.getChildren().size();
            while (i < n) {
                Node<T> y;
                Node<T> x = node.getChild(i);
                if (x != (y = super.convertDagToTree(markedNodes))) {
                    node.setChild(i, y);
                }
                ++i;
            }
            return node;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            this.toString(buf, "");
            return buf.toString();
        }

        private void toString(StringBuilder buf, String indent) {
            buf.append(indent);
            buf.append(this.element == null ? "<null>" : this.element.toString());
            buf.append(' ');
            buf.append(this.hashCode());
            buf.append('\n');
            String childIndent = String.valueOf(indent) + "  ";
            for (Node<T> child : this.children) {
                super.toString(buf, childIndent);
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String buildJobName;
        public static String buildFailed;

        static {
            Resources.initializeMessages((String)ProjectUtil.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

