/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    protected final int _cacheSize;
    protected final CacheStats _cacheStats;

    public LRUCache(int cacheSize, CacheStats cacheStats) {
        super(cacheSize + 1, 1.0f, true);
        this._cacheSize = cacheSize;
        this._cacheStats = cacheStats;
    }

    public LRUCache(int cacheSize) {
        this(cacheSize, new NullCacheStats());
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        boolean shouldRemove;
        boolean bl = shouldRemove = this.size() > this._cacheSize;
        if (shouldRemove) {
            this._cacheStats.incNumRemovals();
        }
        return shouldRemove;
    }

    public void dumpStats() {
        System.out.printf("Max Cache Size: %d, Cache Size: %d, Removals: %d, Misses: %d%n", this._cacheSize, this.size(), this._cacheStats.numRemovals, this._cacheStats.numMisses);
    }

    public static class CacheStats {
        protected int numRemovals = 0;
        protected int numMisses = 0;

        public void incNumRemovals() {
            ++this.numRemovals;
        }

        public void incNumMisses() {
            ++this.numMisses;
        }

        public int getNumRemovals() {
            return this.numRemovals;
        }

        public int getNumMisses() {
            return this.numMisses;
        }
    }

    public static class NullCacheStats
    extends CacheStats {
        public NullCacheStats() {
            this.numRemovals = -999;
            this.numMisses = -999;
        }

        @Override
        public void incNumRemovals() {
        }

        @Override
        public void incNumMisses() {
        }
    }
}

