/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import oracle.eclipse.tools.common.util.IModel;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractModel
implements IModel {
    private final Set<IModel.IListener> globalListeners = new CopyOnWriteArraySet<IModel.IListener>();
    private final Map<String, Set<IModel.IListener>> propertySpecificListeners = new HashMap<String, Set<IModel.IListener>>();

    @Override
    public IStatus validate() {
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addListener(IModel.IListener listener, String ... properties) {
        if (properties.length == 0) {
            Set<IModel.IListener> set = this.globalListeners;
            synchronized (set) {
                this.globalListeners.add(listener);
            }
        }
        Map<String, Set<IModel.IListener>> map = this.propertySpecificListeners;
        synchronized (map) {
            String[] stringArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                String property = stringArray[n2];
                Set<IModel.IListener> list = this.propertySpecificListeners.get(property);
                if (list == null) {
                    list = new CopyOnWriteArraySet<IModel.IListener>();
                    this.propertySpecificListeners.put(property, list);
                }
                list.add(listener);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeListener(IModel.IListener listener) {
        boolean globalListenerRemoveResult;
        Object object = this.globalListeners;
        synchronized (object) {
            globalListenerRemoveResult = this.globalListeners.remove(listener);
        }
        if (!globalListenerRemoveResult) {
            object = this.propertySpecificListeners;
            synchronized (object) {
                for (Set<IModel.IListener> listeners : this.propertySpecificListeners.values()) {
                    listeners.remove(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyListeners(String property, Object oldValue, Object newValue) {
        Set<IModel.IListener> listeners;
        for (IModel.IListener listener : this.globalListeners) {
            listener.propertyChanged(property, oldValue, newValue);
        }
        Map<String, Set<IModel.IListener>> map = this.propertySpecificListeners;
        synchronized (map) {
            listeners = this.propertySpecificListeners.get(property);
        }
        if (listeners != null) {
            for (IModel.IListener listener : listeners) {
                listener.propertyChanged(property, oldValue, newValue);
            }
        }
    }

    protected static final String createPropertyIsReadOnlyMessage(String property) {
        return NLS.bind((String)Resources.propertyIsReadOnly, (Object)property);
    }

    private static final class Resources
    extends NLS {
        public static String propertyIsReadOnly;

        static {
            Resources.initializeMessages((String)AbstractModel.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

