/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.operations;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.operations.AbstractBasicOperation;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.wtp.webxml.WebXmlUtils;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class RemoveNodeOperation
extends AbstractBasicOperation {
    private IProject _project;
    private List<NodeDescription> nodeDescriptionList = null;

    public RemoveNodeOperation(IProject _project) {
        super(Strings.operationLabel);
        this._project = _project;
    }

    public void addNodes(String nodeName, String childNodeName, String childNodeValue) {
        if (this.nodeDescriptionList == null) {
            this.nodeDescriptionList = new ArrayList<NodeDescription>();
        }
        this.nodeDescriptionList.add(new NodeDescription(nodeName, childNodeName, childNodeValue));
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.nodeDescriptionList == null) {
            return Status.OK_STATUS;
        }
        ProgressMonitorUtil.beginTask(monitor, 10);
        try {
            try {
                IDOMModel model = WebXmlUtils.getWebXmlModelForEdit(this._project);
                model.aboutToChangeModel();
                for (NodeDescription description : this.nodeDescriptionList) {
                    WebXmlUtils.removeNodes(model, description.getNodeName(), description.getChildNodeName(), description.getChildNodeValue());
                }
                WebXmlUtils.saveWebXmlModel(model);
                model.changedModel();
                ProgressMonitorUtil.worked(monitor, 10);
            }
            catch (CoreException coreException) {
                IStatus iStatus = Status.CANCEL_STATUS;
                ProgressMonitorUtil.done(monitor);
                return iStatus;
            }
        }
        finally {
            ProgressMonitorUtil.done(monitor);
        }
        return Status.OK_STATUS;
    }

    private static class NodeDescription {
        private final String _nodeName;
        private final String _childNodeName;
        private final String _childNodeValue;

        public NodeDescription(String _nodeName, String _childNodeName, String _childNodeValue) {
            this._nodeName = _nodeName;
            this._childNodeName = _childNodeName;
            this._childNodeValue = _childNodeValue;
        }

        public String getNodeName() {
            return this._nodeName;
        }

        public String getChildNodeName() {
            return this._childNodeName;
        }

        public String getChildNodeValue() {
            return this._childNodeValue;
        }
    }

    private static final class Strings
    extends NLS {
        public static String operationLabel;

        static {
            Strings.initializeMessages((String)RemoveNodeOperation.class.getName(), Strings.class);
        }

        private Strings() {
        }
    }
}

