/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.operations;

import java.util.Iterator;
import oracle.eclipse.tools.common.operations.AbstractBasicOperation;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationType;
import org.eclipse.jst.jsf.facesconfig.emf.DefaultRenderKitIdType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.osgi.util.NLS;

public class RemoveDefaultRenderKitOperation
extends AbstractBasicOperation {
    private final String defaultRenderKitId;
    private final IProject project;
    private final String facesConfigurationFilePath;

    public RemoveDefaultRenderKitOperation(String defaultRenderKitId, IProject project, String facesConfigurationFilePath) {
        super(NLS.bind((String)Strings.operationLabel, (Object)defaultRenderKitId));
        this.defaultRenderKitId = defaultRenderKitId;
        this.project = project;
        this.facesConfigurationFilePath = facesConfigurationFilePath;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ProgressMonitorUtil.beginTask(monitor, 1);
        FacesConfigArtifactEdit facesConfigArtifactEdit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite((IProject)this.project, (String)this.facesConfigurationFilePath);
        if (facesConfigArtifactEdit.getFacesConfig() == null) {
            throw new IllegalArgumentException("FacesConfigArtifactEdit is expected to be non-null");
        }
        try {
            Iterator application = facesConfigArtifactEdit.getFacesConfig().getApplication().iterator();
            while (application.hasNext()) {
                Iterator kit = ((ApplicationType)application.next()).getDefaultRenderKitId().iterator();
                while (kit.hasNext()) {
                    if (!((DefaultRenderKitIdType)kit.next()).getTextContent().equals(this.defaultRenderKitId)) continue;
                    kit.remove();
                }
            }
            facesConfigArtifactEdit.save(ProgressMonitorUtil.submon(monitor, 1));
        }
        finally {
            ProgressMonitorUtil.done(monitor);
            if (facesConfigArtifactEdit != null) {
                facesConfigArtifactEdit.dispose();
                assert (facesConfigArtifactEdit.isDisposed());
            }
        }
        return Status.OK_STATUS;
    }

    private static final class Strings
    extends NLS {
        public static String operationLabel;

        static {
            Strings.initializeMessages((String)RemoveDefaultRenderKitOperation.class.getName(), Strings.class);
        }

        private Strings() {
        }
    }
}

